/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.validation.core.errorinfo;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionDelegate;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationMessage;
import org.eclipse.wst.xml.ui.internal.validation.core.errorinfo.ReferencedFileErrorDialog;

public class ReferencedFileErrorActionDelegate
extends ActionDelegate
implements IObjectActionDelegate {
    protected IMarker selectedMarker;
    protected ResourceBundle resourceBundle = ResourceBundle.getBundle("org.eclipse.wst.xml.ui.internal.validation.xmlvalidation");

    public void run(IAction action) {
        if (this.selectedMarker != null) {
            try {
                Map map = (Map)this.selectedMarker.getResource().getSessionProperty(ValidationMessage.ERROR_MESSAGE_MAP_QUALIFIED_NAME);
                if (map == null) {
                    String infoUnavailable = this.resourceBundle.getString("_UI_DETAILS_INFORMATION_UNAVAILABLE");
                    String revalidateToRegenerateErrors = this.resourceBundle.getString("_UI_DETAILS_INFO_REVALIDATE_TO_REGENERATE");
                    MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)infoUnavailable, (String)revalidateToRegenerateErrors);
                } else {
                    String uri = null;
                    String groupName = (String)this.selectedMarker.getAttribute("groupName");
                    if (groupName.startsWith("referencedFileError")) {
                        int index1 = groupName.indexOf("(");
                        int index2 = groupName.lastIndexOf(")");
                        if (index1 != -1 && index2 > index1) {
                            uri = groupName.substring(index1 + 1, index2);
                        }
                    }
                    if (uri != null) {
                        List list = Collections.EMPTY_LIST;
                        ValidationMessage message = (ValidationMessage)map.get(uri);
                        if (message != null) {
                            list = message.getNestedMessages();
                        }
                        String validatedFileURI = this.selectedMarker.getResource().getLocation().toOSString();
                        validatedFileURI = "file:/" + validatedFileURI;
                        ReferencedFileErrorDialog dialog = new ReferencedFileErrorDialog(Display.getCurrent().getActiveShell(), list, validatedFileURI, uri);
                        dialog.createAndOpen();
                    }
                }
            }
            catch (CoreException coreException) {}
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        this.selectedMarker = null;
        if (selection instanceof IStructuredSelection) {
            try {
                IMarker marker;
                Object first = ((IStructuredSelection)selection).getFirstElement();
                this.selectedMarker = marker = (IMarker)first;
            }
            catch (Exception exception) {}
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }
}

