/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.internal.outputview;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.rdb.internal.outputview.OutputViewPlugin;

public class DialogShowXMLField
extends Dialog {
    protected String xmlText;
    protected String dialogTitle;
    protected Browser myBrowser;
    protected Button btnClose;
    protected Button btnSaveAs;
    private File temporaryFile;

    public DialogShowXMLField(Shell shell, String title, String text) {
        super(shell);
        this.xmlText = text;
        this.dialogTitle = title;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.dialogTitle);
    }

    public int open() {
        this.setShellStyle(this.getShellStyle() | 0x10);
        return super.open();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.widthHint = 480;
        gridData.heightHint = 300;
        TabFolder tabFolder = new TabFolder(composite, 1024);
        tabFolder.setLayoutData((Object)gridData);
        this.createRenderedTextTabItem(tabFolder);
        this.createSourceTabItem(tabFolder);
        return composite;
    }

    private void createSourceTabItem(TabFolder parent) {
        Text sourceText = new Text((Composite)parent, 586);
        sourceText.setText(this.xmlText);
        TabItem item = new TabItem(parent, 0);
        item.setText(OutputViewPlugin.getString("XML_DIALOG_SOURCE"));
        item.setControl((Control)sourceText);
    }

    private void createRenderedTextTabItem(TabFolder parent) {
        this.myBrowser = new Browser((Composite)parent, 8);
        this.temporaryFile = this.getTempFile();
        if (this.temporaryFile != null) {
            try {
                this.writeStringToFile(this.xmlText, this.temporaryFile.getAbsolutePath());
                String url = this.temporaryFile.toURL().toString();
                this.myBrowser.setUrl(url);
            }
            catch (Exception exception) {
                this.myBrowser.setText(this.xmlText);
            }
        } else {
            this.myBrowser.setText(this.xmlText);
        }
        TabItem item = new TabItem(parent, 0);
        item.setText(OutputViewPlugin.getString("XML_DIALOG_BROWSER"));
        item.setControl((Control)this.myBrowser);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.btnSaveAs = this.createButton(parent, 0, OutputViewPlugin.getString("OV_MESSAGE_SAVE_AS"), false);
        this.btnClose = this.createButton(parent, 1, IDialogConstants.CLOSE_LABEL, false);
    }

    protected void okPressed() {
        this.saveOutput();
    }

    protected void cancelPressed() {
        if (this.temporaryFile != null) {
            this.temporaryFile.delete();
        }
        super.cancelPressed();
    }

    protected void handleShellCloseEvent() {
        super.handleShellCloseEvent();
        if (this.temporaryFile != null) {
            this.temporaryFile.delete();
        }
    }

    protected void displayDirectoryError(Shell aShell, String aFile) {
        Object[] obj = new Object[]{aFile};
        String message = OutputViewPlugin.getString("OV_MESSAGE_FILE_ISDIRECTORY_DESC", obj);
        MessageBox box = new MessageBox(aShell, 33);
        box.setText(OutputViewPlugin.getString("OV_MESSAGE_FILE_ISDIRECTORY_TITLE"));
        box.setMessage(message);
        box.open();
        this.saveOutput();
    }

    private void saveOutput() {
        FileDialog fileDialog = new FileDialog(this.getShell(), 8192);
        String fileName = fileDialog.open();
        if (fileName != null) {
            try {
                File file = new File(fileName);
                if (file.isDirectory()) {
                    this.displayDirectoryError(this.getShell(), fileName);
                    return;
                }
                if (file.exists()) {
                    Object[] obj = new Object[]{fileName};
                    String message = OutputViewPlugin.getString("OV_MESSAGE_FILE_EXISTS_DESC", obj);
                    MessageBox box = new MessageBox(this.getShell(), 192);
                    box.setText(OutputViewPlugin.getString("OV_MESSAGE_FILE_EXISTS_TITLE"));
                    box.setMessage(message);
                    if (box.open() != 64) {
                        return;
                    }
                }
                BufferedWriter bw = new BufferedWriter(new FileWriter(file));
                bw.write(this.xmlText);
                bw.flush();
                bw.close();
            }
            catch (IOException ex) {
                MessageBox box = new MessageBox(this.getShell(), 1);
                box.setText(OutputViewPlugin.getString("OV_STATUS_ERROR"));
                box.setMessage(ex.getMessage());
                box.open();
            }
        }
    }

    private void writeStringToFile(String content, String fileName) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));
        writer.write(content);
        writer.flush();
        writer.close();
    }

    private File getTempFile() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if (root != null) {
            try {
                File rootFile = root.getLocation().toFile();
                StringBuffer sb = new StringBuffer(rootFile.getAbsolutePath());
                sb.append(System.getProperty("file.separator")).append("XML_").append(System.currentTimeMillis()).append(".html");
                File tempFile = new File(sb.toString());
                return tempFile;
            }
            catch (Exception ex) {
                OutputViewPlugin.getPlugin().writeLog(4, 0, "DialogShowXMLField:getTempFile()", ex);
                return null;
            }
        }
        return null;
    }
}

