/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.internal.enablement;

import java.util.Comparator;
import org.eclipse.wst.common.frameworks.internal.enablement.FunctionGroupRegistry;
import org.eclipse.wst.common.frameworks.internal.enablement.Identifiable;

public class IdentifiableComparator
implements Comparator {
    protected static final int GREATER_THAN = 1;
    protected static final int LESS_THAN = -1;
    protected static final int EQUAL = 0;
    protected static final IdentifiableComparator instance = new IdentifiableComparator();
    private static final int DEFAULT_PRIORITY = Integer.MAX_VALUE;

    public static IdentifiableComparator getInstance() {
        return instance;
    }

    public int compare(Object o1, Object o2) {
        Identifiable lvalue = null;
        Identifiable rvalue = null;
        if (o1 instanceof Identifiable) {
            lvalue = (Identifiable)o1;
        }
        if (o2 instanceof Identifiable) {
            rvalue = (Identifiable)o2;
        }
        if (rvalue == null) {
            return 1;
        }
        if (lvalue == null) {
            return -1;
        }
        if (lvalue.getID() == null && rvalue.getID() == null || this.getPriority(lvalue) == this.getPriority(rvalue)) {
            return this.compareLoadOrder(lvalue, rvalue);
        }
        return this.getPriority(lvalue) - this.getPriority(rvalue);
    }

    public boolean equals(Object obj) {
        return obj instanceof IdentifiableComparator;
    }

    private int compareLoadOrder(Identifiable lvalue, Identifiable rvalue) {
        return lvalue.getLoadOrder() - rvalue.getLoadOrder();
    }

    public int getPriority(Identifiable identifiable) {
        if (identifiable.getID() != null && identifiable.getID().length() > 0) {
            return FunctionGroupRegistry.getInstance().getFunctionPriority(identifiable.getID());
        }
        return Integer.MAX_VALUE;
    }
}

