/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.internal.Messages;
import org.eclipse.wst.server.core.internal.RuntimeWorkingCopy;
import org.eclipse.wst.server.core.internal.ServerPlugin;

public class RuntimeType
implements IRuntimeType {
    private IConfigurationElement element;
    private List moduleTypes;

    public RuntimeType(IConfigurationElement element) {
        this.element = element;
    }

    protected IConfigurationElement getElement() {
        return this.element;
    }

    public String getId() {
        return this.element.getAttribute("id");
    }

    public String getName() {
        return this.element.getAttribute("name");
    }

    public String getDescription() {
        return this.element.getAttribute("description");
    }

    public String getVendor() {
        String vendor = this.element.getAttribute("vendor");
        if (vendor == null) {
            return Messages.defaultVendor;
        }
        return vendor;
    }

    public String getVersion() {
        String version = this.element.getAttribute("version");
        if (version == null) {
            return Messages.defaultVersion;
        }
        return version;
    }

    public IModuleType[] getModuleTypes() {
        if (this.moduleTypes == null) {
            this.moduleTypes = ServerPlugin.getModuleTypes(this.element.getChildren("moduleType"));
        }
        IModuleType[] mt = new IModuleType[this.moduleTypes.size()];
        this.moduleTypes.toArray(mt);
        return mt;
    }

    public boolean canCreate() {
        String a = this.element.getAttribute("class");
        return a != null && a.length() > 0;
    }

    public IRuntimeWorkingCopy createRuntime(String id, IProgressMonitor monitor) {
        RuntimeWorkingCopy rwc = new RuntimeWorkingCopy(null, id, this);
        rwc.setDefaults(monitor);
        return rwc;
    }

    public String toString() {
        return "RuntimeType[" + this.getId() + ", " + this.getName() + "]";
    }
}

