/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.graph.figures;

import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;

public class FillLayout
extends AbstractLayout {
    protected boolean isHorizontal = false;
    protected int spacing = 0;
    public Dimension min;

    public FillLayout() {
    }

    public FillLayout(boolean dummy) {
    }

    public FillLayout(int spacing) {
        this.spacing = spacing;
    }

    public void setHorizontal(boolean isHorizontal) {
        this.isHorizontal = isHorizontal;
    }

    protected Dimension calculatePreferredSize(IFigure figure, int w, int h) {
        Dimension d = this.calculatePreferredClientAreaSize(figure);
        d.expand(figure.getInsets().getWidth(), figure.getInsets().getHeight());
        return d;
    }

    protected Dimension calculatePreferredClientAreaSize(IFigure figure) {
        Dimension d = new Dimension();
        List children = figure.getChildren();
        Iterator i = children.iterator();
        while (i.hasNext()) {
            IFigure child = (IFigure)i.next();
            Dimension childSize = child.getPreferredSize();
            if (this.isHorizontal) {
                d.width += childSize.width;
                d.height = Math.max(childSize.height, d.height);
                continue;
            }
            d.height += childSize.height;
            d.width = Math.max(childSize.width, d.width);
        }
        int childrenSize = children.size();
        if (childrenSize > 0) {
            if (this.isHorizontal) {
                d.width += this.spacing * (childrenSize - 1);
            } else {
                d.height += this.spacing * (childrenSize - 1);
            }
        }
        if (this.min != null) {
            d.width = Math.max(d.width, this.min.width);
            d.height = Math.max(d.height, this.min.height);
        }
        return d;
    }

    public Dimension getMinimumSize(IFigure figure, int w, int h) {
        Dimension d = new Dimension();
        List children = figure.getChildren();
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            d.union(child.getMinimumSize());
            ++i;
        }
        d.expand(figure.getInsets().getWidth(), figure.getInsets().getHeight());
        return d;
    }

    public Dimension getPreferredSize(IFigure figure, int w, int h) {
        return this.calculatePreferredSize(figure, w, h);
    }

    public void layout(IFigure figure) {
        Dimension preferredSize = this.calculatePreferredClientAreaSize(figure);
        Rectangle r = figure.getClientArea().getCopy();
        List children = figure.getChildren();
        Iterator i = children.iterator();
        while (i.hasNext()) {
            IFigure child = (IFigure)i.next();
            Dimension childSize = child.getPreferredSize();
            if (this.isHorizontal) {
                child.setBounds(new Rectangle(r.x, r.y, childSize.width, Math.max(preferredSize.height, r.height)));
                r.x += childSize.width + this.spacing;
                continue;
            }
            child.setBounds(new Rectangle(r.x, r.y, Math.max(preferredSize.width, r.width), childSize.height));
            r.y += childSize.height + this.spacing;
        }
    }
}

