/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.graph.figures;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Font;

public class LabelFigure
extends Figure {
    protected String text = "";
    protected boolean isShowEmptyLabel = true;
    protected int left = 4;
    protected int right = 4;
    protected int textHeight;
    protected int textWidth;

    public LabelFigure() {
        this.setPreferredSize(new Dimension());
    }

    protected void setLeft(int left) {
        this.left = left;
    }

    protected void setRight(int right) {
        this.right = right;
    }

    public void setShowEmptyLabel(boolean isShowEmptyLabel) {
        this.isShowEmptyLabel = isShowEmptyLabel;
    }

    public void setText(String s) {
        if (s == null) {
            s = "";
        }
        if (!this.text.equals(s)) {
            this.text = s;
            if (this.text.length() > 0 || this.isShowEmptyLabel) {
                this.textHeight = FigureUtilities.getFontMetrics((Font)this.getFont()).getHeight();
                this.textWidth = FigureUtilities.getTextWidth((String)this.text, (Font)this.getFont());
                this.textWidth = Math.max(this.textWidth, FigureUtilities.getTextWidth((String)"abcdefg", (Font)this.getFont()));
                this.setPreferredSize(new Dimension(this.textWidth + this.left + this.right, this.textHeight));
            } else {
                this.setPreferredSize(new Dimension());
            }
        }
    }

    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        if (this.text.length() > 0) {
            Rectangle r = this.getBounds();
            graphics.setForegroundColor(this.getForegroundColor());
            graphics.drawString(this.text, this.left + r.x, r.y);
        }
    }
}

