/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.refactor.actions;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.refactor.RefactoringMessages;
import org.eclipse.wst.xsd.ui.internal.refactor.actions.RenameComponentAction;
import org.eclipse.wst.xsd.ui.internal.refactor.actions.RenameResourceAction;
import org.eclipse.wst.xsd.ui.internal.refactor.actions.SelectionDispatchAction;
import org.eclipse.xsd.XSDSchema;

public class RenameAction
extends SelectionDispatchAction {
    private RenameComponentAction fRenameXSDElement;
    private RenameResourceAction fRenameResource;

    public RenameAction(ISelectionProvider selectionProvider, XSDSchema schema) {
        super(selectionProvider);
        this.setText(RefactoringMessages.getString("RenameAction.text"));
        this.fRenameXSDElement = new RenameComponentAction(selectionProvider, schema);
        this.fRenameXSDElement.setText(this.getText());
        this.fRenameResource = new RenameResourceAction(selectionProvider);
        this.fRenameResource.setText(this.getText());
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.fRenameXSDElement.selectionChanged(event);
        if (this.fRenameResource != null) {
            this.fRenameResource.selectionChanged(event);
        }
        this.setEnabled(this.computeEnabledState());
    }

    public void update(ISelection selection) {
        if (this.fRenameXSDElement != null) {
            this.fRenameXSDElement.update(selection);
        }
        if (this.fRenameResource != null) {
            this.fRenameResource.update(selection);
        }
        this.setEnabled(this.computeEnabledState());
    }

    private boolean computeEnabledState() {
        if (this.fRenameResource != null) {
            return this.fRenameXSDElement.isEnabled() || this.fRenameResource.isEnabled();
        }
        return this.fRenameXSDElement.isEnabled();
    }

    public void run(IStructuredSelection selection) {
        if (this.fRenameXSDElement.isEnabled()) {
            this.fRenameXSDElement.run(selection);
        }
        if (this.fRenameResource != null && this.fRenameResource.isEnabled()) {
            this.fRenameResource.run(selection);
        }
    }

    public void run(ITextSelection selection) {
        if (this.fRenameXSDElement.canRun()) {
            this.fRenameXSDElement.run(selection);
        } else {
            MessageDialog.openInformation((Shell)XSDEditorPlugin.getShell(), (String)RefactoringMessages.getString("RenameAction.rename"), (String)RefactoringMessages.getString("RenameAction.unavailable"));
        }
    }

    public void run(ISelection selection) {
        if (selection == null) {
            super.run();
        } else {
            super.run(selection);
        }
    }
}

