/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.refactor.delete;

import java.util.Iterator;
import java.util.List;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.refactor.delete.BaseGlobalCleanup;
import org.eclipse.wst.xsd.ui.internal.util.TypesHelper;
import org.eclipse.xsd.XSDAttributeGroupContent;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDConcreteComponent;

public class GlobalAttributeGroupCleanup
extends BaseGlobalCleanup {
    protected String replacementName = null;

    public GlobalAttributeGroupCleanup(XSDConcreteComponent deletedItem) {
        super(deletedItem);
    }

    protected String getReplacementElementName() {
        if (this.replacementName == null) {
            TypesHelper helper = new TypesHelper(this.schema);
            List elements = helper.getGlobalAttributeGroups();
            String deletedName = this.getDeletedQName();
            Iterator i = elements.iterator();
            while (i.hasNext()) {
                String name = (String)i.next();
                if (name.equals(deletedName)) continue;
                this.replacementName = name;
                break;
            }
        }
        return this.replacementName;
    }

    public void visitComplexTypeDefinition(XSDComplexTypeDefinition type) {
        super.visitComplexTypeDefinition(type);
        if (type.getAttributeContents() != null) {
            Iterator iter = type.getAttributeContents().iterator();
            while (iter.hasNext()) {
                XSDAttributeGroupDefinition attrGroupDef;
                XSDAttributeGroupContent attrGroupContent = (XSDAttributeGroupContent)iter.next();
                if (!(attrGroupContent instanceof XSDAttributeGroupDefinition) || !this.deletedItem.equals((attrGroupDef = (XSDAttributeGroupDefinition)attrGroupContent).getResolvedAttributeGroupDefinition())) continue;
                if (this.getReplacementElementName() != null) {
                    String msg = String.valueOf(XSDEditorPlugin.getXSDString("_INFO_RESET_ATTRIBUTE_GROUP_REFERENCE")) + " <" + this.getReplacementElementName() + ">";
                    this.addMessage(msg, (XSDConcreteComponent)attrGroupDef);
                    attrGroupDef.getElement().setAttribute("ref", this.getReplacementElementName());
                    continue;
                }
                String name = this.getNamedComponentName((XSDConcreteComponent)type);
                String msg = String.valueOf(XSDEditorPlugin.getXSDString("_INFO_REMOVE_ATTRIBUTE_GROUP_REFERENCE")) + " <" + name + ">";
                this.addMessage(msg, attrGroupDef.getContainer());
                this.childrenToRemove.add(attrGroupDef.getElement());
            }
        }
    }
}

