/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.widgets;

import java.util.ArrayList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.util.TypesHelper;
import org.eclipse.wst.xsd.ui.internal.util.ViewUtility;
import org.eclipse.xsd.XSDSchema;
import org.w3c.dom.Element;

public class SetBaseTypeDialog
extends Dialog
implements SelectionListener {
    protected Combo baseTypeCombo;
    protected Combo derivedByCombo;
    protected XSDSchema xsdSchema;
    protected Element element;
    private String type = "";
    private String derivedByString = "";

    public SetBaseTypeDialog(Shell arg0, XSDSchema xsdSchema, Element element) {
        super(arg0);
        this.xsdSchema = xsdSchema;
        this.element = element;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(XSDEditorPlugin.getXSDString("_UI_LABEL_SET_BASE_TYPE"));
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.type = this.baseTypeCombo.getText();
            this.derivedByString = this.derivedByCombo.getText();
        }
        super.buttonPressed(buttonId);
    }

    public String getBaseType() {
        return this.type;
    }

    public String getDerivedBy() {
        return this.derivedByString;
    }

    public void setCurrentBaseType(String type) {
        this.type = type;
    }

    public void setCurrentDerivedBy(String derivedByString) {
        this.derivedByString = derivedByString;
    }

    public Control createDialogArea(Composite parent) {
        Composite nameComposite = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)nameComposite.getLayout();
        layout.numColumns = 2;
        nameComposite.setLayout((Layout)layout);
        new ViewUtility();
        ViewUtility.createLabel(nameComposite, XSDEditorPlugin.getXSDString("_UI_LABEL_BASE_TYPE_WITH_COLON"));
        this.baseTypeCombo = ViewUtility.createComboBox(nameComposite, true);
        this.baseTypeCombo.addSelectionListener((SelectionListener)this);
        ViewUtility.createLabel(nameComposite, XSDEditorPlugin.getXSDString("_UI_LABEL_DERIVED_BY"));
        this.derivedByCombo = ViewUtility.createComboBox(nameComposite, true);
        this.derivedByCombo.add("extension");
        this.derivedByCombo.add("restriction");
        this.derivedByCombo.setText(this.derivedByString);
        this.initializeBaseTypeCombo();
        if (this.type.equals("")) {
            this.derivedByCombo.setText("");
            this.derivedByCombo.setEnabled(false);
        }
        return nameComposite;
    }

    private void initializeBaseTypeCombo() {
        ArrayList<String> list = new ArrayList<String>();
        TypesHelper helper = new TypesHelper(this.xsdSchema);
        String prefix = helper.getPrefix(this.xsdSchema.getTargetNamespace(), true);
        list.add("");
        list.addAll(helper.getBuiltInTypeNamesList());
        list.addAll(helper.getUserSimpleTypeNamesList());
        list.addAll(helper.getUserComplexTypeNamesList());
        list.remove(String.valueOf(prefix) + this.element.getAttribute("name"));
        this.baseTypeCombo.removeAll();
        int i = 0;
        while (i < list.size()) {
            this.baseTypeCombo.add(list.get(i).toString());
            ++i;
        }
        this.baseTypeCombo.setText(this.type);
        this.handleBaseTypeComboChange();
    }

    private void handleBaseTypeComboChange() {
        String tempChoice = this.baseTypeCombo.getText();
        TypesHelper helper = new TypesHelper(this.xsdSchema);
        if (helper.getBuiltInTypeNamesList().contains(tempChoice) || helper.getUserSimpleTypeNamesList().contains(tempChoice)) {
            this.derivedByCombo.setText("extension");
            this.derivedByCombo.setEnabled(false);
        } else if (helper.getUserComplexTypeNamesList().contains(tempChoice)) {
            this.derivedByCombo.setEnabled(true);
        } else {
            this.derivedByCombo.setText("");
            this.derivedByCombo.setEnabled(false);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.baseTypeCombo) {
            this.handleBaseTypeComboChange();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

