/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.tests.source;

import java.io.IOException;
import java.util.Iterator;
import junit.framework.TestCase;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSModel;
import org.eclipse.wst.css.core.tests.util.FileUtil;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;

public class CSSSourceParserTest
extends TestCase {
    private boolean fDump = false;
    private static final String FILES_DIR = "src/org/eclipse/wst/css/core/tests/testfiles";
    private static final String RESULTS_DIR = "src/org/eclipse/wst/css/core/tests/testfiles/results";
    private static final String MODE_OPEN = "MODE_OPEN";
    private static final String MODE_APPEND = "MODE_APPEND";
    private static final String MODE_INSERT = "MODE_INSERT";

    public void testSourceOpen1() throws IOException {
        this.sourceParserTest("sample01.css", MODE_OPEN);
    }

    public void testSourceOpen2() throws IOException {
        this.sourceParserTest("sample02.css", MODE_OPEN);
    }

    public void testSourceOpen3() throws IOException {
        this.sourceParserTest("sample03.css", MODE_OPEN);
    }

    public void testSourceOpen4() throws IOException {
        this.sourceParserTest("sample04.css", MODE_OPEN);
    }

    public void testSourceOpen5() throws IOException {
        this.sourceParserTest("sample05.css", MODE_OPEN);
    }

    public void testSourceOpen6() throws IOException {
        this.sourceParserTest("sample06.css", MODE_OPEN);
    }

    public void testSourceOpen7() throws IOException {
        this.sourceParserTest("sample07.css", MODE_OPEN);
    }

    public void testSourceAppend1() throws IOException {
        this.sourceParserTest("sample01.css", MODE_APPEND);
    }

    public void testSourceAppend2() throws IOException {
        this.sourceParserTest("sample02.css", MODE_APPEND);
    }

    public void testSourceAppend3() throws IOException {
        this.sourceParserTest("sample03.css", MODE_APPEND);
    }

    public void testSourceAppend4() throws IOException {
        this.sourceParserTest("sample04.css", MODE_APPEND);
    }

    public void testSourceAppend5() throws IOException {
        this.sourceParserTest("sample05.css", MODE_APPEND);
    }

    public void testSourceAppend6() throws IOException {
        this.sourceParserTest("sample06.css", MODE_APPEND);
    }

    public void testSourceAppend7() throws IOException {
        this.sourceParserTest("sample07.css", MODE_APPEND);
    }

    public void testSourceInsert1() throws IOException {
        this.sourceParserTest("sample01.css", MODE_INSERT);
    }

    public void testSourceInsert2() throws IOException {
        this.sourceParserTest("sample02.css", MODE_INSERT);
    }

    public void testSourceInsert3() throws IOException {
        this.sourceParserTest("sample03.css", MODE_INSERT);
    }

    public void testSourceInsert4() throws IOException {
        this.sourceParserTest("sample04.css", MODE_INSERT);
    }

    public void testSourceInsert5() throws IOException {
        this.sourceParserTest("sample05.css", MODE_INSERT);
    }

    public void testSourceInsert6() throws IOException {
        this.sourceParserTest("sample06.css", MODE_INSERT);
    }

    public void testSourceInsert7() throws IOException {
        this.sourceParserTest("sample07.css", MODE_INSERT);
    }

    private void sourceParserTest(String filename, String mode) throws IOException {
        ICSSModel model = null;
        if (mode.equals(MODE_OPEN)) {
            model = this.readModelOpen(filename);
        } else if (mode.equals(MODE_APPEND)) {
            model = this.readModelAppend(filename);
        } else if (mode.equals(MODE_INSERT)) {
            model = this.readModelInsert(filename);
        }
        String result = this.dumpRegions(model.getStructuredDocument());
        this.compareResult(result, "CSSSourceParserTest-" + filename);
        this.closeModel(model);
    }

    private ICSSModel readModelOpen(String filename) throws IOException {
        String source = FileUtil.createString(FILES_DIR, filename);
        ICSSModel model = FileUtil.createModel();
        IStructuredDocument document = model.getStructuredDocument();
        document.replaceText(null, 0, 0, source);
        return model;
    }

    private ICSSModel readModelAppend(String filename) throws IOException {
        String source = FileUtil.createString(FILES_DIR, filename);
        ICSSModel model = FileUtil.createModel();
        IStructuredDocument document = model.getStructuredDocument();
        int i = 0;
        while (i < source.length()) {
            document.replaceText(null, i, 0, source.substring(i, i + 1));
            ++i;
        }
        return model;
    }

    private ICSSModel readModelInsert(String filename) throws IOException {
        String source = FileUtil.createString(FILES_DIR, filename);
        ICSSModel model = FileUtil.createModel();
        IStructuredDocument document = model.getStructuredDocument();
        int i = 0;
        while (i < source.length()) {
            int textIndex = source.length() - i - 1;
            document.replaceText(null, 0, 0, source.substring(textIndex, textIndex + 1));
            ++i;
        }
        return model;
    }

    private void closeModel(ICSSModel model) {
        model.releaseFromEdit();
    }

    private String dumpRegions(IStructuredDocument document) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.dumpRegions(document.getFirstStructuredDocumentRegion()));
        return buf.toString();
    }

    private String dumpRegions(IStructuredDocumentRegion region) {
        StringBuffer buf = new StringBuffer();
        do {
            buf.append(this.dumpOneRegion(region));
        } while ((region = region.getNext()) != null);
        buf.append("\r\n-------\r\n");
        return buf.toString();
    }

    private String dumpOneRegion(IStructuredDocumentRegion documentRegion) {
        StringBuffer buf = new StringBuffer();
        buf.append(documentRegion.toString());
        buf.append("\r\n    ");
        ITextRegionList regionList = documentRegion.getRegions();
        Iterator i = regionList.iterator();
        while (i.hasNext()) {
            ITextRegion textRegion = (ITextRegion)i.next();
            buf.append(textRegion.toString());
            buf.append(", ");
        }
        buf.append("\r\n");
        return buf.toString();
    }

    private void compareResult(String actual, String filename) throws IOException {
        if (this.fDump) {
            FileUtil.dumpString(actual, RESULTS_DIR, filename);
        } else {
            String result = FileUtil.createString(RESULTS_DIR, filename);
            CSSSourceParserTest.assertEquals((String)result, (String)actual);
        }
    }
}

