/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.tests.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSModel;
import org.eclipse.wst.css.core.tests.util.NullInputStream;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.StructuredModelManager;
import org.osgi.framework.Bundle;

public class FileUtil {
    public static final String commonEOL = "\r\n";
    static int uniqueNum = 0;

    public static File createFile(String directory, String filename) throws IOException {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.wst.css.core.tests");
        URL url = bundle.getEntry("/");
        URL localURL = Platform.asLocalURL((URL)url);
        String installPath = localURL.getPath();
        String totalDirectory = String.valueOf(installPath) + directory;
        String totalPath = String.valueOf(totalDirectory) + "/" + filename;
        URL totalURL = new URL(url, totalPath);
        String finalFile = totalURL.getFile();
        File file = new File(finalFile);
        return file;
    }

    public static String createString(String directory, String filename) throws FileNotFoundException, IOException {
        String line;
        StringBuffer buf = new StringBuffer();
        FileReader fileReader = new FileReader(FileUtil.createFile(directory, filename));
        BufferedReader reader = new BufferedReader(fileReader);
        while ((line = reader.readLine()) != null) {
            buf.append(line);
            buf.append(commonEOL);
        }
        return buf.toString();
    }

    public static ICSSModel createModel() {
        IStructuredModel model = null;
        try {
            IModelManager modelManager = StructuredModelManager.getModelManager();
            model = modelManager.getModelForEdit("test" + uniqueNum++ + ".css", (InputStream)new NullInputStream(), null);
            model.getStructuredDocument().setLineDelimiter(commonEOL);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (ICSSModel)model;
    }

    public static void dumpString(String string, String directory, String filename) throws IOException {
        File file = FileUtil.createFile(directory, filename);
        FileWriter writer = new FileWriter(file);
        writer.write(string);
        ((Writer)writer).close();
    }
}

