/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.internet.internal.proxy;

import java.text.MessageFormat;
import java.util.Properties;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.internet.internal.proxy.Encoder;
import org.eclipse.wst.internet.internal.proxy.Log;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class InternetPlugin
extends AbstractUIPlugin
implements IStartup {
    public static final String ID = "org.eclipse.wst.internet.proxy";
    private static InternetPlugin instance;
    public static final String PREFERENCE_PROXYCHECKED = "proxyCheckBox";
    public static final String PREFERENCE_NAMECHECKED = "nameCheckBox";
    public static final String PREFERENCE_SOCKSCHECKED = "socksCheckBox";
    public static final String PREFERENCE_HOSTNAME = "hostnameText";
    public static final String PREFERENCE_PORT = "portText";
    public static final String PREFERENCE_USERNAME = "userNameText";
    public static final String PREFERENCE_PASSWORD = "passwordText";
    public static final String PREFERENCE_NON_PROXY_HOSTS = "nonProxyHostsText";

    public InternetPlugin() {
        instance = this;
    }

    public static InternetPlugin getInstance() {
        return instance;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.updateProxyProperties();
    }

    public void earlyStartup() {
        this.updateProxyProperties();
    }

    public static String getMessage(String key) {
        return Platform.getResourceString((Bundle)instance.getBundle(), (String)key);
    }

    public static String getMessage(String key, Object[] args) {
        return MessageFormat.format(InternetPlugin.getMessage(key), args);
    }

    public void updateProxyProperties() {
        IPreferenceStore store = this.getPreferenceStore();
        boolean setProxy = store.getBoolean(PREFERENCE_PROXYCHECKED);
        boolean useSOCKS = store.getBoolean(PREFERENCE_SOCKSCHECKED);
        boolean setName = store.getBoolean(PREFERENCE_NAMECHECKED);
        Properties sysProps = System.getProperties();
        Log.write((Object)this, "updateProxyProperties", 1, "proxySet: " + setProxy);
        if (setProxy) {
            String hostname = store.getString(PREFERENCE_HOSTNAME);
            String port = store.getString(PREFERENCE_PORT);
            String nonProxyHosts = store.getString(PREFERENCE_NON_PROXY_HOSTS);
            sysProps.put("proxySet", "true");
            if (useSOCKS) {
                sysProps.put("socksProxyHost", hostname);
                sysProps.put("socksProxyPort", port);
                sysProps.remove("proxyHost");
                sysProps.remove("proxyPort");
                sysProps.remove("http.proxySet");
                sysProps.remove("http.proxyHost");
                sysProps.remove("http.proxyPort");
                sysProps.remove("http.nonProxyHosts");
            } else {
                sysProps.remove("socksProxyHost");
                sysProps.remove("socksProxyPort");
                sysProps.put("proxyHost", hostname);
                sysProps.put("proxyPort", port);
                sysProps.put("http.proxySet", "true");
                sysProps.put("http.proxyHost", hostname);
                sysProps.put("http.proxyPort", port);
                sysProps.put("http.nonProxyHosts", nonProxyHosts);
            }
            if (setName) {
                String userName = store.getString(PREFERENCE_USERNAME);
                String password = store.getString(PREFERENCE_PASSWORD);
                sysProps.put("http.proxyUserName", Encoder.isEncoded(userName) ? Encoder.decode(userName) : userName);
                sysProps.put("http.proxyPassword", Encoder.isEncoded(password) ? Encoder.decode(password) : password);
                Log.write((Object)this, "updateProxyProperties", 1, "http.proxyUserName: " + userName);
                Log.write((Object)this, "updateProxyProperties", 1, "http.proxyPassword: " + password);
            } else {
                Log.write((Object)this, "updateProxyProperties", 1, "Removing proxy name properties");
                sysProps.remove("http.proxyUserName");
                sysProps.remove("http.proxyPassword");
            }
            Log.write((Object)this, "updateProxyProperties", 1, "proxyHost: " + hostname);
            Log.write((Object)this, "updateProxyProperties", 1, "proxyPort: " + port);
            Log.write((Object)this, "updateProxyProperties", 1, "http.proxyHost: " + hostname);
            Log.write((Object)this, "updateProxyProperties", 1, "http.proxyPort: " + port);
            Log.write((Object)this, "updateProxyProperties", 1, "http.nonProxyHosts: " + nonProxyHosts);
        } else {
            Log.write((Object)this, "updateProxyProperties", 1, "Removing proxy properties");
            sysProps.remove("proxySet");
            sysProps.remove("proxyHost");
            sysProps.remove("proxyPort");
            sysProps.remove("socksProxyHost");
            sysProps.remove("socksProxyPort");
            sysProps.remove("http.proxySet");
            sysProps.remove("http.proxyHost");
            sysProps.remove("http.proxyPort");
            sysProps.remove("http.proxyUserName");
            sysProps.remove("http.proxyPassword");
            sysProps.remove("http.nonProxyHosts");
        }
    }
}

