/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.sqleditor.internal.actions;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ResourceAction;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.server.internal.ui.query.execute.QueryOutputHelper;
import org.eclipse.wst.rdb.sqleditor.internal.SQLEditor;
import org.eclipse.wst.rdb.sqleditor.internal.sql.SQLPartitionScanner;
import org.eclipse.wst.rdb.sqleditor.internal.utils.SQLDBUtils;
import org.eclipse.wst.rdb.sqleditor.internal.utils.SQLStatementTerminatorSupport;

public class SQLRunAction
extends ResourceAction {
    private SQLEditor fSQLEditor;

    public SQLRunAction(ResourceBundle bundle, String prefix) {
        super(bundle, prefix);
    }

    public SQLEditor getSQLEditor() {
        return this.fSQLEditor;
    }

    protected List getSQLStatementList() {
        ArrayList<String> stmtList = new ArrayList<String>();
        SQLEditor sqlEditor = this.getSQLEditor();
        IEditorInput editorInput = sqlEditor.getEditorInput();
        IDocumentProvider docProvider = sqlEditor.getDocumentProvider();
        IDocument doc = docProvider.getDocument((Object)editorInput);
        ITypedRegion[] regions = SQLPartitionScanner.getDocumentRegions(doc);
        SQLStatementTerminatorSupport statementTerminatorSupport = sqlEditor.getSQLStatementTerminatorSupport();
        String statementTerminator = statementTerminatorSupport.getStatementTerminator();
        if (regions != null) {
            StringBuffer stmtBuf = new StringBuffer();
            ITypedRegion region = null;
            int i = 0;
            while (i < regions.length) {
                region = regions[i];
                if (!region.getType().equals("__sql_comment__")) {
                    int regionOffset = region.getOffset();
                    int regionLength = region.getLength();
                    String stmtPart = "";
                    try {
                        stmtPart = doc.get(regionOffset, regionLength);
                    }
                    catch (BadLocationException badLocationException) {}
                    if (region.getType().equals("__sql_quoted_literal__") || region.getType().equals("__sql_delimited_identifier__")) {
                        stmtBuf.append(stmtPart);
                    } else {
                        int scanStart = 0;
                        int terminatorPos = stmtPart.indexOf(statementTerminator, scanStart);
                        while (terminatorPos != -1 && scanStart < stmtPart.length()) {
                            stmtBuf.append(stmtPart.substring(scanStart, terminatorPos));
                            String stmt = stmtBuf.toString();
                            stmt = stmt.trim();
                            if (stmt.length() > 0) {
                                stmtList.add(stmt);
                            }
                            stmtBuf.setLength(0);
                            scanStart = terminatorPos + statementTerminator.length();
                            if (scanStart >= stmtPart.length()) continue;
                            terminatorPos = stmtPart.indexOf(statementTerminator, scanStart);
                        }
                        if (scanStart < stmtPart.length()) {
                            stmtBuf.append(stmtPart.substring(scanStart, stmtPart.length()));
                        }
                    }
                }
                ++i;
            }
            if (stmtBuf.length() > 0) {
                String stmt = stmtBuf.toString();
                if ((stmt = stmt.trim()).length() > 0) {
                    stmtList.add(stmt);
                }
            }
        }
        return stmtList;
    }

    public void run() {
        SQLEditor sqlEditor = this.getSQLEditor();
        if (sqlEditor != null) {
            ITextSelection textSelection;
            String text;
            List<String> stmtList = new ArrayList();
            ISelectionProvider selectionProvider = this.fSQLEditor.getSelectionProvider();
            ISelection selection = selectionProvider.getSelection();
            if (!selection.isEmpty() && selection instanceof ITextSelection && (text = (textSelection = (ITextSelection)selection).getText()).length() > 0) {
                stmtList.add(text);
            }
            if (stmtList.size() == 0) {
                stmtList = this.getSQLStatementList();
            }
            if (stmtList.size() > 0) {
                boolean connected;
                Connection conn = null;
                ConnectionInfo connInfo = this.fSQLEditor.getConnectionInfo();
                if (connInfo == null && (connInfo = sqlEditor.requestConnectionFromUser()) != null) {
                    sqlEditor.setConnectionInfo(connInfo);
                }
                if (connInfo != null && (connected = SQLDBUtils.reestablishConnection(connInfo))) {
                    conn = connInfo.getSharedConnection();
                }
                if (conn != null) {
                    Iterator stmtListIter = stmtList.iterator();
                    while (stmtListIter.hasNext()) {
                        String sql = (String)stmtListIter.next();
                        QueryOutputHelper outputHelper = new QueryOutputHelper(sql, conn);
                        outputHelper.runSQLScrapbookQuery();
                        try {
                            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.wst.rdb.internal.outputview.OutputView");
                        }
                        catch (PartInitException partInitException) {}
                    }
                }
            }
        }
    }

    public void setSQLEditor(SQLEditor sqlEditor) {
        this.fSQLEditor = sqlEditor;
    }
}

