/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.internet.cache.internal;

import java.net.URL;
import java.util.Hashtable;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.internet.cache.internal.CachePlugin;

public class LicenseAcceptanceDialog
extends IconAndMessageDialog {
    private static final String _UI_CACHE_DIALOG_LICENSE_STATEMENT1 = "_UI_CACHE_DIALOG_LICENSE_STATEMENT1";
    private static final String _UI_CACHE_DIALOG_LICENSE_STATEMENT2 = "_UI_CACHE_DIALOG_LICENSE_STATEMENT2";
    private static final String _UI_CACHE_DIALOG_LICENSE_STATEMENT2_NO_INTERNAL = "_UI_CACHE_DIALOG_LICENSE_STATEMENT2_NO_INTERNAL";
    private static final String _UI_CACHE_DIALOG_LICENSE_STATEMENT2_NO_BROWSER = "_UI_CACHE_DIALOG_LICENSE_STATEMENT2_NO_BROWSER";
    private static final String _UI_CACHE_DIALOG_AGREE_BUTTON = "_UI_CACHE_DIALOG_AGREE_BUTTON";
    private static final String _UI_CACHE_DIALOG_DISAGREE_BUTTON = "_UI_CACHE_DIALOG_DISAGREE_BUTTON";
    private static final String _UI_CACHE_DIALOG_TITLE = "_UI_CACHE_DIALOG_TITLE";
    private static Hashtable dialogsInUse = new Hashtable();
    private String url;
    private String licenseURL;

    protected LicenseAcceptanceDialog(Shell parent, String url, String licenseURL) {
        super(parent);
        this.url = url;
        this.licenseURL = licenseURL;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(CachePlugin.getResourceString(_UI_CACHE_DIALOG_TITLE));
        shell.setImage(null);
    }

    protected Control createButtonBar(Composite parent) {
        Composite buttonBar = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 0;
        layout.makeColumnsEqualWidth = true;
        buttonBar.setLayout((Layout)layout);
        GridData gd = new GridData(64);
        buttonBar.setLayoutData((Object)gd);
        this.createButton(buttonBar, 0, CachePlugin.getResourceString(_UI_CACHE_DIALOG_AGREE_BUTTON), false);
        this.createButton(buttonBar, 1, CachePlugin.getResourceString(_UI_CACHE_DIALOG_DISAGREE_BUTTON), false);
        return buttonBar;
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(4);
        gd.widthHint = 500;
        composite.setLayoutData((Object)gd);
        Label licenseText1 = new Label(composite, 0);
        licenseText1.setText(CachePlugin.getResourceString(_UI_CACHE_DIALOG_LICENSE_STATEMENT1));
        Label urlText = new Label(composite, 64);
        gd = new GridData(4, 128, true, false, 1, 1);
        urlText.setLayoutData((Object)gd);
        urlText.setText(this.url);
        new Label(composite, 0);
        Label licenseText2 = new Label(composite, 64);
        gd = new GridData(4, 128, true, false, 1, 1);
        licenseText2.setLayoutData((Object)gd);
        try {
            Browser browser = new Browser(composite, 2048);
            gd = new GridData(1808);
            gd.heightHint = 400;
            browser.setUrl(this.licenseURL);
            browser.setLayoutData((Object)gd);
            licenseText2.setText(CachePlugin.getResourceString(_UI_CACHE_DIALOG_LICENSE_STATEMENT2));
        }
        catch (Throwable throwable) {
            try {
                CachePlugin.getDefault().getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL(this.licenseURL));
                licenseText2.setText(CachePlugin.getResourceString(_UI_CACHE_DIALOG_LICENSE_STATEMENT2_NO_INTERNAL));
            }
            catch (Exception exception) {
                licenseText2.setText(CachePlugin.getResourceString(_UI_CACHE_DIALOG_LICENSE_STATEMENT2_NO_BROWSER, this.licenseURL));
            }
        }
        this.createButtonBar(composite);
        return composite;
    }

    protected Image getImage() {
        return this.getInfoImage();
    }

    public static boolean promptForLicense(Shell parent, String url, String licenseURL) {
        LicenseAcceptanceDialog dialog;
        boolean agreedToLicense = false;
        boolean newDialog = true;
        if (dialogsInUse.containsKey(licenseURL)) {
            newDialog = false;
            dialog = (LicenseAcceptanceDialog)((Object)dialogsInUse.get(licenseURL));
        } else {
            dialog = new LicenseAcceptanceDialog(parent, url, licenseURL);
            dialogsInUse.put(licenseURL, dialog);
            dialog.setBlockOnOpen(true);
        }
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            agreedToLicense = true;
        }
        if (newDialog) {
            dialogsInUse.remove(licenseURL);
        }
        return agreedToLicense;
    }
}

