/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.tests.hacks;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.wst.xml.core.tests.util.CommonXML;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class VersionRemover {
    char[] charbuff = new char[2048];
    StringBuffer s = null;

    public static void main(String[] args) {
        if (args.length < 1) {
            new VersionRemover().visit(new File("d:/target"));
        } else {
            new VersionRemover().visit(new File(args[0]));
        }
    }

    protected void visit(File file) {
        if (file.isDirectory() && !file.getName().startsWith("org.eclipse.") && !file.getName().startsWith("org.apache") && !file.getName().startsWith("org.junit")) {
            String[] contents = file.list();
            int i = 0;
            while (i < contents.length) {
                this.visit(new File(String.valueOf(file.getAbsolutePath()) + '/' + contents[i]));
                ++i;
            }
        } else {
            this.fixupFile(file);
        }
    }

    protected void fixupFile(File file) {
        if (!file.getName().equalsIgnoreCase("plugin.xml") && !file.getName().equalsIgnoreCase("fragment.xml") || file.getAbsolutePath().indexOf("eclipse\\plugins\\XXXXXXX.") == -1) {
            return;
        }
        try {
            Document doc = CommonXML.getDocumentBuilder().parse(file);
            NodeList imports = null;
            if (file.getName().equalsIgnoreCase("plugin.xml")) {
                imports = doc.getElementsByTagName("import");
            } else if (file.getName().equalsIgnoreCase("fragment.xml")) {
                imports = doc.getElementsByTagName("fragment");
            }
            boolean changed = false;
            int i = 0;
            while (i < imports.getLength()) {
                Node importNode = imports.item(i);
                if (importNode.getNodeName().equalsIgnoreCase("import") && importNode.getAttributes().getNamedItem("version") != null) {
                    changed = true;
                    importNode.getAttributes().removeNamedItem("version");
                }
                if (importNode.getAttributes().getNamedItem("plugin-version") != null) {
                    changed = true;
                    importNode.getAttributes().removeNamedItem("plugin-version");
                }
                if (importNode.getAttributes().getNamedItem("match") != null) {
                    importNode.getAttributes().removeNamedItem("match");
                    changed = true;
                }
                ++i;
            }
            if (changed) {
                FileOutputStream ostream = new FileOutputStream(file.getAbsolutePath());
                CommonXML.serialize(doc, ostream);
                ostream.close();
                System.out.println("Modified " + file.getAbsolutePath());
            }
        }
        catch (SAXException e) {
            System.err.println(String.valueOf(file.getPath()) + ": " + e);
        }
        catch (IOException e) {
            System.err.println(String.valueOf(file.getPath()) + ": " + e);
        }
    }
}

