/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.componentcore.tests;

import junit.framework.TestCase;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.frameworks.componentcore.virtualpath.tests.TestWorkspace;

public class BaseVirtualTest
extends TestCase {
    public static final IProject TEST_PROJECT = ResourcesPlugin.getWorkspace().getRoot().getProject("TestVirtualAPI");
    public static final String TEST_FOLDER_NAME = "WEB-INF";
    public static final Path WEBINF_FOLDER_REAL_PATH = new Path("/WebModule1/WebContent/WEB-INF");
    public static final Path WEBINF_FOLDER_RUNTIME_PATH = new Path("/WEB-INF");
    public static final Path TESTDATA_FOLDER_REAL_PATH = new Path("WebModule1/testdata");
    public static final Path TESTDATA_FOLDER_RUNTIME_PATH = new Path("/");
    protected static final IPath DELETEME_PATH = new Path("/deleteme");
    protected IVirtualComponent component;
    protected IVirtualFolder webInfFolder;
    protected IFolder realWebInfFolder;
    protected IVirtualFolder deletemeVirtualFolder;
    protected IFolder deletemeFolder;
    protected IVirtualFolder testdataFolder;
    protected IFolder realTestdataFolder;

    public BaseVirtualTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        TestWorkspace.init();
        this.realWebInfFolder = TEST_PROJECT.getFolder((IPath)WEBINF_FOLDER_REAL_PATH);
        this.component = ComponentCore.createComponent((IProject)TEST_PROJECT, (String)"WebModule1");
        IVirtualFolder rootFolder = this.component.getRootFolder();
        this.webInfFolder = rootFolder.getFolder((IPath)WEBINF_FOLDER_RUNTIME_PATH);
        this.testdataFolder = rootFolder.getFolder((IPath)TESTDATA_FOLDER_RUNTIME_PATH);
        this.realTestdataFolder = TEST_PROJECT.getFolder((IPath)TESTDATA_FOLDER_REAL_PATH);
        this.deletemeVirtualFolder = rootFolder.getFolder(DELETEME_PATH);
        this.deletemeVirtualFolder.create(256, null);
        this.deletemeFolder = this.deletemeVirtualFolder.getUnderlyingFolder();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.deletemeFolder.exists()) {
            this.deletemeFolder.delete(256, null);
        }
    }
}

