/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.componentcore.tests;

import java.io.IOException;
import java.net.URL;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.etools.common.test.apitools.ProjectUnzipUtil;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.tests.CommonTestsPlugin;

public class ComponentCoreTest
extends TestCase {
    public static String fileSep = System.getProperty("file.separator");
    public static final String PROJECT_NAME = "TestArtifactEdit";
    public static final String WEB_MODULE_NAME = "WebModule1";
    public static final URI moduleURI = URI.createURI((String)"module:/resource/TestArtifactEdit/WebModule1");
    public static final String EDIT_MODEL_ID = "jst.web";
    private Path zipFilePath = new Path("TestData" + fileSep + "TestArtifactEdit.zip");
    private IProject project;

    protected void setUp() throws Exception {
        if (!this.getTargetProject().exists() && !this.createProject()) {
            ComponentCoreTest.fail();
        }
        this.project = this.getTargetProject();
    }

    public IProject getTargetProject() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME);
    }

    public boolean createProject() {
        IPath localZipPath = this.getLocalPath();
        ProjectUnzipUtil util = new ProjectUnzipUtil(localZipPath, new String[]{PROJECT_NAME});
        return util.createProjects();
    }

    private IPath getLocalPath() {
        URL url = CommonTestsPlugin.instance.find((IPath)this.zipFilePath);
        try {
            url = Platform.asLocalURL((URL)url);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new Path(url.getPath());
    }

    public void testCreateFlexibleProject() {
        try {
            ComponentCore.createFlexibleProject((IProject)this.project);
        }
        catch (Exception e) {
            ComponentCoreTest.fail((String)e.toString());
        }
    }

    public void testCreateComponent() {
        try {
            new ComponentCore();
            ComponentCore.createComponent((IProject)this.project, (String)"test");
        }
        catch (Exception e) {
            ComponentCoreTest.fail((String)e.toString());
        }
    }

    public void testCreateFolder() {
        try {
            ComponentCore.createFolder((IProject)this.project, (String)"test", (IPath)new Path("test/runtimePath"));
        }
        catch (Exception e) {
            ComponentCoreTest.fail((String)e.toString());
        }
    }

    public void testCreateFile() {
        try {
            ComponentCore.createFile((IProject)this.project, (String)"test", (IPath)new Path("test/runtimePath/file"));
        }
        catch (Exception e) {
            ComponentCoreTest.fail((String)e.toString());
        }
    }

    public void testCreateReference() {
        VirtualComponent container = new VirtualComponent(this.project, "test", (IPath)new Path("test/runtimePath/file"));
        try {
            ComponentCore.createReference((IVirtualComponent)container, (IVirtualComponent)container);
        }
        catch (Exception e) {
            ComponentCoreTest.fail((String)e.toString());
        }
    }

    public void testCreateResources() {
        IFile res = this.project.getFile((IPath)new Path("WebModule1/WebContent/WEB-INF/web.xml"));
        try {
            ComponentCore.createResources((IResource)res);
        }
        catch (Exception e) {
            ComponentCoreTest.fail((String)e.toString());
        }
    }
}

