/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.componentcore.virtualpath.tests;

import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.common.componentcore.resources.IVirtualContainer;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.eclipse.wst.common.frameworks.componentcore.virtualpath.tests.TestWorkspace;

public abstract class IVirtualResourceAPITest
extends TestCase {
    protected IVirtualContainer virtualParent;
    protected IVirtualResource targetExistingVirtualResource;
    protected IResource targetExistingPlatformResource;
    protected IVirtualFolder targetVirtualResourceToDelete;
    protected IResource targetPlatformResourceToDelete;
    protected IVirtualResource targetVirtualResourceToCreate = null;
    protected IVirtualResource targetMultiVirtualResource = null;
    protected IProject expectedProject;
    protected IPath expectedRuntimePath;
    protected String expectedName;
    private static final String PROJECT_NAME = null;

    public IVirtualResourceAPITest(String name) {
        super(name);
    }

    protected final void setUp() throws Exception {
        TestWorkspace.init();
        this.doSetup();
        this.assertRequirements();
    }

    protected void assertRequirements() {
    }

    protected abstract void doSetup() throws Exception;

    /*
     * Exception decompiling
     */
    public void testCreateLinkIPathintIProgressMonitor() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 345->349)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void testEquals() throws Exception {
    }

    public void testExists() throws Exception {
    }

    public void testGetFileExtension() {
        IVirtualResourceAPITest.assertTrue((String)"The existing virtual resource should have no file extension.", (this.targetExistingVirtualResource.getFileExtension() == null ? 1 : 0) != 0);
    }

    public void testGetWorkspaceRelativePath() {
        IPath realPath = this.targetExistingPlatformResource.getFullPath();
        IPath virtualPath = this.targetExistingVirtualResource.getWorkspaceRelativePath();
        IVirtualResourceAPITest.assertEquals((String)"The workspace relative path of the virtual resource must match the real resource", (Object)realPath, (Object)virtualPath);
    }

    public void testGetProjectRelativePath() {
        IPath realPath = this.targetExistingPlatformResource.getProjectRelativePath();
        IPath virtualPath = this.targetExistingVirtualResource.getProjectRelativePath();
        IVirtualResourceAPITest.assertEquals((String)"The project relative path of the virtual resource must match the real resource", (Object)realPath, (Object)virtualPath);
    }

    public void testGetRuntimePath() {
        IPath virtualPath = this.targetExistingVirtualResource.getRuntimePath();
        IVirtualResourceAPITest.assertEquals((String)"The runtime path of the virtual resource must match the real resource", (Object)this.expectedRuntimePath, (Object)virtualPath);
    }

    public void testGetName() {
        IVirtualResourceAPITest.assertEquals((String)"The name of the virtual resource must match the expected name.", (String)this.expectedName, (String)this.targetExistingVirtualResource.getName());
    }

    public void testGetParent() {
        IVirtualResourceAPITest.assertEquals((String)"The parent of the virtual resource must match the component.", (Object)this.virtualParent, (Object)this.targetExistingVirtualResource.getParent());
    }

    public void testGetProject() {
        IVirtualResourceAPITest.assertEquals((String)"The project of the virtual resource must match the test project.", (Object)this.expectedProject, (Object)this.targetExistingVirtualResource.getProject());
    }

    public void testGetType() {
        IVirtualResourceAPITest.assertEquals((String)"The type of the virtual resource must match the test project.", (int)2, (int)this.targetExistingVirtualResource.getType());
    }

    public void testGetComponent() {
        IVirtualResourceAPITest.assertEquals((String)"The component name of the virtual resource must match the test project.", (String)"WebModule1", (String)this.targetExistingVirtualResource.getComponent().getName());
    }

    public void testIsAccessible() {
        IVirtualResourceAPITest.assertEquals((String)"The platform resource should be accessible only if the virtual resource is accessible.", (boolean)this.targetExistingPlatformResource.isAccessible(), (boolean)this.targetExistingPlatformResource.isAccessible());
    }

    public void testDeleteintIProgressMonitor() throws Exception {
        this.targetVirtualResourceToDelete.delete(0, null);
        IVirtualResourceAPITest.assertTrue((String)"The real folder should be deleted when IVirtualResource.DELETE_METAMODEL_ONLY is NOT supplied.", (!this.targetPlatformResourceToDelete.exists() ? 1 : 0) != 0);
        IVirtualResource[] members = this.virtualParent.members();
        int i = 0;
        while (i < members.length) {
            if (members[i].getRuntimePath().equals((Object)this.targetVirtualResourceToDelete.getRuntimePath())) {
                IVirtualResourceAPITest.fail((String)"Found deleted folder in members()");
            }
            ++i;
        }
    }

    /*
     * Exception decompiling
     */
    public void testDeleteintIProgressMonitor2() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 106->110)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void testDeleteintIProgressMonitor3() throws Exception {
        this.targetVirtualResourceToDelete.delete(256, null);
        IVirtualResourceAPITest.assertTrue((String)"The real resource should be deleted when IVirtualResource.IGNORE_UNDERLYING_RESOURCE is NOT supplied.", (!this.targetPlatformResourceToDelete.exists() ? 1 : 0) != 0);
        IVirtualResource[] members = this.virtualParent.members();
        int i = 0;
        while (i < members.length) {
            if (members[i].getRuntimePath().equals((Object)this.targetVirtualResourceToDelete.getRuntimePath())) {
                IVirtualResourceAPITest.fail((String)"Found deleted folder in members()");
            }
            ++i;
        }
    }

    public void testGetUnderlyingResource() {
        IResource platformResourceToCreate = this.targetVirtualResourceToCreate.getUnderlyingResource();
        int expectedType = this.determineExpectedType(this.targetVirtualResourceToCreate);
        IVirtualResourceAPITest.assertEquals((String)"The type of the underlying resource should match the expected type.", (int)expectedType, (int)platformResourceToCreate.getType());
        IVirtualResourceAPITest.assertTrue((String)"The underyling resource should not exist.", (!platformResourceToCreate.exists() ? 1 : 0) != 0);
        expectedType = this.determineExpectedType(this.targetExistingVirtualResource);
        IResource exitingPlatformResource = this.targetExistingVirtualResource.getUnderlyingResource();
        IVirtualResourceAPITest.assertEquals((String)"The type of the underlying resource should match the expected type.", (int)expectedType, (int)exitingPlatformResource.getType());
        IVirtualResourceAPITest.assertTrue((String)"The underyling resource should exist.", (boolean)exitingPlatformResource.exists());
        expectedType = this.determineExpectedType(this.targetMultiVirtualResource);
        IResource multiPlatformResource = this.targetMultiVirtualResource.getUnderlyingResource();
        IVirtualResourceAPITest.assertEquals((String)"The type of the underlying resource should match the expected type.", (int)expectedType, (int)multiPlatformResource.getType());
        IVirtualResourceAPITest.assertTrue((String)"The underyling resource should exist.", (boolean)multiPlatformResource.exists());
    }

    public void testGetUnderlyingResources() {
        int expectedType = this.determineExpectedType(this.targetVirtualResourceToCreate);
        IResource[] platformResourcesToCreate = this.targetVirtualResourceToCreate.getUnderlyingResources();
        IVirtualResourceAPITest.assertEquals((String)"There should only be one resource in the result array.", (int)1, (int)platformResourcesToCreate.length);
        IVirtualResourceAPITest.assertEquals((String)"The type of the underlying resource should match the expected type.", (int)expectedType, (int)platformResourcesToCreate[0].getType());
        IVirtualResourceAPITest.assertTrue((String)"The underyling resource should not exist.", (!platformResourcesToCreate[0].exists() ? 1 : 0) != 0);
        expectedType = this.determineExpectedType(this.targetExistingVirtualResource);
        IResource[] existingPlatformResource = this.targetExistingVirtualResource.getUnderlyingResources();
        IVirtualResourceAPITest.assertEquals((String)"There should only be one resource in the result array.", (int)1, (int)existingPlatformResource.length);
        IVirtualResourceAPITest.assertEquals((String)"The type of the underlying resource should match the expected type.", (int)expectedType, (int)existingPlatformResource[0].getType());
        IVirtualResourceAPITest.assertTrue((String)"The underyling resource should not exist.", (boolean)existingPlatformResource[0].exists());
        expectedType = this.determineExpectedType(this.targetMultiVirtualResource);
        IResource[] multiPlatformResources = this.targetMultiVirtualResource.getUnderlyingResources();
        IVirtualResourceAPITest.assertEquals((String)"The type of the underlying resource should match the expected type.", (int)expectedType, (int)multiPlatformResources[0].getType());
        IVirtualResourceAPITest.assertTrue((String)"The underyling resource should not exist.", (boolean)multiPlatformResources[0].exists());
    }

    private int determineExpectedType(IVirtualResource aVirtualResource) {
        switch (this.targetVirtualResourceToCreate.getType()) {
            case 16: {
                return 1;
            }
            case 32: 
            case 64: {
                return 2;
            }
        }
        return 0;
    }
}

