/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.operations.tests;

import java.util.List;
import junit.framework.TestCase;
import org.eclipse.wst.common.frameworks.internal.operations.WTPOperation;
import org.eclipse.wst.common.frameworks.internal.operations.WTPOperationDataModel;
import org.eclipse.wst.common.frameworks.internal.operations.WTPOperationDataModelEvent;
import org.eclipse.wst.common.frameworks.internal.operations.WTPPropertyDescriptor;
import org.eclipse.wst.common.frameworks.operations.tests.TestListener;

public class SimpleDataModelTest
extends TestCase {
    private DM dm;
    private TestListener dmL;

    protected void setUp() throws Exception {
        super.setUp();
        this.dm = new DM();
        this.dmL = new TestListener();
        this.dm.addListener(this.dmL);
    }

    public void testPropertyDescriptors() {
        int value;
        WTPPropertyDescriptor[] descriptors = this.dm.getValidPropertyDescriptors("INT_PROP2");
        int i = 0;
        while (i < descriptors.length) {
            int value2 = i + 1;
            SimpleDataModelTest.assertEquals((int)value2, (int)((Integer)descriptors[i].getPropertyValue()));
            SimpleDataModelTest.assertEquals((String)("" + value2), (String)descriptors[i].getPropertyDescription());
            ++i;
        }
        descriptors = this.dm.getValidPropertyDescriptors("INT_PROP3");
        String[] descriptions = new String[]{"one", "two", "three"};
        int i2 = 0;
        while (i2 < descriptors.length) {
            value = i2 + 1;
            SimpleDataModelTest.assertEquals((int)value, (int)((Integer)descriptors[i2].getPropertyValue()));
            SimpleDataModelTest.assertEquals((String)descriptions[i2], (String)descriptors[i2].getPropertyDescription());
            ++i2;
        }
        descriptors = this.dm.getValidPropertyDescriptors("INT_PROP4");
        i2 = 0;
        while (i2 < descriptors.length) {
            value = i2 + 1;
            SimpleDataModelTest.assertEquals((int)value, (int)((Integer)descriptors[i2].getPropertyValue()));
            SimpleDataModelTest.assertEquals((String)descriptions[i2], (String)descriptors[i2].getPropertyDescription());
            ++i2;
        }
    }

    public void testDefaults() {
        SimpleDataModelTest.assertEquals((boolean)true, (boolean)this.dm.getBooleanProperty("BOOLEAN_PROP"));
        SimpleDataModelTest.assertEquals((boolean)true, (boolean)((Boolean)this.dm.getProperty("BOOLEAN_PROP")));
        SimpleDataModelTest.assertEquals((int)10, (int)this.dm.getIntProperty("INT_PROP"));
        SimpleDataModelTest.assertEquals((int)10, (int)((Integer)this.dm.getProperty("INT_PROP")));
        SimpleDataModelTest.assertEquals((String)"foo10true", (String)((String)this.dm.getProperty("STRING_PROP")));
        SimpleDataModelTest.assertEquals((String)"foo10true", (String)this.dm.getStringProperty("STRING_PROP"));
    }

    public void testFiringEvents() {
        this.dmL.clearEvents();
        this.dm.notifyDefaultChange("INT_PROP2");
        List events = this.dmL.getEvents();
        SimpleDataModelTest.assertEquals((int)1, (int)events.size());
        WTPOperationDataModelEvent event = (WTPOperationDataModelEvent)events.get(0);
        SimpleDataModelTest.assertEquals((String)"INT_PROP2", (String)event.getPropertyName());
        SimpleDataModelTest.assertEquals((int)1, (int)event.getFlag());
        this.dmL.clearEvents();
        this.dm.notifyValidValuesChange("INT_PROP2");
        events = this.dmL.getEvents();
        SimpleDataModelTest.assertEquals((int)1, (int)events.size());
        event = (WTPOperationDataModelEvent)events.get(0);
        SimpleDataModelTest.assertEquals((String)"INT_PROP2", (String)event.getPropertyName());
        SimpleDataModelTest.assertEquals((int)4, (int)event.getFlag());
    }

    public void testSimpleSetEvents() {
        this.dmL.clearEvents();
        this.dm.setIntProperty("INT_PROP2", 100);
        List events = this.dmL.getEvents();
        SimpleDataModelTest.assertEquals((int)1, (int)events.size());
        WTPOperationDataModelEvent event = (WTPOperationDataModelEvent)events.get(0);
        SimpleDataModelTest.assertEquals((String)"INT_PROP2", (String)event.getPropertyName());
        SimpleDataModelTest.assertEquals((int)1, (int)event.getFlag());
        SimpleDataModelTest.assertEquals((int)100, (int)this.dm.getIntProperty("INT_PROP2"));
        this.dmL.clearEvents();
        this.dm.setIntProperty("INT_PROP2", 100);
        events = this.dmL.getEvents();
        SimpleDataModelTest.assertEquals((int)0, (int)events.size());
        this.dmL.clearEvents();
        this.dm.setIntProperty("INT_PROP2", 101);
        events = this.dmL.getEvents();
        SimpleDataModelTest.assertEquals((int)1, (int)events.size());
        event = (WTPOperationDataModelEvent)events.get(0);
        SimpleDataModelTest.assertEquals((String)"INT_PROP2", (String)event.getPropertyName());
    }

    public void testComplexEvents() {
        this.dmL.clearEvents();
        this.dm.setIntProperty("INT_PROP", 11);
        List events = this.dmL.getEvents();
        SimpleDataModelTest.assertEquals((int)4, (int)events.size());
        WTPOperationDataModelEvent event = (WTPOperationDataModelEvent)events.get(0);
        SimpleDataModelTest.assertEquals((String)"INT_PROP2", (String)event.getPropertyName());
        SimpleDataModelTest.assertEquals((int)1, (int)event.getFlag());
        SimpleDataModelTest.assertEquals((int)11, (int)((Integer)this.dm.getProperty("INT_PROP2")));
        event = (WTPOperationDataModelEvent)events.get(1);
        SimpleDataModelTest.assertEquals((String)"INT_PROP2", (String)event.getPropertyName());
        SimpleDataModelTest.assertEquals((int)4, (int)event.getFlag());
        WTPPropertyDescriptor[] descriptors = event.getValidPropertyDescriptors();
        WTPPropertyDescriptor[] descriptors2 = this.dm.getValidPropertyDescriptors("INT_PROP2");
        SimpleDataModelTest.assertEquals((int)11, (int)descriptors.length);
        SimpleDataModelTest.assertEquals((int)11, (int)descriptors2.length);
        event = (WTPOperationDataModelEvent)events.get(2);
        SimpleDataModelTest.assertEquals((String)"STRING_PROP", (String)event.getPropertyName());
        SimpleDataModelTest.assertEquals((int)1, (int)event.getFlag());
        SimpleDataModelTest.assertEquals((Object)"foo11true", (Object)event.getProperty());
        event = (WTPOperationDataModelEvent)events.get(3);
        SimpleDataModelTest.assertEquals((String)"INT_PROP", (String)event.getPropertyName());
        SimpleDataModelTest.assertEquals((int)1, (int)event.getFlag());
        SimpleDataModelTest.assertEquals((int)11, (int)((Integer)this.dm.getProperty("INT_PROP")));
        this.dmL.clearEvents();
        this.dm.setBooleanProperty("BOOLEAN_PROP", false);
        events = this.dmL.getEvents();
        SimpleDataModelTest.assertEquals((int)3, (int)events.size());
        event = (WTPOperationDataModelEvent)events.get(0);
        SimpleDataModelTest.assertEquals((String)"BOOLEAN_PROP2", (String)event.getPropertyName());
        SimpleDataModelTest.assertEquals((int)3, (int)event.getFlag());
        SimpleDataModelTest.assertFalse((boolean)this.dm.isEnabled("BOOLEAN_PROP2"));
        event = (WTPOperationDataModelEvent)events.get(1);
        SimpleDataModelTest.assertEquals((String)"STRING_PROP", (String)event.getPropertyName());
        SimpleDataModelTest.assertEquals((int)1, (int)event.getFlag());
        SimpleDataModelTest.assertEquals((Object)"foo11false", (Object)event.getProperty());
        event = (WTPOperationDataModelEvent)events.get(2);
        SimpleDataModelTest.assertEquals((String)"BOOLEAN_PROP", (String)event.getPropertyName());
        SimpleDataModelTest.assertEquals((int)1, (int)event.getFlag());
        SimpleDataModelTest.assertEquals((boolean)false, (boolean)this.dm.getBooleanProperty("BOOLEAN_PROP"));
        this.dm.setProperty("STRING_PROP", "bar");
        SimpleDataModelTest.assertEquals((String)"bar", (String)this.dm.getStringProperty("STRING_PROP"));
        this.dmL.clearEvents();
        this.dm.setBooleanProperty("BOOLEAN_PROP", true);
        events = this.dmL.getEvents();
        SimpleDataModelTest.assertEquals((int)2, (int)events.size());
        event = (WTPOperationDataModelEvent)events.get(0);
        SimpleDataModelTest.assertEquals((String)"BOOLEAN_PROP2", (String)event.getPropertyName());
        event = (WTPOperationDataModelEvent)events.get(1);
        SimpleDataModelTest.assertEquals((String)"BOOLEAN_PROP", (String)event.getPropertyName());
        SimpleDataModelTest.assertEquals((String)"bar", (String)this.dm.getStringProperty("STRING_PROP"));
        this.dm.setProperty("STRING_PROP", null);
        SimpleDataModelTest.assertEquals((String)"foo11true", (String)this.dm.getStringProperty("STRING_PROP"));
        this.dmL.clearEvents();
        this.dm.setBooleanProperty("BOOLEAN_PROP", false);
        events = this.dmL.getEvents();
        SimpleDataModelTest.assertEquals((int)3, (int)events.size());
        event = (WTPOperationDataModelEvent)events.get(0);
        SimpleDataModelTest.assertEquals((String)"BOOLEAN_PROP2", (String)event.getPropertyName());
        SimpleDataModelTest.assertEquals((int)3, (int)event.getFlag());
        SimpleDataModelTest.assertFalse((boolean)this.dm.isEnabled("BOOLEAN_PROP2"));
        event = (WTPOperationDataModelEvent)events.get(1);
        SimpleDataModelTest.assertEquals((String)"STRING_PROP", (String)event.getPropertyName());
        SimpleDataModelTest.assertEquals((int)1, (int)event.getFlag());
        SimpleDataModelTest.assertEquals((Object)"foo11false", (Object)event.getProperty());
        event = (WTPOperationDataModelEvent)events.get(2);
        SimpleDataModelTest.assertEquals((String)"BOOLEAN_PROP", (String)event.getPropertyName());
        SimpleDataModelTest.assertEquals((int)1, (int)event.getFlag());
        SimpleDataModelTest.assertEquals((boolean)false, (boolean)this.dm.getBooleanProperty("BOOLEAN_PROP"));
    }

    private class DM
    extends WTPOperationDataModel {
        public static final String INT_PROP = "INT_PROP";
        public static final String INT_PROP2 = "INT_PROP2";
        public static final String INT_PROP3 = "INT_PROP3";
        public static final String INT_PROP4 = "INT_PROP4";
        public static final String BOOLEAN_PROP = "BOOLEAN_PROP";
        public static final String BOOLEAN_PROP2 = "BOOLEAN_PROP2";
        public static final String STRING_PROP = "STRING_PROP";

        DM() {
        }

        protected void initValidBaseProperties() {
            super.initValidBaseProperties();
            this.addValidBaseProperty(INT_PROP);
            this.addValidBaseProperty(INT_PROP2);
            this.addValidBaseProperty(INT_PROP3);
            this.addValidBaseProperty(INT_PROP4);
            this.addValidBaseProperty(BOOLEAN_PROP);
            this.addValidBaseProperty(BOOLEAN_PROP2);
            this.addValidBaseProperty(STRING_PROP);
        }

        protected Object getDefaultProperty(String propertyName) {
            if (propertyName.equals(INT_PROP)) {
                return new Integer(10);
            }
            if (propertyName.equals(INT_PROP2)) {
                return this.getProperty(INT_PROP);
            }
            if (propertyName.equals(BOOLEAN_PROP)) {
                return Boolean.TRUE;
            }
            if (propertyName.equals(STRING_PROP)) {
                return "foo" + this.getProperty(INT_PROP) + this.getProperty(BOOLEAN_PROP);
            }
            return super.getDefaultProperty(propertyName);
        }

        protected Boolean basicIsEnabled(String propertyName) {
            if (propertyName.equals(BOOLEAN_PROP2)) {
                return (Boolean)this.getProperty(BOOLEAN_PROP);
            }
            return super.basicIsEnabled(propertyName);
        }

        protected boolean doSetProperty(String propertyName, Object propertyValue) {
            boolean success = super.doSetProperty(propertyName, propertyValue);
            if (propertyName.equals(INT_PROP)) {
                this.notifyDefaultChange(INT_PROP2);
                this.notifyValidValuesChange(INT_PROP2);
                this.notifyDefaultChange(STRING_PROP);
            }
            if (propertyName.equals(BOOLEAN_PROP)) {
                this.notifyEnablementChange(BOOLEAN_PROP2);
                this.notifyDefaultChange(STRING_PROP);
            }
            return success;
        }

        protected WTPPropertyDescriptor[] doGetValidPropertyDescriptors(String propertyName) {
            if (INT_PROP2.equals(propertyName)) {
                int range = this.getIntProperty(INT_PROP);
                Object[] ints = new Integer[range];
                int i = 0;
                while (i < ints.length) {
                    ints[i] = new Integer(i + 1);
                    ++i;
                }
                return WTPPropertyDescriptor.createDescriptors((Object[])ints);
            }
            if (INT_PROP3.equals(propertyName)) {
                int range = 3;
                Object[] ints = new Integer[range];
                int i = 0;
                while (i < ints.length) {
                    ints[i] = new Integer(i + 1);
                    ++i;
                }
                String[] descriptions = new String[]{"one", "two", "three"};
                return WTPPropertyDescriptor.createDescriptors((Object[])ints, (String[])descriptions);
            }
            if (INT_PROP4.equals(propertyName)) {
                WTPPropertyDescriptor[] descriptors = new WTPPropertyDescriptor[3];
                String[] descriptions = new String[]{"one", "two", "three"};
                int i = 0;
                while (i < descriptors.length) {
                    descriptors[i] = new WTPPropertyDescriptor((Object)new Integer(i + 1), descriptions[i]);
                    ++i;
                }
                return descriptors;
            }
            return super.doGetValidPropertyDescriptors(propertyName);
        }

        public WTPOperation getDefaultOperation() {
            return null;
        }
    }
}

