/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.wizard.fragment;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.TaskModel;
import org.eclipse.wst.server.core.internal.IModuleVisitor;
import org.eclipse.wst.server.core.internal.IPublishTask;
import org.eclipse.wst.server.core.internal.ProjectProperties;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.model.PublishOperation;
import org.eclipse.wst.server.ui.internal.EclipseUtil;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.ProgressUtil;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.editor.IOrdered;
import org.eclipse.wst.server.ui.internal.editor.ServerEditorCore;
import org.eclipse.wst.server.ui.internal.wizard.page.TasksComposite;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.eclipse.wst.server.ui.wizard.WizardFragment;

public class TasksWizardFragment
extends WizardFragment {
    protected TasksComposite comp;
    protected List tasks;
    protected boolean hasOptionalTasks;
    protected Map selectedTaskMap = new HashMap();

    public void enter() {
        this.updateTasks();
        if (this.comp != null) {
            this.comp.createControl();
        }
    }

    public List getChildFragments() {
        this.updateTasks();
        return super.getChildFragments();
    }

    public void setTaskModel(TaskModel taskModel) {
        super.setTaskModel(taskModel);
        this.updateTasks();
    }

    public void updateTasks() {
        this.tasks = null;
        if (this.getTaskModel() == null) {
            return;
        }
        IServer server = (IServer)this.getTaskModel().getObject("server");
        ArrayList modules = (ArrayList)this.getTaskModel().getObject("modules");
        if (server != null && modules == null) {
            final ArrayList moduleList = new ArrayList();
            ((Server)server).visit(new IModuleVisitor(){

                public boolean visit(IModule[] module2) {
                    moduleList.add(module2);
                    return true;
                }
            }, null);
            modules = moduleList;
        }
        if (server != null && modules != null) {
            this.tasks = new ArrayList();
            this.createTasks(server, modules);
        }
        if (this.comp != null) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    TasksWizardFragment.this.comp.setTasks(TasksWizardFragment.this.tasks);
                }
            });
        }
    }

    protected void createTasks(IServer server, List modules) {
        IPublishTask[] publishTasks;
        String serverTypeId = null;
        if (server != null) {
            serverTypeId = server.getServerType().getId();
        }
        if ((publishTasks = ServerPlugin.getPublishTasks()) != null) {
            int size = publishTasks.length;
            int i = 0;
            while (i < size) {
                PublishOperation[] tasks2;
                IPublishTask task = publishTasks[i];
                if (serverTypeId != null && task.supportsType(serverTypeId) && (tasks2 = task.getTasks(server, modules)) != null) {
                    int size2 = tasks2.length;
                    int j = 0;
                    while (j < size2) {
                        int kind = tasks2[j].getKind();
                        if (kind == 0 || kind == 1) {
                            this.hasOptionalTasks = true;
                        }
                        tasks2[j].setTaskModel(this.getTaskModel());
                        this.addServerTask(server, tasks2[j]);
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    public void addServerTask(IServer server, PublishOperation task2) {
        TaskInfo sti = new TaskInfo();
        sti.task2 = task2;
        sti.kind = task2.getKind();
        String id = server.getId();
        sti.id = String.valueOf(id) + "|" + task2.getLabel();
        if (sti.kind == 1 || sti.kind == 2) {
            sti.setDefaultSelected(true);
        }
        this.tasks.add(sti);
    }

    public boolean hasComposite() {
        return this.hasTasks();
    }

    public Composite createComposite(Composite parent, IWizardHandle wizard) {
        this.comp = new TasksComposite(parent, wizard);
        return this.comp;
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException {
        ArrayList performTasks = new ArrayList();
        if (this.tasks == null) {
            return;
        }
        int size = this.tasks.size();
        int i = 0;
        while (i < size) {
            TaskInfo ti = (TaskInfo)this.tasks.get(i);
            if (ti.isSelected()) {
                performTasks.add(this.tasks.get(i));
            }
            ++i;
        }
        Trace.trace(Trace.FINEST, "Performing wizard tasks: " + performTasks.size());
        if (performTasks.size() == 0) {
            return;
        }
        boolean createdServerWC = false;
        TaskModel taskModel = this.getTaskModel();
        IServer server = (IServer)taskModel.getObject("server");
        if (server == null) {
            return;
        }
        IServerWorkingCopy serverWC = null;
        if (server instanceof IServerWorkingCopy) {
            serverWC = (IServerWorkingCopy)server;
        } else {
            serverWC = server.createWorkingCopy();
            createdServerWC = true;
        }
        taskModel.putObject("server", (Object)serverWC);
        monitor.beginTask(Messages.performingTasks, performTasks.size() * 1000);
        ServerEditorCore.sortOrderedList(performTasks);
        Iterator iterator = performTasks.iterator();
        while (iterator.hasNext()) {
            IProgressMonitor subMonitor = ProgressUtil.getSubMonitorFor(monitor, 1000);
            Object obj = iterator.next();
            if (obj instanceof TaskInfo) {
                TaskInfo sti = (TaskInfo)obj;
                try {
                    Trace.trace(Trace.FINER, "Executing task: " + sti.task2.getLabel());
                    sti.task2.setTaskModel(taskModel);
                    sti.task2.execute(subMonitor, null);
                }
                catch (CoreException ce) {
                    Trace.trace(Trace.SEVERE, "Error executing task " + sti.task2.getLabel(), ce);
                    throw ce;
                }
            }
            subMonitor.done();
        }
        if (createdServerWC) {
            if (serverWC.isDirty()) {
                IFile file = ((Server)serverWC).getFile();
                if (file != null) {
                    ProjectProperties pp;
                    IProject project = file.getProject();
                    if (!file.getProject().exists()) {
                        EclipseUtil.createNewServerProject(null, project.getName(), null, monitor);
                    }
                    if (!(pp = (ProjectProperties)ServerCore.getProjectProperties((IProject)project)).isServerProject()) {
                        pp.setServerProject(true, monitor);
                    }
                }
                taskModel.putObject("server", (Object)serverWC.save(false, monitor));
            } else {
                taskModel.putObject("server", (Object)serverWC.getOriginal());
            }
        }
        monitor.done();
    }

    public boolean hasTasks() {
        return this.tasks == null || !this.tasks.isEmpty();
    }

    public boolean hasOptionalTasks() {
        return this.hasOptionalTasks;
    }

    public class TaskInfo
    implements IOrdered {
        public int kind;
        public String id;
        public PublishOperation task2;
        private static final String DEFAULT = "default:";

        public boolean isSelected() {
            if (this.id == null) {
                return false;
            }
            if (TasksWizardFragment.this.selectedTaskMap.containsKey(this.id)) {
                return (Boolean)TasksWizardFragment.this.selectedTaskMap.get(this.id);
            }
            if (TasksWizardFragment.this.selectedTaskMap.containsKey(DEFAULT + this.id)) {
                return (Boolean)TasksWizardFragment.this.selectedTaskMap.get(DEFAULT + this.id);
            }
            return false;
        }

        public void setDefaultSelected(boolean sel) {
            TasksWizardFragment.this.selectedTaskMap.put(DEFAULT + this.getId(), new Boolean(sel));
        }

        public void setSelected(boolean sel) {
            TasksWizardFragment.this.selectedTaskMap.put(this.getId(), new Boolean(sel));
        }

        public int getOrder() {
            return this.task2.getOrder();
        }

        protected String getId() {
            return this.id;
        }
    }
}

