/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.tests;

import junit.framework.Test;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.wst.server.core.IProjectProperties;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.IProjectPropertiesListener;
import org.eclipse.wst.server.core.internal.ProjectProperties;
import org.eclipse.wst.server.core.tests.OrderedTestSuite;

public class ProjectPropertiesTestCase
extends TestCase {
    protected static IProject project;
    protected static IProjectProperties props;
    protected static IProject projectEvent;
    protected static IServer serverEvent;
    protected static IRuntime runtimeEvent;
    protected static int count;
    protected IProjectPropertiesListener listener = new IProjectPropertiesListener(){

        public void runtimeTargetChanged(IProject project2, IRuntime runtime) {
            projectEvent = project2;
            runtimeEvent = runtime;
            ++count;
        }
    };
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.server.core.tests.ProjectPropertiesTestCase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new OrderedTestSuite(clazz, "AbstractServerTestCase");
    }

    public void test00GetProperties() throws Exception {
        project = ResourcesPlugin.getWorkspace().getRoot().getProject("test");
        if (project != null && !project.exists()) {
            project.create(null);
            project.open(null);
        }
        props = ServerCore.getProjectProperties((IProject)project);
    }

    public void test01AddListener() throws Exception {
        ((ProjectProperties)props).addProjectPropertiesListener(this.listener);
    }

    public void test03GetRuntime() throws Exception {
        ProjectPropertiesTestCase.assertNull((Object)props.getRuntimeTarget());
    }

    public void test04GetServerProject() throws Exception {
        ProjectPropertiesTestCase.assertFalse((boolean)((ProjectProperties)props).isServerProject());
    }

    public void test05TestListener() throws Exception {
        ProjectPropertiesTestCase.assertTrue((count == 0 ? 1 : 0) != 0);
    }

    public void test07TestListener() throws Exception {
        ProjectPropertiesTestCase.assertTrue((count == 0 ? 1 : 0) != 0);
        count = 0;
        serverEvent = null;
    }

    public void test08SetRuntime() throws Exception {
        props.setRuntimeTarget(null, null);
    }

    public void test09TestListener() throws Exception {
        ProjectPropertiesTestCase.assertTrue((count == 0 ? 1 : 0) != 0);
        count = 0;
        runtimeEvent = null;
    }

    public void test10SetServerProject() throws Exception {
        ProjectProperties pp = (ProjectProperties)props;
        pp.setServerProject(true, null);
        ProjectPropertiesTestCase.assertTrue((boolean)pp.isServerProject());
    }

    public void test11UnsetServerProject() throws Exception {
        ProjectProperties pp = (ProjectProperties)props;
        pp.setServerProject(false, null);
        ProjectPropertiesTestCase.assertFalse((boolean)pp.isServerProject());
    }

    public void test12TestListener() throws Exception {
        ProjectPropertiesTestCase.assertTrue((count == 0 ? 1 : 0) != 0);
    }

    public void test13RemoveListener() throws Exception {
        ((ProjectProperties)props).removeProjectPropertiesListener(this.listener);
    }

    public void test14End() throws Exception {
        project.delete(true, true, null);
    }

    public void test15CheckListener() throws Exception {
        IProjectPropertiesListener listener2 = new IProjectPropertiesListener(){

            public void runtimeTargetChanged(IProject project2, IRuntime runtime) {
            }
        };
        listener2.runtimeTargetChanged(null, null);
    }
}

