/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.tests;

import junit.framework.Test;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerListener;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerEvent;
import org.eclipse.wst.server.core.ServerPort;
import org.eclipse.wst.server.core.tests.OrderedTestSuite;

public class ServerEventTestCase
extends TestCase {
    private static ServerEvent event;
    private static int SAMPLE_KIND;
    private static IServer SAMPLE_SERVER;
    private static IModule[] SAMPLE_MODULE_TREE;
    private static int SAMPLE_STATE;
    private static int SAMPLE_PUBLISHING_STATE;
    private static boolean SAMPLE_RESTART_STATE;
    static /* synthetic */ Class class$0;

    static {
        SAMPLE_KIND = 1;
        SAMPLE_SERVER = ServerEventTestCase.createSampleServer();
        SAMPLE_MODULE_TREE = new IModule[1];
        SAMPLE_STATE = 1;
        SAMPLE_PUBLISHING_STATE = 2;
        SAMPLE_RESTART_STATE = true;
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.server.core.tests.ServerEventTestCase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new OrderedTestSuite(clazz, "ServerEventTestCase");
    }

    public static IServer createSampleServer() {
        return new IServer(){

            public int getServerState() {
                return 0;
            }

            public String getMode() {
                return null;
            }

            public int getServerPublishState() {
                return 0;
            }

            public int getModulePublishState(IModule[] module) {
                return 0;
            }

            public void addServerListener(IServerListener listener) {
            }

            public void addServerListener(IServerListener listener, int eventMask) {
            }

            public void removeServerListener(IServerListener listener) {
            }

            public IStatus canPublish() {
                return null;
            }

            public IStatus publish(int kind, IProgressMonitor monitor) {
                return null;
            }

            public IStatus canStart(String launchMode) {
                return null;
            }

            public void start(String launchMode, IProgressMonitor monitor) throws CoreException {
            }

            public void start(String launchMode, IServer.IOperationListener listener) {
            }

            public void synchronousStart(String launchMode, IProgressMonitor monitor) throws CoreException {
            }

            public IStatus canRestart(String mode) {
                return null;
            }

            public boolean getServerRestartState() {
                return false;
            }

            public void restart(String mode, IProgressMonitor monitor) {
            }

            public void restart(String mode, IServer.IOperationListener listener) {
            }

            public void synchronousRestart(String launchMode, IProgressMonitor monitor) throws CoreException {
            }

            public IStatus canStop() {
                return null;
            }

            public void stop(boolean force) {
            }

            public void stop(boolean force, IServer.IOperationListener listener) {
            }

            public void synchronousStop(boolean force) {
            }

            public IStatus canControlModule(IModule[] module, IProgressMonitor monitor) {
                return null;
            }

            public boolean getModuleRestartState(IModule[] module) {
                return false;
            }

            public int getModuleState(IModule[] module) {
                return 0;
            }

            public String getName() {
                return null;
            }

            public String getId() {
                return null;
            }

            public void delete() throws CoreException {
            }

            public boolean isReadOnly() {
                return false;
            }

            public boolean isWorkingCopy() {
                return false;
            }

            public Object loadAdapter(Class c, IProgressMonitor monitor) {
                return null;
            }

            public String getHost() {
                return null;
            }

            public IRuntime getRuntime() {
                return null;
            }

            public IServerType getServerType() {
                return null;
            }

            public IFolder getServerConfiguration() {
                return null;
            }

            public IServerWorkingCopy createWorkingCopy() {
                return null;
            }

            public IModule[] getModules() {
                return null;
            }

            public IStatus canModifyModules(IModule[] add, IModule[] remove, IProgressMonitor monitor) {
                return null;
            }

            public IModule[] getChildModules(IModule[] module, IProgressMonitor monitor) {
                return null;
            }

            public IModule[] getRootModules(IModule module, IProgressMonitor monitor) throws CoreException {
                return null;
            }

            public ServerPort[] getServerPorts(IProgressMonitor monitor) {
                return null;
            }

            public Object getAdapter(Class adapter) {
                return null;
            }

            public void startModule(IModule[] module, IServer.IOperationListener listener) {
            }

            public void stopModule(IModule[] module, IServer.IOperationListener listener) {
            }

            public void restartModule(IModule[] module, IServer.IOperationListener listener) {
            }
        };
    }

    public static ServerEvent createSampleServerEvent() {
        return new ServerEvent(SAMPLE_KIND, SAMPLE_SERVER, SAMPLE_STATE, SAMPLE_PUBLISHING_STATE, SAMPLE_RESTART_STATE);
    }

    public void test010CreateServerEvent() {
        event = ServerEventTestCase.createSampleServerEvent();
    }

    public void test011ServerGetKind() {
        ServerEventTestCase.assertTrue(((event.getKind() & (0x10 | SAMPLE_KIND)) != 0 ? 1 : 0) != 0);
    }

    public void test013ServerGetPublishingState() {
        ServerEventTestCase.assertEquals((int)SAMPLE_PUBLISHING_STATE, (int)event.getPublishState());
    }

    public void test014ServerGetRestartState() {
        ServerEventTestCase.assertEquals((boolean)SAMPLE_RESTART_STATE, (boolean)event.getRestartState());
    }

    public void test015ServerGetServer() {
        ServerEventTestCase.assertEquals((Object)SAMPLE_SERVER, (Object)event.getServer());
    }

    public void test016ServerGetState() {
        ServerEventTestCase.assertEquals((int)SAMPLE_STATE, (int)event.getState());
    }

    public void test110CreateModuleEvent() {
        try {
            event = new ServerEvent(SAMPLE_KIND, SAMPLE_SERVER, SAMPLE_MODULE_TREE, SAMPLE_STATE, SAMPLE_PUBLISHING_STATE, SAMPLE_RESTART_STATE);
        }
        catch (Exception exception) {}
    }

    public void test111ModuleGetKind() {
        ServerEventTestCase.assertTrue(((event.getKind() & (0x20 | SAMPLE_KIND)) != 0 ? 1 : 0) != 0);
    }

    public void test112ModuleGetModuleTree() {
        try {
            ServerEventTestCase.assertEquals((Object)SAMPLE_MODULE_TREE, (Object)event.getModule());
        }
        catch (Exception exception) {}
    }

    public void test113ModuleGetPublishingState() {
        ServerEventTestCase.assertEquals((int)SAMPLE_PUBLISHING_STATE, (int)event.getPublishState());
    }

    public void test114ModuleGetRestartState() {
        ServerEventTestCase.assertEquals((boolean)SAMPLE_RESTART_STATE, (boolean)event.getRestartState());
    }

    public void test115ModuleGetServer() {
        ServerEventTestCase.assertEquals((Object)SAMPLE_SERVER, (Object)event.getServer());
    }

    public void test116ModuleGetState() {
        ServerEventTestCase.assertEquals((int)SAMPLE_STATE, (int)event.getState());
    }
}

