/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentAdapter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.FormattingContext;
import org.eclipse.jface.text.formatter.IContentFormatterExtension;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.projection.ProjectionDocument;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.wst.sse.core.internal.cleanup.StructuredContentCleanupHandler;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.undo.IDocumentSelectionMediator;
import org.eclipse.wst.sse.core.internal.undo.IStructuredTextUndoManager;
import org.eclipse.wst.sse.core.internal.undo.UndoDocumentEvent;
import org.eclipse.wst.sse.ui.internal.IExtendedSimpleEditor;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.sse.ui.internal.StructuredDocumentCommand;
import org.eclipse.wst.sse.ui.internal.StructuredDocumentToTextAdapter;
import org.eclipse.wst.sse.ui.internal.ViewerSelectionManager;
import org.eclipse.wst.sse.ui.internal.ViewerSelectionManagerImpl;
import org.eclipse.wst.sse.ui.internal.provisional.StructuredTextViewerConfiguration;
import org.eclipse.wst.sse.ui.internal.provisional.style.IHighlighter;
import org.eclipse.wst.sse.ui.internal.reconcile.StructuredRegionProcessor;
import org.eclipse.wst.sse.ui.internal.util.PlatformStatusLineUtil;
import org.eclipse.wst.sse.ui.internal.view.events.INodeSelectionListener;
import org.eclipse.wst.sse.ui.internal.view.events.NodeSelectionChangedEvent;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class StructuredTextViewer
extends ProjectionViewer
implements IDocumentSelectionMediator {
    private static final int BASE = 20;
    public static final int CLEANUP_DOCUMENT = 21;
    public static final int FORMAT_ACTIVE_ELEMENTS = 23;
    private static final String FORMAT_ACTIVE_ELEMENTS_TEXT = SSEUIMessages.Format_Active_Elements_UI_;
    public static final int FORMAT_DOCUMENT = 22;
    private static final String FORMAT_DOCUMENT_TEXT = SSEUIMessages.Format_Document_UI_;
    public static final int QUICK_FIX = 24;
    private static final String TEXT_CUT = SSEUIMessages.Text_Cut_UI_;
    private static final String TEXT_PASTE = SSEUIMessages.Text_Paste_UI_;
    private static final String TEXT_SHIFT_LEFT = SSEUIMessages.Text_Shift_Left_UI_;
    private static final String TEXT_SHIFT_RIGHT = SSEUIMessages.Text_Shift_Right_UI_;
    private boolean fBackgroundupdateInProgress;
    protected StructuredContentCleanupHandler fContentCleanupHandler = null;
    protected IContentAssistant fCorrectionAssistant;
    protected boolean fCorrectionAssistantInstalled;
    private IDocumentAdapter fDocAdapter;
    private InternalSelectionListener fSelectionListener = null;
    private StructuredDocumentCommand fDocumentCommand = new StructuredDocumentCommand();
    private IHighlighter fHighlighter;
    boolean fRememberedStateContentAssistInstalled;
    private TextVerifyListener fVerifyListener = new TextVerifyListener();
    private ViewerSelectionManager fViewerSelectionManager;
    private SourceViewerConfiguration fConfiguration;
    static /* synthetic */ Class class$0;

    public StructuredTextViewer(Composite parent, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean showAnnotationsOverview, int styles) {
        super(parent, verticalRuler, overviewRuler, showAnnotationsOverview, styles);
        this.fSelectionListener = new InternalSelectionListener();
    }

    private void beep() {
        this.getTextWidget().getDisplay().beep();
    }

    void beginBackgroundUpdate() {
        this.fBackgroundupdateInProgress = true;
        this.disableRedrawing();
    }

    public boolean canDoOperation(int operation) {
        if (this.fBackgroundupdateInProgress) {
            return false;
        }
        switch (operation) {
            case 13: {
                IDocument doc = this.getDocument();
                if (doc == null || !(doc instanceof IStructuredDocument)) break;
                return this.isEditable() && !((IStructuredDocument)doc).containsReadOnly(this.getSelectedRange().x, 0);
            }
            case 24: {
                return this.isEditable();
            }
            case 21: {
                return this.fContentCleanupHandler != null && this.isEditable();
            }
            case 22: 
            case 23: {
                return this.fContentFormatter != null && this.isEditable();
            }
        }
        return super.canDoOperation(operation);
    }

    public void configure(SourceViewerConfiguration configuration) {
        IReconciler newReconciler;
        if (this.getTextWidget() == null) {
            return;
        }
        this.setDocumentPartitioning(configuration.getConfiguredDocumentPartitioning((ISourceViewer)this));
        if (configuration instanceof StructuredTextViewerConfiguration) {
            if (this.fHighlighter != null) {
                this.fHighlighter.uninstall();
            }
            this.fHighlighter = ((StructuredTextViewerConfiguration)configuration).getHighlighter((ISourceViewer)this);
            this.fHighlighter.install((ITextViewer)this);
        }
        if (this.fPresentationReconciler != null) {
            this.fPresentationReconciler.uninstall();
        }
        this.fPresentationReconciler = configuration.getPresentationReconciler((ISourceViewer)this);
        if (this.fPresentationReconciler != null) {
            this.fPresentationReconciler.install((ITextViewer)this);
        }
        if ((newReconciler = configuration.getReconciler((ISourceViewer)this)) != this.fReconciler || newReconciler == null || this.fReconciler == null) {
            if (this.fReconciler != null) {
                this.fReconciler.uninstall();
            }
            this.fReconciler = newReconciler;
            if (this.fReconciler != null) {
                this.fReconciler.install((ITextViewer)this);
                ((StructuredRegionProcessor)this.fReconciler).setDocument(this.getDocument());
            }
        }
        if (this.fContentAssistant != null) {
            this.fContentAssistant.uninstall();
        }
        this.fContentAssistant = configuration.getContentAssistant((ISourceViewer)this);
        if (this.fContentAssistant != null) {
            this.fContentAssistant.install((ITextViewer)this);
            this.fContentAssistantInstalled = true;
        } else {
            this.enableOperation(13, false);
        }
        if (configuration instanceof StructuredTextViewerConfiguration) {
            if (this.fCorrectionAssistant != null) {
                this.fCorrectionAssistant.uninstall();
            }
            this.fCorrectionAssistant = ((StructuredTextViewerConfiguration)configuration).getCorrectionAssistant((ISourceViewer)this);
            if (this.fCorrectionAssistant != null) {
                this.fCorrectionAssistant.install((ITextViewer)this);
                this.fCorrectionAssistantInstalled = true;
            } else {
                this.enableOperation(24, false);
            }
        }
        this.fContentFormatter = configuration.getContentFormatter((ISourceViewer)this);
        IInformationPresenter newInformationPresenter = configuration.getInformationPresenter((ISourceViewer)this);
        if (newInformationPresenter == null || this.fInformationPresenter == null || !newInformationPresenter.equals(this.fInformationPresenter)) {
            if (this.fInformationPresenter != null) {
                this.fInformationPresenter.uninstall();
            }
            this.fInformationPresenter = newInformationPresenter;
            if (this.fInformationPresenter != null) {
                this.fInformationPresenter.install((ITextViewer)this);
            }
        }
        if (this.fUndoManager != null) {
            this.fUndoManager.disconnect();
        }
        this.setUndoManager(configuration.getUndoManager((ISourceViewer)this));
        this.getTextWidget().setTabs(configuration.getTabWidth((ISourceViewer)this));
        this.setAnnotationHover(configuration.getAnnotationHover((ISourceViewer)this));
        this.setOverviewRulerAnnotationHover(configuration.getOverviewRulerAnnotationHover((ISourceViewer)this));
        this.setHoverControlCreator(configuration.getInformationControlCreator((ISourceViewer)this));
        if (this.fHyperlinkManager != null) {
            this.setHyperlinkDetectors(null, 0);
        }
        this.setHyperlinkPresenter(configuration.getHyperlinkPresenter((ISourceViewer)this));
        IHyperlinkDetector[] hyperlinkDetectors = configuration.getHyperlinkDetectors((ISourceViewer)this);
        int eventStateMask = configuration.getHyperlinkStateMask((ISourceViewer)this);
        this.setHyperlinkDetectors(hyperlinkDetectors, eventStateMask);
        String[] types = configuration.getConfiguredContentTypes((ISourceViewer)this);
        this.fAutoIndentStrategies = null;
        int i = 0;
        while (i < types.length) {
            String t = types[i];
            this.setAutoEditStrategies(configuration.getAutoEditStrategies((ISourceViewer)this, t), t);
            this.setTextDoubleClickStrategy(configuration.getDoubleClickStrategy((ISourceViewer)this, t), t);
            int[] stateMasks = configuration.getConfiguredTextHoverStateMasks((ISourceViewer)this, t);
            if (stateMasks != null) {
                int j = 0;
                while (j < stateMasks.length) {
                    int stateMask = stateMasks[j];
                    this.setTextHover(configuration.getTextHover((ISourceViewer)this, t, stateMask), t, stateMask);
                    ++j;
                }
            } else {
                this.setTextHover(configuration.getTextHover((ISourceViewer)this, t), t, 255);
            }
            String[] prefixes = configuration.getIndentPrefixes((ISourceViewer)this, t);
            if (prefixes != null && prefixes.length > 0) {
                this.setIndentPrefixes(prefixes, t);
            }
            if ((prefixes = configuration.getDefaultPrefixes((ISourceViewer)this, t)) != null && prefixes.length > 0) {
                this.setDefaultPrefixes(prefixes, t);
            }
            ++i;
        }
        this.activatePlugins();
        this.fConfiguration = configuration;
    }

    private boolean containsReadOnly(IDocument document, int startOffset, int endOffset) {
        IDocument doc;
        int start = startOffset;
        int end = endOffset;
        IStructuredDocument structuredDocument = null;
        if (document instanceof IStructuredDocument) {
            structuredDocument = (IStructuredDocument)document;
        } else if (document instanceof ProjectionDocument && (doc = ((ProjectionDocument)document).getMasterDocument()) instanceof IStructuredDocument) {
            structuredDocument = (IStructuredDocument)doc;
            int adjust = ((ProjectionDocument)document).getProjectionMapping().getCoverage().getOffset();
            start = adjust + start;
            end = adjust + end;
        }
        if (structuredDocument == null) {
            return false;
        }
        int length = end - start;
        return structuredDocument.containsReadOnly(start, length);
    }

    protected IDocumentAdapter createDocumentAdapter() {
        this.fDocAdapter = new StructuredDocumentToTextAdapter(this.getTextWidget());
        return this.fDocAdapter;
    }

    protected void customizeDocumentCommand(StructuredDocumentCommand command) {
        if (this.isIgnoringAutoEditStrategies()) {
            return;
        }
        ArrayList strategies = (ArrayList)this.selectContentTypePlugin(command.offset, this.fAutoIndentStrategies);
        if (strategies == null) {
            return;
        }
        switch (strategies.size()) {
            case 0: {
                break;
            }
            case 1: {
                ((IAutoEditStrategy)strategies.iterator().next()).customizeDocumentCommand(this.getDocument(), (DocumentCommand)command);
                break;
            }
            default: {
                strategies = new ArrayList(strategies);
                IDocument document = this.getDocument();
                Iterator iterator = strategies.iterator();
                while (iterator.hasNext()) {
                    ((IAutoEditStrategy)iterator.next()).customizeDocumentCommand(document, (DocumentCommand)command);
                }
                break block0;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doOperation(int operation) {
        Point selection = this.getTextWidget().getSelection();
        int cursorPosition = selection.x;
        int selectionLength = selection.y - selection.x;
        switch (operation) {
            case 1: {
                IExtendedSimpleEditor editor = this.getActiveExtendedSimpleEditor();
                if (editor != null) {
                    IStatus status = editor.validateEdit(this.getControl().getShell());
                    if (status == null) return;
                    if (!status.isOK()) return;
                    this.undo();
                    return;
                }
                this.undo();
                return;
            }
            case 2: {
                IExtendedSimpleEditor editor = this.getActiveExtendedSimpleEditor();
                if (editor != null) {
                    IStatus status = editor.validateEdit(this.getControl().getShell());
                    if (status == null) return;
                    if (!status.isOK()) return;
                    this.redo();
                    return;
                }
                this.redo();
                return;
            }
            case 3: {
                this.beginRecording(TEXT_CUT, TEXT_CUT, cursorPosition, selectionLength);
                super.doOperation(operation);
                selection = this.getTextWidget().getSelection();
                cursorPosition = selection.x;
                selectionLength = selection.y - selection.x;
                this.endRecording(cursorPosition, selectionLength);
                return;
            }
            case 5: {
                this.beginRecording(TEXT_PASTE, TEXT_PASTE, cursorPosition, selectionLength);
                super.doOperation(operation);
                selection = this.getTextWidget().getSelection();
                cursorPosition = selection.x;
                selectionLength = selection.y - selection.x;
                this.endRecording(cursorPosition, selectionLength);
                return;
            }
            case 13: {
                if (this.fContentAssistant == null) return;
                if (!this.isEditable()) return;
                if (!this.canDoOperation(13)) {
                    this.beep();
                    return;
                }
                String err = this.fContentAssistant.showPossibleCompletions();
                if (err != null) {
                    PlatformStatusLineUtil.displayErrorMessage(err);
                }
                PlatformStatusLineUtil.addOneTimeClearListener();
                return;
            }
            case 14: {
                if (this.fContentAssistant == null) return;
                String err = this.fContentAssistant.showContextInformation();
                PlatformStatusLineUtil.displayErrorMessage(err);
                PlatformStatusLineUtil.addOneTimeClearListener();
                return;
            }
            case 24: {
                if (!this.isEditable()) return;
                String msg = this.fCorrectionAssistant.showPossibleCompletions();
                this.setErrorMessage(msg);
                return;
            }
            case 8: {
                this.beginRecording(TEXT_SHIFT_RIGHT, TEXT_SHIFT_RIGHT, cursorPosition, selectionLength);
                this.updateIndentationPrefixes();
                super.doOperation(8);
                selection = this.getTextWidget().getSelection();
                cursorPosition = selection.x;
                selectionLength = selection.y - selection.x;
                this.endRecording(cursorPosition, selectionLength);
                return;
            }
            case 9: {
                this.beginRecording(TEXT_SHIFT_LEFT, TEXT_SHIFT_LEFT, cursorPosition, selectionLength);
                this.updateIndentationPrefixes();
                super.doOperation(9);
                selection = this.getTextWidget().getSelection();
                cursorPosition = selection.x;
                selectionLength = selection.y - selection.x;
                this.endRecording(cursorPosition, selectionLength);
                return;
            }
            case 22: {
                try {
                    this.beginRecording(FORMAT_DOCUMENT_TEXT, FORMAT_DOCUMENT_TEXT, cursorPosition, selectionLength);
                    IRegion region = this.getModelCoverage();
                    if (this.fContentFormatter instanceof IContentFormatterExtension) {
                        IContentFormatterExtension extension = (IContentFormatterExtension)this.fContentFormatter;
                        FormattingContext context = new FormattingContext();
                        context.setProperty((Object)"formatting.context.document", (Object)Boolean.TRUE);
                        context.setProperty((Object)"formatting.context.region", (Object)region);
                        extension.format(this.getDocument(), (IFormattingContext)context);
                    } else {
                        this.fContentFormatter.format(this.getDocument(), region);
                    }
                    Object var8_21 = null;
                }
                catch (Throwable throwable) {
                    Object var8_20 = null;
                    selection = this.getTextWidget().getSelection();
                    cursorPosition = selection.x;
                    selectionLength = selection.y - selection.x;
                    this.endRecording(cursorPosition, selectionLength);
                    throw throwable;
                }
                selection = this.getTextWidget().getSelection();
                cursorPosition = selection.x;
                selectionLength = selection.y - selection.x;
                this.endRecording(cursorPosition, selectionLength);
                return;
            }
            case 23: {
                try {
                    this.beginRecording(FORMAT_ACTIVE_ELEMENTS_TEXT, FORMAT_ACTIVE_ELEMENTS_TEXT, cursorPosition, selectionLength);
                    Point s = this.getSelectedRange();
                    Region region = new Region(s.x, s.y);
                    this.fContentFormatter.format(this.getDocument(), (IRegion)region);
                    Object var7_18 = null;
                }
                catch (Throwable throwable) {
                    Object var7_17 = null;
                    selection = this.getTextWidget().getSelection();
                    cursorPosition = selection.x;
                    selectionLength = selection.y - selection.x;
                    this.endRecording(cursorPosition, selectionLength);
                    throw throwable;
                }
                selection = this.getTextWidget().getSelection();
                cursorPosition = selection.x;
                selectionLength = selection.y - selection.x;
                this.endRecording(cursorPosition, selectionLength);
                return;
            }
        }
        super.doOperation(operation);
    }

    private void endRecording(int cursorPosition, int selectionLength) {
        IDocument doc = this.getDocument();
        if (doc instanceof IStructuredDocument) {
            IStructuredDocument structuredDocument = (IStructuredDocument)doc;
            IStructuredTextUndoManager undoManager = structuredDocument.getUndoManager();
            undoManager.endRecording((Object)this, cursorPosition, selectionLength);
        }
    }

    private void beginRecording(String label, String description, int cursorPosition, int selectionLength) {
        IDocument doc = this.getDocument();
        if (doc instanceof IStructuredDocument) {
            IStructuredDocument structuredDocument = (IStructuredDocument)doc;
            IStructuredTextUndoManager undoManager = structuredDocument.getUndoManager();
            undoManager.beginRecording((Object)this, label, description, cursorPosition, selectionLength);
        }
    }

    void endBackgroundUpdate() {
        this.fBackgroundupdateInProgress = false;
        this.enabledRedrawing();
    }

    protected int findAndSelect(int startPosition, String findString, boolean forwardSearch, boolean caseSensitive, boolean wholeWord, boolean regExSearch) {
        int result = super.findAndSelect(startPosition, findString, forwardSearch, caseSensitive, wholeWord, regExSearch);
        this.notifyViewerSelectionManager(this.getSelectedRange().x, this.getSelectedRange().y);
        return result;
    }

    protected IExtendedSimpleEditor getActiveExtendedSimpleEditor() {
        IEditorPart editor;
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null && (editor = page.getActiveEditor()) != null && editor instanceof IExtendedSimpleEditor) {
            return (IExtendedSimpleEditor)editor;
        }
        return null;
    }

    protected ViewerSelectionManager getDefaultViewerSelectionManager() {
        return new ViewerSelectionManagerImpl((ITextViewer)this);
    }

    public ViewerSelectionManager getViewerSelectionManager() {
        if (this.fViewerSelectionManager == null) {
            ViewerSelectionManager viewerSelectionManager = this.getDefaultViewerSelectionManager();
            this.setViewerSelectionManager(viewerSelectionManager);
        }
        return this.fViewerSelectionManager;
    }

    protected void handleDispose() {
        Logger.trace("Source Editor", "StructuredTextViewer::handleDispose entry");
        this.setSelection((ISelection)TextSelection.emptySelection());
        if (this.fViewerSelectionManager != null) {
            this.fViewerSelectionManager.removeNodeDoubleClickListener(this.fSelectionListener);
            this.fViewerSelectionManager.removeNodeSelectionListener(this.fSelectionListener);
            this.fViewerSelectionManager.release();
        }
        if (this.fHighlighter != null) {
            this.fHighlighter.uninstall();
        }
        super.handleDispose();
        Logger.trace("Source Editor", "StructuredTextViewer::handleDispose exit");
    }

    void handleDoubleClick(DoubleClickEvent event) {
        Object o;
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        int selectionSize = selection.size();
        List selectedNodes = selection.toList();
        IndexedRegion doubleClickedNode = null;
        int selectionStart = 0;
        int selectionEnd = 0;
        if (selectionSize > 0 && (o = selectedNodes.get(0)) instanceof IndexedRegion) {
            doubleClickedNode = (IndexedRegion)o;
            selectionStart = doubleClickedNode.getStartOffset();
            selectionEnd = doubleClickedNode.getEndOffset();
            this.setSelectedRange(selectionStart, selectionEnd - selectionStart);
        }
    }

    void handleNodeSelectionChanged(NodeSelectionChangedEvent event) {
        if (event.getSource().equals((Object)this)) {
            return;
        }
        Vector<Node> selectedNodes = new Vector<Node>(event.getSelectedNodes());
        boolean attrOrTextNodeSelected = false;
        int attrOrTextNodeStartOffset = 0;
        int i = 0;
        while (i < selectedNodes.size()) {
            Object eachNode = selectedNodes.get(i);
            if (eachNode instanceof Attr) {
                attrOrTextNodeSelected = true;
                attrOrTextNodeStartOffset = ((IndexedRegion)eachNode).getStartOffset();
                selectedNodes.set(i, ((Attr)eachNode).getOwnerElement());
            }
            if (eachNode instanceof Node && ((Node)eachNode).getNodeType() == 3) {
                attrOrTextNodeSelected = true;
                attrOrTextNodeStartOffset = ((IndexedRegion)eachNode).getStartOffset();
                selectedNodes.set(i, ((Node)eachNode).getParentNode());
            }
            ++i;
        }
        if (this.nothingToSelect(selectedNodes)) {
            this.removeRangeIndication();
        } else {
            IndexedRegion startNode = (IndexedRegion)selectedNodes.get(0);
            IndexedRegion endNode = (IndexedRegion)selectedNodes.get(selectedNodes.size() - 1);
            int startOffset = startNode.getStartOffset();
            int endOffset = endNode.getEndOffset();
            if (startNode.getEndOffset() > endNode.getEndOffset()) {
                endOffset = startNode.getEndOffset();
            }
            int length = endOffset - startOffset;
            boolean moveCursor = event.getSource() instanceof ContentViewer || event.getSource() instanceof IContentOutlinePage;
            this.setRangeIndication(startOffset, length, moveCursor);
            if (moveCursor && attrOrTextNodeSelected) {
                this.setSelectedRange(attrOrTextNodeStartOffset, 0);
                this.revealRange(attrOrTextNodeStartOffset, 0);
            }
        }
    }

    /*
     * Exception decompiling
     */
    protected void handleVerifyEvent(VerifyEvent e) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [1 : 232->238)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int modelLine2WidgetLine(int modelLine) {
        IDocument document;
        if (this.fInformationMapping == null && (document = this.getDocument()) != null) {
            try {
                IRegion modelLineRegion = this.getDocument().getLineInformation(modelLine);
                IRegion region = this.getModelCoverage();
                if (modelLineRegion != null && region != null) {
                    int modelEnd = modelLineRegion.getOffset() + modelLineRegion.getLength();
                    int regionEnd = region.getOffset() + region.getLength();
                    if (modelLineRegion.getOffset() < region.getOffset() || modelEnd > regionEnd) {
                        return -1;
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                return -1;
            }
        }
        return super.modelLine2WidgetLine(modelLine);
    }

    public int modelOffset2WidgetOffset(int modelOffset) {
        IRegion region;
        if (this.fInformationMapping == null && (region = this.getModelCoverage()) != null && (modelOffset < region.getOffset() || modelOffset > region.getOffset() + region.getLength())) {
            return -1;
        }
        return super.modelOffset2WidgetOffset(modelOffset);
    }

    public IRegion modelRange2WidgetRange(IRegion modelRange) {
        IRegion region;
        if (this.fInformationMapping == null && (region = this.getModelCoverage()) != null && modelRange != null) {
            int modelEnd = modelRange.getOffset() + modelRange.getLength();
            int regionEnd = region.getOffset() + region.getLength();
            if (modelRange.getOffset() < region.getOffset() || modelEnd > regionEnd) {
                return null;
            }
        }
        return super.modelRange2WidgetRange(modelRange);
    }

    private boolean nothingToSelect(List selectedNodes) {
        if (selectedNodes == null || selectedNodes.isEmpty() || selectedNodes.get(0) == null) {
            return true;
        }
        if (this.getDocument() == null) {
            return true;
        }
        Object o = selectedNodes.get(0);
        if (o instanceof IndexedRegion) {
            IndexedRegion firstIndexedNode = (IndexedRegion)o;
            return firstIndexedNode.getEndOffset() - firstIndexedNode.getStartOffset() >= this.getDocument().getLength();
        }
        return true;
    }

    protected void notifyViewerSelectionManager(int offset, int length) {
        if (this.fViewerSelectionManager != null) {
            Event event = new Event();
            event.widget = this.getTextWidget();
            if (event.widget != null) {
                SelectionEvent selectionEvent = new SelectionEvent(event);
                selectionEvent.x = offset;
                selectionEvent.y = offset + length;
                this.fViewerSelectionManager.widgetSelected(selectionEvent);
            }
        }
    }

    private void redo() {
        this.ignoreAutoEditStrategies(true);
        this.fUndoManager.redo();
        this.ignoreAutoEditStrategies(false);
    }

    public void setDocument(IDocument document, IAnnotationModel annotationModel, int modelRangeOffset, int modelRangeLength) {
        if (document == null && this.fReconciler != null) {
            this.fReconciler.uninstall();
        }
        super.setDocument(document, annotationModel, modelRangeOffset, modelRangeLength);
        if (document instanceof IStructuredDocument) {
            IStructuredDocument structuredDocument = (IStructuredDocument)document;
            if (this.fHighlighter != null) {
                this.fHighlighter.setDocument(structuredDocument);
            }
            if (this.fUndoManager != null) {
                this.fUndoManager.disconnect();
                this.fUndoManager.connect((ITextViewer)this);
            }
            this.notifyViewerSelectionManager(this.getSelectedRange().x, this.getSelectedRange().y);
        }
    }

    protected void setErrorMessage(String msg) {
        IEditorPart editor;
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null && (editor = page.getActiveEditor()) != null) {
            IEditorStatusLine statusLine;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.IEditorStatusLine");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((statusLine = (IEditorStatusLine)editor.getAdapter((Class)clazz)) != null) {
                statusLine.setMessage(true, msg, null);
            }
        }
    }

    public void setViewerSelectionManager(ViewerSelectionManager viewerSelectionManager) {
        if (this.fViewerSelectionManager != null) {
            this.fViewerSelectionManager.removeNodeDoubleClickListener(this.fSelectionListener);
            this.fViewerSelectionManager.removeNodeSelectionListener(this.fSelectionListener);
            this.fViewerSelectionManager.release();
        }
        this.fViewerSelectionManager = viewerSelectionManager;
        if (this.fViewerSelectionManager != null) {
            this.fViewerSelectionManager.addNodeDoubleClickListener(this.fSelectionListener);
            this.fViewerSelectionManager.addNodeSelectionListener(this.fSelectionListener);
        }
    }

    public void unconfigure() {
        Logger.trace("Source Editor", "StructuredTextViewer::unconfigure entry");
        if (this.fHighlighter != null) {
            this.fHighlighter.uninstall();
        }
        this.setErrorMessage(null);
        super.unconfigure();
        this.fConfiguration = null;
        Logger.trace("Source Editor", "StructuredTextViewer::unconfigure exit");
    }

    private void undo() {
        this.ignoreAutoEditStrategies(true);
        this.fUndoManager.undo();
        this.ignoreAutoEditStrategies(false);
    }

    public void undoOperationSelectionChanged(UndoDocumentEvent event) {
        if (event.getRequester() != null && event.getRequester().equals((Object)this) && event.getDocument().equals(this.getDocument())) {
            this.setSelectedRange(event.getOffset(), event.getLength());
        }
    }

    private void updateIndentationPrefixes() {
        SourceViewerConfiguration configuration = this.fConfiguration;
        if (this.fConfiguration != null) {
            String[] types = configuration.getConfiguredContentTypes((ISourceViewer)this);
            int i = 0;
            while (i < types.length) {
                String[] prefixes = configuration.getIndentPrefixes((ISourceViewer)this, types[i]);
                if (prefixes != null && prefixes.length > 0) {
                    this.setIndentPrefixes(prefixes, types[i]);
                }
                ++i;
            }
        }
    }

    class TextVerifyListener
    implements VerifyListener {
        private boolean fForward = true;

        TextVerifyListener() {
        }

        public void forward(boolean forward) {
            this.fForward = forward;
        }

        public void verifyText(VerifyEvent e) {
            if (this.fForward) {
                StructuredTextViewer.this.handleVerifyEvent(e);
            }
        }
    }

    private class InternalSelectionListener
    implements INodeSelectionListener,
    IDoubleClickListener {
        InternalSelectionListener() {
        }

        public void doubleClick(DoubleClickEvent event) {
            StructuredTextViewer.this.handleDoubleClick(event);
        }

        public void nodeSelectionChanged(NodeSelectionChangedEvent event) {
            StructuredTextViewer.this.handleNodeSelectionChanged(event);
        }
    }
}

