/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.provisional.contentproperties;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.SAXException;

class SimpleNodeOperator {
    private Document fDocument;
    private Node root;
    private String settingsFileName;

    public static void main(String[] args) {
        SimpleNodeOperator a = null;
        try {
            a = new SimpleNodeOperator("workspace/org.eclipse.examples.contentsettings/.contentsettings.xml");
        }
        catch (Exception exception) {
            System.exit(0);
        }
        Hashtable<String, String> attMap = new Hashtable<String, String>();
        attMap.put("path", "hogepath");
        attMap.put("fDocument-type", "documenthogehoge");
        a.addElementUnderRoot("file", attMap);
        try {
            a.writeDocument(System.out);
        }
        catch (Exception e) {
            System.err.println(e.toString());
        }
    }

    public SimpleNodeOperator(Document doc) throws CreateContentSettingsFailureException {
        if (doc == null) {
            throw new CreateContentSettingsFailureException("Document doc==null");
        }
        this.fDocument = doc;
        this.root = this.fDocument.getLastChild();
        if (this.root == null) {
            throw new CreateContentSettingsFailureException("Node root==null");
        }
    }

    public SimpleNodeOperator(String fullPath) throws ReadContentSettingsFailureException {
        this.settingsFileName = fullPath;
        this.createObjectOfDocument();
    }

    protected Node addAttributeAt(Element ele, String attName, String attValue) {
        Attr att = this.fDocument.createAttribute(attName);
        att.setValue(attValue);
        if (ele != null) {
            ele.setAttributeNode(att);
        }
        return ele;
    }

    protected Node addElementUnder(Node parent, String tagName, Map attMap) {
        if (parent == null || tagName == null) {
            return null;
        }
        Element e = this.fDocument.createElement(tagName);
        if (attMap != null && !attMap.isEmpty()) {
            Set attKeys = attMap.keySet();
            Iterator iter = attKeys.iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                e.setAttribute(key, (String)attMap.get(key));
            }
        }
        parent.appendChild(e);
        return e;
    }

    protected final Node addElementUnderRoot(String tagName) {
        return this.addElementUnder(this.root, tagName, null);
    }

    protected final Node addElementUnderRoot(String tagName, Map attMap) {
        return this.addElementUnder(this.root, tagName, attMap);
    }

    private void createObjectOfDocument() throws ReadContentSettingsFailureException {
        try {
            this.fDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new File(this.settingsFileName));
        }
        catch (SAXException e) {
            Logger.logException("exception parsing" + this.settingsFileName, e);
        }
        catch (IOException e) {
            Logger.logException("I/O exception parsing" + this.settingsFileName, e);
        }
        catch (ParserConfigurationException e) {
            Logger.logException("exception accessing DOMImplementation", e);
        }
        catch (FactoryConfigurationError e) {
            Logger.logException("exception accessing DOMImplementation", e);
        }
        this.root = this.fDocument.getLastChild();
        if (this.root == null) {
            throw new ReadContentSettingsFailureException("Error: Node root==null");
        }
    }

    protected Map getAttributesOf(Node node) {
        if (!node.hasAttributes()) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        NamedNodeMap attrs = node.getAttributes();
        int size = attrs.getLength();
        int i = 0;
        while (i < size) {
            Attr attr = (Attr)attrs.item(i);
            map.put(attr.getName(), attr.getValue());
            ++i;
        }
        return map;
    }

    private Node getElementWithAttribute(Node first, String attName, String attValue) {
        Node navpoint = first;
        while (navpoint != null) {
            if (navpoint.getNodeType() == 1) {
                Node holdNode;
                NamedNodeMap m = navpoint.getAttributes();
                if (m == null) continue;
                if (m.getNamedItem(attName) != null && attValue.equals(((Attr)m.getNamedItem(attName)).getNodeValue())) {
                    return navpoint;
                }
                NodeList childNodes = navpoint.getChildNodes();
                if (childNodes != null && childNodes.getLength() > 0 && (holdNode = this.getElementWithAttribute(navpoint.getFirstChild(), attName, attValue)) != null) {
                    return holdNode;
                }
            }
            navpoint = navpoint.getNextSibling();
        }
        return null;
    }

    protected Node getElementWithAttribute(String attName, String attValue) {
        if (attName == null || attValue == null || !this.fDocument.hasChildNodes()) {
            return null;
        }
        return this.getElementWithAttribute(this.fDocument.getFirstChild(), attName, attValue);
    }

    protected Node getElementWithNodeName(String nodeName) {
        if (nodeName == null) {
            return null;
        }
        NodeList nodes = this.fDocument.getElementsByTagName(nodeName);
        if (nodes.getLength() > 0) {
            return nodes.item(0);
        }
        return null;
    }

    public void printTree(NodeIterator iter) {
        Node n;
        while ((n = iter.nextNode()) != null) {
            System.out.println(String.valueOf(n.getNodeName()) + ":");
            NamedNodeMap m = n.getAttributes();
            if (m == null) continue;
            int i = 0;
            while (i < m.getLength()) {
                String attName = m.item(i).getNodeName();
                System.out.print(" " + attName + "=" + m.item(i).getNodeValue());
                ++i;
            }
            System.out.println("");
        }
    }

    protected Attr removeAttributeAt(Element ele, String attName) {
        if (ele == null || attName == null) {
            return null;
        }
        Attr att = ele.getAttributeNode(attName);
        ele.removeAttribute(attName);
        return att;
    }

    protected Element removeElementWith(String nodeName) {
        NodeList nodes = this.fDocument.getElementsByTagName(nodeName);
        int i = 0;
        while (i < nodes.getLength()) {
            nodes.item(i).getParentNode().removeChild(nodes.item(i));
            ++i;
        }
        return null;
    }

    protected Element removeElementWith(String attName, String attValue) {
        Node element;
        if (this.fDocument.hasChildNodes() && (element = this.getElementWithAttribute(attName, attValue)) != null && element.getNodeType() == 1) {
            element.getParentNode().removeChild(element);
            return (Element)element;
        }
        return null;
    }

    protected void updateAttributeAt(Element ele, String attName, String newValue) {
        Attr att = null;
        if (ele != null && (att = ele.getAttributeNode(attName)) != null) {
            att.setValue(newValue);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void writeDocument(OutputStream out) throws WriteContentSettingsFailureException {
        XMLDocumentWriter writer = new XMLDocumentWriter(out);
        try {
            writer.serialize(this.fDocument);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            writer.close();
            throw throwable;
        }
        {
            Object var3_5 = null;
            writer.close();
            return;
        }
    }

    class CreateContentSettingsFailureException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public CreateContentSettingsFailureException(String reason) {
            super(reason);
        }
    }

    class ReadContentSettingsFailureException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ReadContentSettingsFailureException(String reason) {
            super(reason);
        }
    }

    static class WriteContentSettingsFailureException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public WriteContentSettingsFailureException(String reason) {
            super(reason);
        }
    }

    class XMLDocumentWriter {
        OutputStream fOut;

        protected XMLDocumentWriter(OutputStream out) {
            this.fOut = out;
        }

        protected final void close() {
            try {
                this.fOut.close();
            }
            catch (IOException iOException) {}
        }

        protected void serialize(Document sourceDocument) throws WriteContentSettingsFailureException {
            DOMSource domSource = new DOMSource(sourceDocument);
            try {
                Transformer serializer = TransformerFactory.newInstance().newTransformer();
                try {
                    serializer.setOutputProperty("indent", "yes");
                    serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                serializer.transform(domSource, new StreamResult(this.fOut));
            }
            catch (TransformerConfigurationException e) {
                throw new WriteContentSettingsFailureException(e.getMessage());
            }
            catch (TransformerFactoryConfigurationError e) {
                throw new WriteContentSettingsFailureException(e.getMessage());
            }
            catch (TransformerException e) {
                throw new WriteContentSettingsFailureException(e.getMessage());
            }
        }
    }
}

