/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.search;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.sse.ui.internal.search.BasicFindOccurrencesAction;
import org.eclipse.wst.sse.ui.internal.util.PlatformStatusLineUtil;

public class FindOccurrencesActionProvider
extends TextEditorAction {
    private List fActions = null;

    public FindOccurrencesActionProvider(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
    }

    public void addAction(BasicFindOccurrencesAction action) {
        this.getActions().add(action);
    }

    private BasicFindOccurrencesAction getActionForCurrentSelection() {
        ITypedRegion tr = this.getPartition();
        String partition = tr != null ? tr.getType() : "";
        Iterator it = this.getActions().iterator();
        BasicFindOccurrencesAction action = null;
        while (it.hasNext()) {
            action = (BasicFindOccurrencesAction)((Object)it.next());
            if (!action.enabledForParitition(partition)) continue;
            return action;
        }
        return null;
    }

    private List getActions() {
        if (this.fActions == null) {
            this.fActions = new ArrayList();
        }
        return this.fActions;
    }

    private IDocument getDocument() {
        return this.getTextEditor().getDocumentProvider().getDocument((Object)this.getTextEditor().getEditorInput());
    }

    private ITypedRegion getPartition() {
        ITextSelection sel = this.getTextSelection();
        ITypedRegion region = null;
        if (sel != null) {
            try {
                region = this.getDocument().getPartition(sel.getOffset());
            }
            catch (BadLocationException badLocationException) {
                region = null;
            }
        }
        return region;
    }

    private ITextSelection getTextSelection() {
        ISelection selection = this.getTextEditor().getSelectionProvider().getSelection();
        if (selection instanceof ITextSelection && !selection.isEmpty()) {
            ITextSelection textSel = (ITextSelection)selection;
            return textSel;
        }
        return null;
    }

    public boolean isEnabled() {
        return true;
    }

    public void run() {
        BasicFindOccurrencesAction action = this.getActionForCurrentSelection();
        String errorMessage = SSEUIMessages.FindOccurrencesActionProvider_0;
        if (action != null) {
            action.update();
            if (action.isEnabled()) {
                NewSearchUI.activateSearchResultView();
                action.run();
                PlatformStatusLineUtil.clearStatusLine();
            } else {
                PlatformStatusLineUtil.displayErrorMessage(errorMessage);
                PlatformStatusLineUtil.addOneTimeClearListener();
            }
        } else {
            PlatformStatusLineUtil.displayErrorMessage(errorMessage);
            PlatformStatusLineUtil.addOneTimeClearListener();
        }
    }

    public void update() {
        super.update();
        PlatformStatusLineUtil.clearStatusLine();
    }
}

