/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.tests.viewer;

import junit.framework.TestCase;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.provisional.style.IHighlighter;
import org.eclipse.wst.xml.ui.internal.XMLUIPlugin;
import org.eclipse.wst.xml.ui.internal.provisional.StructuredTextViewerConfigurationXML;
import org.eclipse.wst.xml.ui.tests.Logger;

public class TestViewerConfigurationXML
extends TestCase {
    private StructuredTextViewer fViewer = null;
    private StructuredTextViewerConfigurationXML fConfig = null;
    private IPreferenceStore fPreferenceStore = null;
    private boolean fDisplayExists = true;
    private boolean isSetup = false;

    public TestViewerConfigurationXML() {
        super("TestViewerConfigurationXML");
    }

    protected void setUp() throws Exception {
        super.setUp();
        if (!this.isSetup) {
            this.setUpPreferences();
            this.setUpViewerConfiguration();
            this.isSetup = true;
        }
    }

    private void setUpPreferences() {
        this.fPreferenceStore = XMLUIPlugin.getDefault().getPreferenceStore();
        this.fPreferenceStore.setValue("hyperlinksEnabled", true);
    }

    private void setUpViewerConfiguration() {
        if (Display.getCurrent() != null) {
            Shell shell = null;
            Composite parent = null;
            shell = PlatformUI.isWorkbenchRunning() ? PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell() : new Shell(Display.getCurrent());
            parent = new Composite((Composite)shell, 0);
            this.fViewer = new StructuredTextViewer(parent, null, null, false, 0);
            this.fConfig = new StructuredTextViewerConfigurationXML(this.fPreferenceStore);
        } else {
            this.fDisplayExists = false;
            Logger.log(1, "Remember, viewer configuration tests are not run because workbench is not open (normal on build machine)");
        }
    }

    public void testGetAutoEditStrategies() {
        if (!this.fDisplayExists) {
            return;
        }
        IAutoEditStrategy[] strategies = this.fConfig.getAutoEditStrategies((ISourceViewer)this.fViewer, "org.eclipse.wst.xml.XML_DEFAULT");
        TestViewerConfigurationXML.assertNotNull((Object)strategies);
        TestViewerConfigurationXML.assertTrue((String)"there are no auto edit strategies", (strategies.length > 0 ? 1 : 0) != 0);
    }

    public void testGetConfiguredContentTypes() {
        if (!this.fDisplayExists) {
            return;
        }
        String[] configuredContentTypes = this.fConfig.getConfiguredContentTypes((ISourceViewer)this.fViewer);
        TestViewerConfigurationXML.assertNotNull((Object)configuredContentTypes);
        TestViewerConfigurationXML.assertTrue((String)"there are no configured content types", (configuredContentTypes.length > 0 ? 1 : 0) != 0);
    }

    public void testGetContentAssistant() {
        if (!this.fDisplayExists) {
            return;
        }
        IContentAssistant ca = this.fConfig.getContentAssistant((ISourceViewer)this.fViewer);
        TestViewerConfigurationXML.assertNotNull((String)"there is no content assistant", (Object)ca);
    }

    public void testGetCorrectionAssistant() {
        if (!this.fDisplayExists) {
            return;
        }
        IContentAssistant ca = this.fConfig.getCorrectionAssistant((ISourceViewer)this.fViewer);
        TestViewerConfigurationXML.assertNotNull((String)"there is no correction assistant", (Object)ca);
    }

    public void testGetContentFormatter() {
        if (!this.fDisplayExists) {
            return;
        }
        IContentFormatter cf = this.fConfig.getContentFormatter((ISourceViewer)this.fViewer);
        TestViewerConfigurationXML.assertNotNull((String)"there is no content formatter", (Object)cf);
    }

    public void testGetDoubleClickStrategy() {
        if (!this.fDisplayExists) {
            return;
        }
        String[] contentTypes = this.fConfig.getConfiguredContentTypes((ISourceViewer)this.fViewer);
        int i = 0;
        while (i < contentTypes.length) {
            ITextDoubleClickStrategy strategy = this.fConfig.getDoubleClickStrategy((ISourceViewer)this.fViewer, contentTypes[i]);
            if (strategy != null) {
                return;
            }
            ++i;
        }
        TestViewerConfigurationXML.assertTrue((String)"there are no configured double click strategies", (boolean)false);
    }

    public void testGetHighlighter() {
        if (!this.fDisplayExists) {
            return;
        }
        IHighlighter highlighter = this.fConfig.getHighlighter((ISourceViewer)this.fViewer);
        TestViewerConfigurationXML.assertNotNull((String)"Highlighter is null", (Object)highlighter);
    }

    public void testGetInformationPresenter() {
        if (!this.fDisplayExists) {
            return;
        }
        IInformationPresenter presenter = this.fConfig.getInformationPresenter((ISourceViewer)this.fViewer);
        TestViewerConfigurationXML.assertNotNull((String)"InformationPresenter is null", (Object)presenter);
    }

    public void testGetAnnotationHover() {
        if (!this.fDisplayExists) {
            return;
        }
        IAnnotationHover hover = this.fConfig.getAnnotationHover((ISourceViewer)this.fViewer);
        TestViewerConfigurationXML.assertNotNull((String)"AnnotationHover is null", (Object)hover);
    }

    public void testUnconfigure() {
        if (!this.fDisplayExists) {
            return;
        }
        this.fConfig.unConfigure((ISourceViewer)this.fViewer);
        this.setUpViewerConfiguration();
    }

    public void testGetReconciler() {
        if (!this.fDisplayExists) {
            return;
        }
        IReconciler r = this.fConfig.getReconciler((ISourceViewer)this.fViewer);
        TestViewerConfigurationXML.assertNotNull((String)"Reconciler is null", (Object)r);
    }

    public void testGetHyperlinkDetectors() {
        if (!this.fDisplayExists) {
            return;
        }
        IHyperlinkDetector[] detectors = this.fConfig.getHyperlinkDetectors((ISourceViewer)this.fViewer);
        TestViewerConfigurationXML.assertNotNull((Object)detectors);
        TestViewerConfigurationXML.assertTrue((String)"there are no hyperlink detectors", (detectors.length > 0 ? 1 : 0) != 0);
    }

    public void testGetTextHover() {
        if (!this.fDisplayExists) {
            return;
        }
        String[] hoverPartitions = new String[]{"org.eclipse.wst.sse.ST_DEFAULT", "org.eclipse.wst.xml.XML_DEFAULT"};
        int i = 0;
        while (i < hoverPartitions.length) {
            ITextHover hover = this.fConfig.getTextHover((ISourceViewer)this.fViewer, hoverPartitions[i], 0);
            TestViewerConfigurationXML.assertNotNull((String)("hover was null for partition: " + hoverPartitions[i]), (Object)hover);
            ++i;
        }
    }

    public void testGetIndentPrefixes() {
        if (!this.fDisplayExists) {
            return;
        }
        String[] contentTypes = this.fConfig.getConfiguredContentTypes((ISourceViewer)this.fViewer);
        int i = 0;
        while (i < contentTypes.length) {
            String[] prefixes = this.fConfig.getIndentPrefixes((ISourceViewer)this.fViewer, contentTypes[i]);
            if (prefixes != null) {
                return;
            }
            ++i;
        }
        TestViewerConfigurationXML.assertTrue((String)"there are no configured indent prefixes", (boolean)false);
    }
}

