/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.tests.utils;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.html.core.tests.utils.TimestampUtil;
import org.osgi.framework.Bundle;

public class FileUtil {
    private static final String PLUGIN_ID = "org.eclipse.wst.html.core.tests";
    public static String fLineSeparator = System.getProperty("line.separator");
    public static String fPathSeparator = System.getProperty("path.separator");
    public static String fFileSeparator = System.getProperty("file.separator");
    static File previousResultsDirectory = null;
    private static String logSubDirectoryPath;
    private static boolean notTriedYet;

    static {
        notTriedYet = true;
    }

    public static File getPreviousResultsDirectory(String directoryRootName) throws IOException {
        if (previousResultsDirectory == null && notTriedYet) {
            DirFilenameFilter dirFilter;
            Bundle bundle = Platform.getBundle((String)PLUGIN_ID);
            URL url = bundle.getEntry("/");
            URL totalURL = new URL(url, "plugin.xml");
            URL finalurl = Platform.asLocalURL((URL)totalURL);
            String finalFile = finalurl.getFile();
            File file = new File(finalFile);
            String finalPath = file.getParent();
            File pluginHomeDir = new File(finalPath);
            File[] allDirs = pluginHomeDir.listFiles(dirFilter = new DirFilenameFilter(directoryRootName));
            if (allDirs.length > 0) {
                File currentNewest = allDirs[0];
                int i = 1;
                while (i < allDirs.length) {
                    File current = allDirs[i];
                    if (current.lastModified() > currentNewest.lastModified()) {
                        currentNewest = current;
                    }
                    ++i;
                }
                previousResultsDirectory = currentNewest;
            }
            notTriedYet = false;
        }
        return previousResultsDirectory;
    }

    public static File makeFileFor(String directory, String filename, String testResultsDirectoryPrefix) throws IOException {
        URL localURL;
        String installPath;
        String totalDirectory;
        String totalPath;
        Bundle bundle = Platform.getBundle((String)PLUGIN_ID);
        URL url = bundle.getEntry("/");
        URL totalURL = new URL(url, totalPath = String.valueOf(totalDirectory = String.valueOf(installPath = (localURL = Platform.asLocalURL((URL)url)).getPath()) + directory) + "/" + filename);
        String finalFile = totalURL.getFile();
        File file = new File(finalFile);
        String finalPath = file.getParent();
        File dir = new File(finalPath);
        if (!dir.exists()) {
            if (testResultsDirectoryPrefix != null && testResultsDirectoryPrefix.length() > 0) {
                FileUtil.getPreviousResultsDirectory(testResultsDirectoryPrefix);
            }
            dir.mkdirs();
        }
        return file;
    }

    public static String getExtension(String filename) {
        String extension = null;
        int dotPostion = filename.lastIndexOf(46);
        extension = dotPostion > -1 ? filename.substring(dotPostion + 1) : new String();
        return extension;
    }

    public static String getLogDirectory() {
        if (logSubDirectoryPath == null) {
            String mainDirectory = "/logs";
            File dir = new File(mainDirectory);
            FileUtil.ensureExists(dir);
            String subDirectory = TimestampUtil.timestamp();
            logSubDirectoryPath = String.valueOf(mainDirectory) + "/" + subDirectory;
            File subdir = new File(logSubDirectoryPath);
            FileUtil.ensureExists(subdir);
        }
        return logSubDirectoryPath;
    }

    public static void ensureExists(File dir) {
        if (!dir.exists()) {
            dir.mkdirs();
        }
    }

    public static String getPerformanceOutputLogName() {
        String result = null;
        String directoryName = FileUtil.getLogDirectory();
        String extension = ".out";
        String baseName = "sedTests";
        long now = System.currentTimeMillis();
        String nowStr = String.valueOf(now);
        result = String.valueOf(directoryName) + fFileSeparator + baseName + nowStr + extension;
        return result;
    }

    public static class DirFilenameFilter
    implements FilenameFilter {
        String startOfAcceptableNames;

        public DirFilenameFilter(String startOfDirName) {
            this.startOfAcceptableNames = startOfDirName;
        }

        public boolean accept(File pathname, String filename) {
            return filename.startsWith(this.startOfAcceptableNames);
        }
    }
}

