/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.emfworkbench.edit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jem.util.RegistryReader;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.wst.common.internal.emfworkbench.EMFWorkbenchContext;
import org.eclipse.wst.common.internal.emfworkbench.EMFWorkbenchEditResourceHandler;
import org.eclipse.wst.common.internal.emfworkbench.edit.EditModelExtensionRegistry;
import org.eclipse.wst.common.internal.emfworkbench.edit.EditModelResource;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModel;
import org.eclipse.wst.common.internal.emfworkbench.integration.IEditModelFactory;

public class EditModelRegistry
extends RegistryReader {
    private static final EditModelRegistry INSTANCE = new EditModelRegistry();
    private final Map factoryConfigurations = new HashMap();
    private static boolean initialized = false;
    public static final String EDIT_MODEL_ELEMENT = "editModel";
    public static final String EDIT_MODEL_ID_ATTR = "editModelID";
    public static final String FACTORY_CLASS_ATTR = "factoryClass";
    public static final String PARENT_MODEL_ATTR = "parentModelID";
    public static final String LOAD_UNKNOWN_RESOURCES_ATTR = "loadUnknownResourcesAsReadOnly";

    protected EditModelRegistry() {
        super("org.eclipse.wst.common.emfworkbench.integration", EDIT_MODEL_ELEMENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EditModelRegistry getInstance() {
        if (EditModelRegistry.isInitialized()) {
            return INSTANCE;
        }
        EditModelRegistry editModelRegistry = INSTANCE;
        synchronized (editModelRegistry) {
            if (!EditModelRegistry.isInitialized()) {
                INSTANCE.readRegistry();
                initialized = true;
            }
        }
        return INSTANCE;
    }

    public boolean readElement(IConfigurationElement element) {
        String editModelID;
        boolean result = false;
        if (element.getName().equals(EDIT_MODEL_ELEMENT) && (editModelID = element.getAttribute(EDIT_MODEL_ID_ATTR)) != null) {
            this.factoryConfigurations.put(editModelID, new EditModelInfo(editModelID, element));
            result = true;
        }
        return result;
    }

    public String getCacheID(String editModelID, Map params) {
        IEditModelFactory factory = this.getEditModelFactoryByKey(editModelID);
        return factory.getCacheID(editModelID, params);
    }

    public EditModel createEditModelForRead(String editModelID, EMFWorkbenchContext context, Map params) {
        return this.getEditModelFactoryByKey(editModelID).createEditModelForRead(editModelID, context, params);
    }

    public EditModel createEditModelForWrite(String editModelID, EMFWorkbenchContext context, Map params) {
        return this.getEditModelFactoryByKey(editModelID).createEditModelForWrite(editModelID, context, params);
    }

    public Collection getEditModelResources(String editModelID) {
        TreeSet resources = new TreeSet();
        EditModelInfo nextEditModelInfo = (EditModelInfo)this.factoryConfigurations.get(editModelID);
        String parentModelID = null;
        HashMap visitedEditModels = new HashMap();
        while (nextEditModelInfo != null && (parentModelID = nextEditModelInfo.getParentModelID()) != null) {
            if (visitedEditModels.containsKey(parentModelID)) {
                throw new IllegalStateException(EMFWorkbenchEditResourceHandler.getString("EditModelRegistry_ERROR_0", new Object[]{editModelID}));
            }
            visitedEditModels.put(parentModelID, null);
            resources.addAll(this.getAllEditModelResources(parentModelID));
            nextEditModelInfo = (EditModelInfo)this.factoryConfigurations.get(parentModelID);
        }
        resources.addAll(this.getAllEditModelResources(editModelID));
        return resources;
    }

    public IEditModelFactory findEditModelFactoryByKey(Object editModelID) {
        IEditModelFactory factory = null;
        EditModelInfo editMdlInfo = (EditModelInfo)this.factoryConfigurations.get(editModelID);
        if (editMdlInfo != null) {
            factory = editMdlInfo.getEditModelFactory();
        }
        return factory;
    }

    protected Collection getAllEditModelResources(String editModelID) {
        ArrayList resources = new ArrayList();
        resources.addAll(this.getLocalEditModelResources(editModelID));
        resources.addAll(this.getExtendedEditModelResources(editModelID));
        return resources;
    }

    protected Collection getLocalEditModelResources(String editModelID) {
        EditModelInfo editMdlInfo = (EditModelInfo)this.factoryConfigurations.get(editModelID);
        return editMdlInfo != null ? editMdlInfo.getEditModelResources() : Collections.EMPTY_LIST;
    }

    protected Collection getExtendedEditModelResources(String editModelID) {
        return EditModelExtensionRegistry.getInstance().getEditModelResources(editModelID);
    }

    protected IEditModelFactory getEditModelFactoryByKey(Object editModelID) {
        IEditModelFactory factory = null;
        EditModelInfo editMdlInfo = (EditModelInfo)this.factoryConfigurations.get(editModelID);
        if (editMdlInfo == null) {
            throw new IllegalArgumentException(EMFWorkbenchEditResourceHandler.getString("EditModelRegistry_ERROR_2", new Object[]{editModelID}));
        }
        factory = editMdlInfo.getEditModelFactory();
        return factory;
    }

    protected static boolean isInitialized() {
        return initialized;
    }

    public class EditModelInfo {
        private String editModelID = null;
        private IConfigurationElement configurationElement = null;
        private IEditModelFactory factory = null;
        private List editModelResources = null;
        private String parentModelID = null;
        private String tostringCache = null;

        public EditModelInfo(String editModelID, IConfigurationElement configurationElement) {
            this.configurationElement = configurationElement;
            this.editModelID = editModelID;
            this.parentModelID = this.configurationElement.getAttribute(EditModelRegistry.PARENT_MODEL_ATTR);
        }

        public List getEditModelResources() {
            this.initializeResources();
            return this.editModelResources;
        }

        public IEditModelFactory getEditModelFactory() {
            if (this.factory == null) {
                if (this.configurationElement != null) {
                    try {
                        this.factory = (IEditModelFactory)this.configurationElement.createExecutableExtension(EditModelRegistry.FACTORY_CLASS_ATTR);
                        String loadUnknownResourceAsReadOnly = this.configurationElement.getAttribute(EditModelRegistry.LOAD_UNKNOWN_RESOURCES_ATTR);
                        Boolean value = loadUnknownResourceAsReadOnly != null ? Boolean.valueOf(loadUnknownResourceAsReadOnly) : Boolean.FALSE;
                        this.factory.setLoadKnownResourcesAsReadOnly(value);
                        this.discardConfigurationElementIfNecessary();
                    }
                    catch (CoreException e) {
                        Logger.getLogger((String)"org.eclipse.wst.common.emfworkbench.integration").logError((Throwable)e);
                    }
                } else {
                    Logger.getLogger().logError(EMFWorkbenchEditResourceHandler.getString("EditModelRegistry_ERROR_1"));
                }
            }
            return this.factory;
        }

        private void initializeResources() {
            if (this.editModelResources == null) {
                if (this.configurationElement != null) {
                    this.editModelResources = new ArrayList();
                    IConfigurationElement[] resources = this.configurationElement.getChildren("editModelResource");
                    int j = 0;
                    while (j < resources.length) {
                        this.editModelResources.add(new EditModelResource(resources[j]));
                        ++j;
                    }
                    this.discardConfigurationElementIfNecessary();
                } else {
                    this.editModelResources = Collections.EMPTY_LIST;
                }
            }
        }

        private void discardConfigurationElementIfNecessary() {
            if (this.editModelResources != null && this.factory != null) {
                this.configurationElement = null;
            }
        }

        public String toString() {
            if (this.tostringCache == null) {
                this.tostringCache = "EditModelID: {" + this.editModelID + "}, Parent Model ID {" + this.parentModelID + "}, Configuration Element: [" + this.configurationElement + "]";
            }
            return this.tostringCache;
        }

        public String getParentModelID() {
            return this.parentModelID;
        }
    }
}

