/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.emfworkbench.operation;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPlatformRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.codegen.ecore.Generator;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.wst.common.frameworks.internal.operations.WTPOperation;
import org.eclipse.wst.common.frameworks.internal.operations.WTPOperationDataModel;
import org.eclipse.wst.common.internal.emfworkbench.operation.DataObjectGenerator;
import sun.tools.jar.Main;

public class DataObjectGeneratorModel
extends WTPOperationDataModel
implements IPlatformRunnable {
    public static final String PROJECT = "DataObjectGeneratorModel.project";
    public static final String XSD_FILES = "DataObjectGeneratorModel.xsdFiles";
    public static final String ECORE_FILES = "DataObjectGeneratorModel.ecoreFiles";
    public static final String WSDL_FILES = "DataObjectGeneratorModel.wsdlFiles";
    public static final String JAVA_FILES = "DataObjectGeneratorModel.javaFiles";
    public static final String MODEL_DIR = "DataObjectGeneratorModel.modelDirectory";
    public static final String DYNAMIC_TEMPLATES = "DataObjectGeneratorModel.dynamicTemplates";
    public static final String FORCE_OVERWRITE = "DataObjectGeneratorModel.forceOverwrite";
    public static final String CAN_GENERATE = "DataObjectGeneratorModel.canGenerate";
    public static final String UPDATE_CLASSPATH = "DataObjectGeneratorModel.updateClasspath";
    public static final String GENERATE_SCHEMA = "DataObjectGeneratorModel.generateSchema";
    public static final String NON_NLS_MARKERS = "DataObjectGeneratorModel.nonNLSMarkers";

    public static void main(String[] args) {
        new DataObjectGeneratorModel().run(args);
    }

    public Object run(Object object) {
        try {
            final String[] arguments = (String[])object;
            final IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run(IProgressMonitor progressMonitor) throws CoreException {
                    block21: {
                        block20: {
                            block19: {
                                try {
                                    try {
                                        boolean keepGenerated = false;
                                        boolean verbose = false;
                                        String ecoreFileName = null;
                                        String outputJar = null;
                                        if (arguments.length == 0) {
                                            DataObjectGeneratorModel.this.printUsage();
                                            Object var14_7 = null;
                                            break block19;
                                        }
                                        int i = 0;
                                        while (true) {
                                            if (i >= arguments.length) {
                                                if (ecoreFileName != null && outputJar != null) break;
                                                DataObjectGeneratorModel.this.printUsage();
                                                break block20;
                                            }
                                            if (arguments[i].equalsIgnoreCase("-keepgenerated")) {
                                                keepGenerated = true;
                                            } else if (arguments[i].equalsIgnoreCase("-ecore")) {
                                                ecoreFileName = arguments[++i];
                                            } else if (arguments[i].equalsIgnoreCase("-output")) {
                                                outputJar = arguments[++i];
                                            } else if (arguments[i].equalsIgnoreCase("-verbose")) {
                                                verbose = true;
                                            }
                                            ++i;
                                        }
                                        if (!verbose) {
                                            progressMonitor = new NullProgressMonitor();
                                        }
                                        DataObjectGeneratorModel g = new DataObjectGeneratorModel();
                                        IProject proj = workspace.getRoot().getProject("TargetProject");
                                        IFolder srcFolder = proj.getFolder("src");
                                        g.setProperty(DataObjectGeneratorModel.MODEL_DIR, srcFolder);
                                        if (!proj.exists()) {
                                            IPath location = proj.getLocation();
                                            proj = Generator.createEMFProject((IPath)srcFolder.getFullPath(), (IPath)location, (List)Collections.EMPTY_LIST, (IProgressMonitor)progressMonitor, (int)Generator.EMF_PLUGIN_PROJECT_STYLE);
                                        }
                                        g.setProperty(DataObjectGeneratorModel.PROJECT, proj);
                                        File ecoreFile = new File(ecoreFileName);
                                        IFile file = proj.getFile("datagraph.ecore");
                                        if (file.exists()) {
                                            file.delete(true, progressMonitor);
                                        }
                                        file.create((InputStream)new FileInputStream(ecoreFile), true, progressMonitor);
                                        g.addEcoreFile(file);
                                        WTPOperation op = g.getDefaultOperation();
                                        op.run(progressMonitor);
                                        proj.build(6, progressMonitor);
                                        Main jartool = new Main(System.out, System.err, "jar");
                                        String[] args = new String[]{"cf", outputJar, "-C", proj.getFolder("runtime").getLocation().toString(), "."};
                                        jartool.run(args);
                                        if (keepGenerated) {
                                            jartool = new Main(System.out, System.err, "jar");
                                            args[0] = "uf";
                                            args[3] = proj.getFolder("src").getLocation().toString();
                                            jartool.run(args);
                                        }
                                        proj.delete(true, true, progressMonitor);
                                        break block21;
                                    }
                                    catch (Exception exception) {
                                        exception.printStackTrace();
                                        throw new CoreException((IStatus)new Status(4, "org.eclipse.jem.util", 0, "EMF Workbench Error", (Throwable)exception));
                                    }
                                }
                                catch (Throwable throwable) {
                                    Object var14_9 = null;
                                    progressMonitor.done();
                                    throw throwable;
                                }
                            }
                            progressMonitor.done();
                            return;
                        }
                        Object var14_8 = null;
                        progressMonitor.done();
                        return;
                    }
                    Object var14_10 = null;
                    progressMonitor.done();
                }
            };
            workspace.run(runnable, (IProgressMonitor)new CodeGenUtil.StreamProgressMonitor(System.out));
            return new Integer(0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new Integer(1);
        }
    }

    public void printUsage() throws Exception {
        System.out.println("Usage arguments:");
        System.out.println("  -ecore <ecore-file>");
        System.out.println("  -output <jar file name>");
        System.out.println("  [-keepGenerated]  [-verbose]");
    }

    public WTPOperation getDefaultOperation() {
        return new DataObjectGenerator(this);
    }

    protected void initValidBaseProperties() {
        this.addValidBaseProperty(PROJECT);
        this.addValidBaseProperty(XSD_FILES);
        this.addValidBaseProperty(ECORE_FILES);
        this.addValidBaseProperty(WSDL_FILES);
        this.addValidBaseProperty(JAVA_FILES);
        this.addValidBaseProperty(MODEL_DIR);
        this.addValidBaseProperty(DYNAMIC_TEMPLATES);
        this.addValidBaseProperty(FORCE_OVERWRITE);
        this.addValidBaseProperty(CAN_GENERATE);
        this.addValidBaseProperty(UPDATE_CLASSPATH);
        this.addValidBaseProperty(GENERATE_SCHEMA);
        this.addValidBaseProperty(NON_NLS_MARKERS);
    }

    protected Object getDefaultProperty(String propertyName) {
        if (propertyName.equals(MODEL_DIR)) {
            return this.getDefaultModelDirectory();
        }
        if (propertyName.equals(FORCE_OVERWRITE) || propertyName.equals(CAN_GENERATE)) {
            return Boolean.TRUE;
        }
        if (propertyName.equals(XSD_FILES) || propertyName.equals(ECORE_FILES) || propertyName.equals(WSDL_FILES) || propertyName.equals(JAVA_FILES)) {
            return Collections.EMPTY_LIST;
        }
        return super.getDefaultProperty(propertyName);
    }

    protected Object getDefaultModelDirectory() {
        IProject project = (IProject)this.getProperty(PROJECT);
        if (project == null) {
            return null;
        }
        return project.getFolder((IPath)new Path("gen/src"));
    }

    private void addFile(String propertyName, IFile file) {
        if (file != null) {
            List<IFile> files;
            if (!this.isSet(propertyName)) {
                files = new ArrayList();
                this.setProperty(propertyName, files);
            } else {
                files = (List)this.getProperty(propertyName);
            }
            files.add(file);
        }
    }

    public void addXSDFile(IFile file) {
        this.addFile(XSD_FILES, file);
    }

    public void addEcoreFile(IFile file) {
        this.addFile(ECORE_FILES, file);
    }

    public void addWSDLFile(IFile file) {
        this.addFile(WSDL_FILES, file);
    }

    public void addJavaFile(IFile file) {
        this.addFile(JAVA_FILES, file);
    }
}

