/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.ui.internal.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.validation.internal.core.IMessageAccess;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.validation.internal.provisional.core.MessageLimitException;
import org.eclipse.wst.wsi.internal.analyzer.MessageAnalyzer;
import org.eclipse.wst.wsi.internal.analyzer.WSIAnalyzerException;
import org.eclipse.wst.wsi.internal.report.AssertionError;
import org.eclipse.wst.wsi.ui.internal.WSIUIPlugin;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationMessage;
import org.eclipse.wst.xml.ui.internal.validation.ValidateAction;
import org.xml.sax.SAXParseException;

public class WSIValidateAction
extends ValidateAction {
    protected IValidator validator;
    protected String wsdlfile = null;
    protected String elementname = null;
    protected String namespace = null;
    protected String parentname = null;
    protected String type = null;
    protected boolean wsdlspecified = false;
    protected boolean exceptionCaught = false;

    public WSIValidateAction(IFile f, boolean showDialog) {
        super(f, showDialog);
    }

    public WSIValidateAction(IFile f, boolean showDialog, String file, String elementname, String namespace, String parentname, String type) {
        this(f, showDialog);
        if (file != null) {
            this.wsdlfile = file.replace('\\', '/');
            if (!this.wsdlfile.startsWith("file:") && !this.wsdlfile.startsWith("http:")) {
                this.wsdlfile = "file:///" + this.wsdlfile;
            }
        }
        this.elementname = elementname;
        this.namespace = namespace;
        this.parentname = parentname;
        this.type = type;
        this.wsdlspecified = true;
    }

    protected void validate(final IFile file1) {
        final MessageAnalyzer messageanalyzer = this.wsdlspecified ? new MessageAnalyzer("file:///" + file1.getLocation().toString(), this.wsdlfile, this.elementname, this.namespace, this.parentname, this.type) : new MessageAnalyzer("file:///" + file1.getLocation().toString());
        IWorkspaceRunnable op = new IWorkspaceRunnable(){

            public void run(IProgressMonitor progressMonitor) throws CoreException {
                WSIValidateAction.this.clearMarkers(file1);
                try {
                    messageanalyzer.validateConformance();
                }
                catch (WSIAnalyzerException ae) {
                    WSIValidateAction.this.exceptionCaught = true;
                    if (ae.getTargetException() instanceof SAXParseException) {
                        WSIValidateAction.this.createMarkers(file1, new ValidationMessage[]{WSIValidateAction.this.createValidationMessageForException((SAXParseException)ae.getTargetException(), ValidationMessage.SEV_NORMAL)});
                    } else {
                        WSIValidateAction.this.createMarkers(file1, new ValidationMessage[]{WSIValidateAction.this.createValidationMessageForException(ae, ValidationMessage.SEV_NORMAL)});
                    }
                }
                catch (Exception exception) {}
                WSIValidateAction.this.createMarkers(file1, WSIValidateAction.this.convertValidationMessages(messageanalyzer.getAssertionWarnings(), ValidationMessage.SEV_LOW));
                WSIValidateAction.this.createMarkers(file1, WSIValidateAction.this.convertValidationMessages(messageanalyzer.getAssertionErrors(), ValidationMessage.SEV_NORMAL));
                ((org.eclipse.wst.xml.ui.internal.validation.core.ValidateAction)WSIValidateAction.this).file.setSessionProperty(ValidationMessage.ERROR_MESSAGE_MAP_QUALIFIED_NAME, (Object)WSIValidateAction.this.getOrCreateReporter().getMessages());
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(op, null);
            if (this.showDialog) {
                if (this.exceptionCaught) {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)WSIUIPlugin.getResourceString("_UI_UNABLE_TO_VALIDATE"), (String)WSIUIPlugin.getResourceString("_UI_PROBLEMS_READING_WSIMSG_FILE"));
                } else if (messageanalyzer.getAssertionErrors().size() != 0) {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)WSIUIPlugin.getResourceString("_UI_VALIDATION_FAILED"), (String)WSIUIPlugin.getResourceString("_UI_THE_WSIMSG_FILE_IS_NOT_VALID"));
                } else if (messageanalyzer.getAssertionWarnings().size() != 0) {
                    String title = WSIUIPlugin.getResourceString("_UI_VALIDATION_SUCEEDED");
                    String message = WSIUIPlugin.getResourceString("_UI_VALIDATION_WARNINGS_DETECTED");
                    MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)title, (String)message);
                } else {
                    String title = WSIUIPlugin.getResourceString("_UI_VALIDATION_SUCEEDED");
                    String message = WSIUIPlugin.getResourceString("_UI_THE_WSIMSG_FILE_IS_VALID");
                    MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)title, (String)message);
                }
            }
        }
        catch (Exception exception) {}
    }

    protected ValidationMessage createValidationMessageForException(SAXParseException error, int severity) {
        String uri = error.getSystemId();
        if (uri == null) {
            uri = error.getPublicId();
        }
        ValidationMessage validationMessage = new ValidationMessage(error.getMessage(), error.getLineNumber(), error.getColumnNumber(), uri);
        validationMessage.setSeverity(severity);
        return validationMessage;
    }

    protected ValidationMessage createValidationMessageForException(WSIAnalyzerException error, int severity) {
        ValidationMessage validationMessage = new ValidationMessage(error.getMessage(), 0, 0);
        validationMessage.setSeverity(severity);
        return validationMessage;
    }

    public ValidationMessage[] convertValidationMessages(List list, int marker) {
        if (list != null) {
            int size = list.size();
            ValidationMessage[] messages = new ValidationMessage[size];
            int i = 0;
            while (i < size) {
                AssertionError assertionError = (AssertionError)list.get(i);
                int n = assertionError.getLine();
                int c = assertionError.getColumn();
                String m = "WS-I: (" + assertionError.getAssertionID() + ") " + assertionError.getErrorMessage();
                ValidationMessage message = new ValidationMessage(m, n, c);
                message.setSeverity(marker);
                messages[i] = message;
                ++i;
            }
            return messages;
        }
        return new ValidationMessage[0];
    }

    class Reporter
    implements IReporter {
        List list = new ArrayList();

        public IMessageAccess getMessageAccess() {
            return null;
        }

        public boolean isCancelled() {
            return false;
        }

        public void removeAllMessages(IValidator origin, Object object) {
        }

        public void removeAllMessages(IValidator origin) {
        }

        public void removeMessageSubset(IValidator validator, Object obj, String groupName) {
        }

        public List getMessages() {
            return this.list;
        }

        public void addMessage(IValidator origin, IMessage message) throws MessageLimitException {
            this.list.add(message);
        }

        public void displaySubtask(IValidator validator, IMessage message) {
        }
    }
}

