/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.navigator.internal.groups;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.wst.common.navigator.internal.groups.ToggleGroupingAction;
import org.eclipse.wst.common.navigator.internal.provisional.views.ICommonActionProvider;
import org.eclipse.wst.common.navigator.internal.provisional.views.NavigatorContentService;
import org.eclipse.wst.common.navigator.internal.views.actions.CommonActionProvider;

public class NavigatorGroupActionProvider
extends CommonActionProvider
implements ICommonActionProvider {
    static final String NAVIGATOR_GROUP_CONTENT_EXTENSION = "org.eclipse.wst.common.navigator.internal.plugin.root";
    private static final String GROUPING_ENABLED = "GROUPING_ENABLED";
    private ToggleGroupingAction toggleGroupingAction;
    private boolean hasAddedAction;

    public void init(IViewPart aViewPart, StructuredViewer aViewer, NavigatorContentService aContentService) {
        this.toggleGroupingAction = new ToggleGroupingAction(aViewer, aContentService);
    }

    public void dispose() {
    }

    public void setActionContext(ActionContext aContext) {
    }

    public boolean fillContextMenu(IMenuManager aMenu) {
        return false;
    }

    public boolean fillActionBars(IActionBars theActionBars) {
        if (!this.hasAddedAction) {
            theActionBars.getMenuManager().add((IAction)this.toggleGroupingAction);
            theActionBars.getToolBarManager().add((IAction)this.toggleGroupingAction);
            this.hasAddedAction = true;
            return true;
        }
        return false;
    }

    public void restoreState(IMemento aMemento) {
        if (aMemento != null) {
            super.restoreState(aMemento);
            Integer isGroupingEnabledValue = aMemento.getInteger(GROUPING_ENABLED);
            this.toggleGroupingAction.setGroupingEnabled(isGroupingEnabledValue != null ? isGroupingEnabledValue == 1 : true);
        }
    }

    public void saveState(IMemento aMemento) {
        if (aMemento != null) {
            super.saveState(aMemento);
            aMemento.putInteger(GROUPING_ENABLED, this.toggleGroupingAction.isGroupingEnabled() ? 1 : 0);
        }
    }
}

