/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.command.internal.provisional.env.core.uri;

import java.net.URL;
import java.util.Hashtable;
import org.eclipse.wst.command.internal.provisional.env.core.common.MessageUtils;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.uri.RelativeScheme;
import org.eclipse.wst.command.internal.provisional.env.core.uri.URI;
import org.eclipse.wst.command.internal.provisional.env.core.uri.URIException;
import org.eclipse.wst.command.internal.provisional.env.core.uri.URIFactory;
import org.eclipse.wst.command.internal.provisional.env.core.uri.URIScheme;

public class SimpleURIFactory
implements URIFactory {
    private Hashtable schemes_ = new Hashtable();
    private MessageUtils msg_ = new MessageUtils("org.eclipse.wst.command.env.core.environment", this);

    public URI newURI(String uri) throws URIException {
        URIScheme scheme = this.newURIScheme(uri);
        return scheme.newURI(uri);
    }

    public URI newURI(URL url) throws URIException {
        URIScheme scheme = this.newURIScheme(url.toString());
        return scheme.newURI(url);
    }

    public URIScheme newURIScheme(String schemeOrURI) throws URIException {
        URIScheme newScheme = null;
        if (schemeOrURI == null) {
            throw new URIException(new SimpleStatus("SimpleURIFactory", this.msg_.getMessage("MSG_NULL_ARG_SPECIFIED", new Object[]{"newURIScheme"}), 4));
        }
        int colon = schemeOrURI.indexOf(58);
        int slash = schemeOrURI.indexOf(47);
        if (colon != -1 && slash == -1 || colon != -1 && colon < slash) {
            String protocol = schemeOrURI.substring(0, colon);
            newScheme = (URIScheme)this.schemes_.get(protocol);
            if (newScheme == null) {
                throw new URIException(new SimpleStatus("SimpleURIFactory", this.msg_.getMessage("MSG_SCHEME_NOT_FOUND", new Object[]{schemeOrURI}), 4));
            }
        } else {
            if (schemeOrURI.startsWith("/")) {
                throw new URIException(new SimpleStatus("SimpleURIFactory", this.msg_.getMessage("MSG_ABSOLUTE_PATH_WITHOUT_SCHEME", new Object[]{schemeOrURI}), 4));
            }
            newScheme = new RelativeScheme();
        }
        return newScheme;
    }

    public void registerScheme(String protocol, URIScheme scheme) {
        this.schemes_.put(protocol, scheme);
    }
}

