/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.validation.tests.internal;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IProject;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalog;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogElement;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogEntry;
import org.eclipse.wst.xml.core.internal.catalog.provisional.INextCatalog;
import org.eclipse.wst.xsd.validation.tests.internal.BaseTestCase;

public class BugFixesTest
extends BaseTestCase {
    private String BUGFIXES_DIR = "BugFixes/";
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.xsd.validation.tests.internal.BugFixesTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    protected void setUp() {
        super.setUp();
    }

    public void testEmpty() {
        String testname = "Empty";
        String testfile = String.valueOf(this.FILE_PROTOCOL) + this.PLUGIN_ABSOLUTE_PATH + this.SAMPLES_DIR + this.BUGFIXES_DIR + "EmptyFile/" + testname + ".xsd";
        String loglocation = String.valueOf(this.PLUGIN_ABSOLUTE_PATH) + this.GENERATED_RESULTS_DIR + this.BUGFIXES_DIR + "EmptyFile/" + testname + ".xsd-log";
        String idealloglocation = String.valueOf(this.PLUGIN_ABSOLUTE_PATH) + this.IDEAL_RESULTS_DIR + this.BUGFIXES_DIR + "EmptyFile/" + testname + ".xsd-log";
        this.runTest(testfile, loglocation, idealloglocation);
    }

    public void testInvalidSchemaInXMLCatalog() {
        String testname = "InvalidSchemaInXMLCatalog";
        String testfile = String.valueOf(this.PLUGIN_ABSOLUTE_PATH) + this.SAMPLES_DIR + this.BUGFIXES_DIR + "InvalidSchemaInXMLCatalog/" + testname + ".xsd";
        String loglocation = String.valueOf(this.PLUGIN_ABSOLUTE_PATH) + this.GENERATED_RESULTS_DIR + this.BUGFIXES_DIR + "InvalidSchemaInXMLCatalog/" + testname + ".xsd-log";
        String idealloglocation = String.valueOf(this.PLUGIN_ABSOLUTE_PATH) + this.IDEAL_RESULTS_DIR + this.BUGFIXES_DIR + "InvalidSchemaInXMLCatalog/" + testname + ".xsd-log";
        IProject project = this.createSimpleProject("Project", new String[]{testfile});
        project.getFile(String.valueOf(testname) + ".xsd");
        ICatalog catalog = XMLCorePlugin.getDefault().getDefaultXMLCatalog();
        INextCatalog[] nextCatalogs = catalog.getNextCatalogs();
        int i = 0;
        while (i < nextCatalogs.length) {
            ICatalog userCatalog;
            INextCatalog nextCatalog = nextCatalogs[i];
            if ("user_catalog".equals(nextCatalog.getId()) && (userCatalog = nextCatalog.getReferencedCatalog()) != null) {
                ICatalogEntry catalogEntry = (ICatalogEntry)userCatalog.createCatalogElement(2);
                catalogEntry.setKey("testKey");
                catalogEntry.setURI("http://testuri");
                userCatalog.addCatalogElement((ICatalogElement)catalogEntry);
                this.runTest("platform:/resource/Project/InvalidSchemaInXMLCatalog.xsd", loglocation, idealloglocation);
                catalog.removeCatalogElement((ICatalogElement)catalogEntry);
            }
            ++i;
        }
    }

    public void testMissingClosingSchemaTag() {
        String testname = "MissingClosingSchemaTag";
        String testfile = String.valueOf(this.FILE_PROTOCOL) + this.PLUGIN_ABSOLUTE_PATH + this.SAMPLES_DIR + this.BUGFIXES_DIR + "MissingClosingSchemaTag/" + testname + ".xsd";
        String loglocation = String.valueOf(this.PLUGIN_ABSOLUTE_PATH) + this.GENERATED_RESULTS_DIR + this.BUGFIXES_DIR + "MissingClosingSchemaTag/" + testname + ".xsd-log";
        String idealloglocation = String.valueOf(this.PLUGIN_ABSOLUTE_PATH) + this.IDEAL_RESULTS_DIR + this.BUGFIXES_DIR + "MissingClosingSchemaTag/" + testname + ".xsd-log";
        this.runTest(testfile, loglocation, idealloglocation);
    }

    public void testImportXSDWithXSDImportInDiffDir() {
        String testname = "ImportXSDWithXSDImportInDiffDir";
        String testfile = String.valueOf(this.FILE_PROTOCOL) + this.PLUGIN_ABSOLUTE_PATH + this.SAMPLES_DIR + this.BUGFIXES_DIR + "ImportXSDWithXSDImportInDiffDir/" + testname + ".xsd";
        String loglocation = String.valueOf(this.PLUGIN_ABSOLUTE_PATH) + this.GENERATED_RESULTS_DIR + this.BUGFIXES_DIR + "ImportXSDWithXSDImportInDiffDir/" + testname + ".xsd-log";
        String idealloglocation = String.valueOf(this.PLUGIN_ABSOLUTE_PATH) + this.IDEAL_RESULTS_DIR + this.BUGFIXES_DIR + "ImportXSDWithXSDImportInDiffDir/" + testname + ".xsd-log";
        this.runTest(testfile, loglocation, idealloglocation);
    }

    public void testImportInvalidLocation() {
        String testname = "ImportInvalidLocation";
        String testfile = String.valueOf(this.FILE_PROTOCOL) + this.PLUGIN_ABSOLUTE_PATH + this.SAMPLES_DIR + this.BUGFIXES_DIR + "ImportInvalidLocation/" + testname + ".xsd";
        String loglocation = String.valueOf(this.PLUGIN_ABSOLUTE_PATH) + this.GENERATED_RESULTS_DIR + this.BUGFIXES_DIR + "ImportInvalidLocation/" + testname + ".xsd-log";
        String idealloglocation = String.valueOf(this.PLUGIN_ABSOLUTE_PATH) + this.IDEAL_RESULTS_DIR + this.BUGFIXES_DIR + "ImportInvalidLocation/" + testname + ".xsd-log";
        this.runTest(testfile, loglocation, idealloglocation);
    }

    public void testTwoOpenBrackets() {
        String testname = "TwoOpenBrackets";
        String testfile = String.valueOf(this.FILE_PROTOCOL) + this.PLUGIN_ABSOLUTE_PATH + this.SAMPLES_DIR + this.BUGFIXES_DIR + "TwoOpenBrackets/" + testname + ".xsd";
        String loglocation = String.valueOf(this.PLUGIN_ABSOLUTE_PATH) + this.GENERATED_RESULTS_DIR + this.BUGFIXES_DIR + "TwoOpenBrackets/" + testname + ".xsd-log";
        String idealloglocation = String.valueOf(this.PLUGIN_ABSOLUTE_PATH) + this.IDEAL_RESULTS_DIR + this.BUGFIXES_DIR + "TwoOpenBrackets/" + testname + ".xsd-log";
        this.runTest(testfile, loglocation, idealloglocation);
    }
}

