/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.tests.collector;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import junit.framework.TestSuite;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wst.common.tests.collector.SuiteHelper;
import org.eclipse.wst.common.tests.collector.SuiteTestRunner;

public class TestCollectorInnerPanes
extends Composite {
    private Table testClassTable;
    private Table testMethodTable;
    private Button launchTestButton;
    private SuiteHelper pluginTestLoader;
    private HashSet partialSetHash = new HashSet();
    private Hashtable shortToFullHashtable = new Hashtable();
    private Hashtable fullToShortHashtable = new Hashtable();

    public TestCollectorInnerPanes(Composite parent, int style, SuiteHelper loader) {
        super(parent, style);
        this.pluginTestLoader = loader;
        this.createPartControl();
    }

    public void createPartControl() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.setLayout((Layout)gridLayout);
        GridData gridData = null;
        Group tableGroup = new Group((Composite)this, 0);
        GridLayout tableGroupLayout = new GridLayout();
        tableGroupLayout.makeColumnsEqualWidth = true;
        tableGroupLayout.numColumns = 1;
        tableGroupLayout.marginWidth = 0;
        tableGroupLayout.marginHeight = 0;
        tableGroup.setLayout((Layout)tableGroupLayout);
        tableGroup.setLayoutData((Object)new GridData(1808));
        SashForm splitView = new SashForm((Composite)tableGroup, 256);
        splitView.setBackground(this.getDisplay().getSystemColor(16));
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        splitView.setLayoutData((Object)gridData);
        Composite leftComposite = new Composite((Composite)splitView, 0);
        GridLayout leftLayout = new GridLayout();
        leftLayout.numColumns = 1;
        leftComposite.setLayout((Layout)leftLayout);
        Label label2 = new Label(leftComposite, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 2;
        label2.setLayoutData((Object)gridData);
        label2.setText("Test Suites");
        Composite rightComposite = new Composite((Composite)splitView, 0);
        GridLayout rightLayout = new GridLayout();
        rightLayout.numColumns = 1;
        rightComposite.setLayout((Layout)rightLayout);
        Label label3 = new Label(rightComposite, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 2;
        label3.setLayoutData((Object)gridData);
        label3.setText("Tests");
        this.testClassTable = new Table(leftComposite, 32);
        this.testClassTable.setBackground(this.getBackground());
        gridData = new GridData(1808);
        this.testClassTable.setLayoutData((Object)gridData);
        String[] allTests = this.pluginTestLoader.getAllTests();
        int i = 0;
        while (i < allTests.length) {
            TableItem tableItem = new TableItem(this.testClassTable, 0);
            tableItem.setText(allTests[i]);
            ++i;
        }
        this.testClassTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TableItem item = (TableItem)e.item;
                String testName = item.getText();
                TestCollectorInnerPanes.this.updateMethodTable(testName, TestCollectorInnerPanes.this.pluginTestLoader.getTestMethods(testName));
                TestCollectorInnerPanes.this.testClassTable.setSelection(new TableItem[]{item});
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label label = new Label(leftComposite, 258);
        label.setLayoutData((Object)new GridData(768));
        final Button selectAllCheckbox = new Button(leftComposite, 32);
        selectAllCheckbox.setLayoutData((Object)new GridData(768));
        selectAllCheckbox.setText("Select All");
        selectAllCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean checked = selectAllCheckbox.getSelection();
                TableItem[] items = TestCollectorInnerPanes.this.testClassTable.getItems();
                int i = 0;
                while (i < items.length) {
                    items[i].setChecked(checked);
                    ++i;
                }
            }
        });
        this.testMethodTable = new Table(rightComposite, 32);
        this.testMethodTable.setBackground(this.getBackground());
        gridData = new GridData(1808);
        this.testMethodTable.setLayoutData((Object)gridData);
        this.launchTestButton = new Button((Composite)this, 8);
        gridData = new GridData(768);
        gridData.horizontalAlignment = 2;
        gridData.horizontalSpan = 2;
        this.launchTestButton.setLayoutData((Object)gridData);
        this.launchTestButton.setText("Run Tests");
        this.launchTestButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SuiteTestRunner runner = new SuiteTestRunner(TestCollectorInnerPanes.this.buildSuite());
                runner.launch();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void storeMethodsTable() {
        TableItem[] items = this.testMethodTable.getItems();
        int i = 0;
        while (items != null && i < items.length) {
            String partialTestName = (String)this.shortToFullHashtable.get(items[i].getText());
            if (items[i].getChecked() && !this.partialSetHash.contains(partialTestName)) {
                this.partialSetHash.add(partialTestName);
            } else if (!items[i].getChecked() && this.partialSetHash.contains(partialTestName)) {
                this.partialSetHash.remove(partialTestName);
            }
            ++i;
        }
    }

    private void updateMethodTable(String testName, String[] methodArray) {
        this.storeMethodsTable();
        this.testMethodTable.removeAll();
        this.shortToFullHashtable.clear();
        this.fullToShortHashtable.clear();
        int i = 0;
        while (methodArray != null && i < methodArray.length) {
            String partialTestName = String.valueOf(testName) + "." + methodArray[i];
            int endIndex = methodArray[i].indexOf(40);
            String methodName = endIndex > 0 ? methodArray[i].substring(0, endIndex) : methodArray[i];
            this.shortToFullHashtable.put(methodName, partialTestName);
            this.fullToShortHashtable.put(partialTestName, methodName);
            TableItem tableItem = new TableItem(this.testMethodTable, 0);
            tableItem.setText(methodName);
            tableItem.setChecked(this.partialSetHash.contains(partialTestName));
            ++i;
        }
    }

    private TestSuite buildSuite() {
        ArrayList<String> completeTests = new ArrayList<String>();
        TableItem[] items = this.testClassTable.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getChecked()) {
                completeTests.add(items[i].getText());
            }
            ++i;
        }
        String[] completeArray = new String[completeTests.size()];
        int i2 = 0;
        while (i2 < completeArray.length) {
            completeArray[i2] = (String)completeTests.get(i2);
            ++i2;
        }
        ArrayList partialTests = new ArrayList();
        this.storeMethodsTable();
        Iterator iterator = this.partialSetHash.iterator();
        while (iterator.hasNext()) {
            partialTests.add(iterator.next());
        }
        String[] partialArray = new String[partialTests.size()];
        int i3 = 0;
        while (i3 < partialArray.length) {
            partialArray[i3] = (String)partialTests.get(i3);
            ++i3;
        }
        return this.pluginTestLoader.buildSuite(completeArray, partialArray);
    }
}

