/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.command.internal.env.eclipse;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.command.internal.env.common.FileResourceUtils;
import org.eclipse.wst.command.internal.env.eclipse.BaseEclipseEnvironment;
import org.eclipse.wst.command.internal.env.eclipse.EclipseScheme;
import org.eclipse.wst.command.internal.provisional.env.core.common.MessageUtils;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;
import org.eclipse.wst.command.internal.provisional.env.core.uri.RelativeURI;
import org.eclipse.wst.command.internal.provisional.env.core.uri.URI;
import org.eclipse.wst.command.internal.provisional.env.core.uri.URIException;
import org.eclipse.wst.command.internal.provisional.env.core.uri.URIFilter;
import org.eclipse.wst.command.internal.provisional.env.core.uri.URIScheme;

public class EclipseURI
extends RelativeURI {
    private BaseEclipseEnvironment environment_;
    private EclipseScheme scheme_;
    private MessageUtils msg_;
    private File file_;

    public EclipseURI(String uri, BaseEclipseEnvironment environment) {
        super(uri);
        this.environment_ = environment;
        this.scheme_ = new EclipseScheme(environment);
        this.msg_ = new MessageUtils("org.eclipse.wst.command.internal.env.common.environment", (Object)this);
        this.file_ = this.getFile();
    }

    public void erase() throws URIException {
        try {
            IResource file = this.getResource();
            if (file != null && file.exists()) {
                if (file instanceof IFile) {
                    FileResourceUtils.deleteFile(this.environment_.getResourceContext(), (IFile)file, this.environment_.getProgressMonitor(), this.environment_.getStatusHandler());
                } else if (file instanceof IFolder) {
                    FileResourceUtils.deleteFolder(this.environment_.getResourceContext(), (IFolder)file, this.environment_.getProgressMonitor(), this.environment_.getStatusHandler());
                }
            }
        }
        catch (Exception exc) {
            throw new URIException((Status)new SimpleStatus("EclipseURI", exc.getMessage(), 4, (Throwable)exc), (URI)this);
        }
    }

    public InputStream getInputStream() throws URIException {
        try {
            IFile file = (IFile)this.getResource();
            if (file != null) {
                return file.getContents();
            }
        }
        catch (Throwable exc) {
            throw new URIException((Status)new SimpleStatus("EclipseURI", exc.getMessage(), 4, exc), (URI)this);
        }
        return null;
    }

    public OutputStream getOutputStream() throws URIException {
        URI parent = this.parent();
        if (!parent.isPresent()) {
            this.parent().touchFolder();
        }
        return this.getOutStream();
    }

    public URIScheme getURIScheme() {
        return this.scheme_;
    }

    public boolean isLeaf() {
        boolean result = false;
        try {
            IResource resource = this.getResource();
            if (resource != null && resource.exists() && resource.getType() == 1) {
                result = true;
            }
        }
        catch (URIException uRIException) {
            result = false;
        }
        return result;
    }

    public boolean isPresent() {
        boolean result = false;
        try {
            IResource resource = this.getResource();
            if (resource != null && resource.exists()) {
                result = true;
            }
        }
        catch (URIException uRIException) {
            result = false;
        }
        return result;
    }

    public boolean isReadable() {
        boolean result = false;
        try {
            IResource resource = this.getResource();
            if (resource != null && resource.isAccessible()) {
                result = true;
            }
        }
        catch (URIException uRIException) {
            result = false;
        }
        return result;
    }

    public boolean isRelative() {
        return false;
    }

    public boolean isWritable() {
        boolean result = false;
        try {
            IResource resource = this.getResource();
            if (resource != null && resource.isAccessible() && !resource.getResourceAttributes().isReadOnly()) {
                result = true;
            }
        }
        catch (URIException uRIException) {
            result = false;
        }
        return result;
    }

    public URI[] list() throws URIException {
        IResource resource = this.getResource();
        URI[] uriChildren = new URI[]{};
        if (resource.getType() == 2) {
            IFolder folder = (IFolder)resource;
            try {
                IResource[] children = folder.members();
                uriChildren = new URI[children.length];
                int index = 0;
                while (index < children.length) {
                    IPath path = children[index].getFullPath();
                    uriChildren[index] = new EclipseURI(this.scheme_.getURLFromPath(path), this.environment_);
                    ++index;
                }
            }
            catch (CoreException coreException) {}
        }
        return uriChildren;
    }

    public URI[] list(URIFilter uriFilter) throws URIException {
        IResource resource = this.getResource();
        URI[] result = new URI[]{};
        if (resource.getType() == 2) {
            IFolder folder = (IFolder)resource;
            try {
                IResource[] children = folder.members();
                Vector<EclipseURI> uriChildren = new Vector<EclipseURI>();
                int index = 0;
                while (index < children.length) {
                    IPath path = children[index].getFullPath();
                    EclipseURI uri = new EclipseURI(this.scheme_.getURLFromPath(path), this.environment_);
                    if (uriFilter.accepts((URI)uri)) {
                        uriChildren.add(uri);
                    }
                    ++index;
                }
                result = uriChildren.toArray(new URI[0]);
            }
            catch (CoreException coreException) {}
        }
        return result;
    }

    public void rename(URI newURI) {
    }

    public void touchFolder() throws URIException {
        IResource resource = this.getResource();
        if (resource != null) {
            if (resource.getType() == 2) {
                IFolder folder = (IFolder)resource;
                try {
                    if (folder.members().length > 0) {
                        throw new URIException((Status)new SimpleStatus("EclipseURI", this.msg_.getMessage("MSG_ERROR_FOLDER_HAS_CHILDREN", new Object[]{folder.toString()}), 4), (URI)this);
                    }
                }
                catch (CoreException exc) {
                    throw new URIException((Status)new SimpleStatus("EclipseURI", exc.getMessage(), 4, (Throwable)exc), (URI)this);
                }
            }
        } else {
            IPath newPath = new Path(this.scheme_.getPathFromPlatformURI(this.uri_)).makeAbsolute();
            try {
                FileResourceUtils.makeFolderPath(this.environment_.getResourceContext(), newPath, this.environment_.getProgressMonitor(), this.environment_.getStatusHandler());
            }
            catch (CoreException exc) {
                throw new URIException((Status)new SimpleStatus("EclipseURI", exc.getMessage(), 4, (Throwable)exc), (URI)this);
            }
        }
    }

    public void touchLeaf() throws URIException {
        IResource resource = this.getResource();
        if (resource == null) {
            URI parent = this.parent();
            if (!parent.isPresent()) {
                this.parent().touchFolder();
            }
            try {
                this.getOutStream().close();
            }
            catch (IOException exc) {
                throw new URIException((Status)new SimpleStatus("EclipseURI", exc.getMessage(), 4, (Throwable)exc), (URI)this);
            }
        }
    }

    private IResource getResource() throws URIException {
        Path path = new Path(this.scheme_.getPathFromPlatformURI(this.uri_));
        String absolutePathname = path.makeAbsolute().toString();
        return FileResourceUtils.findResource(absolutePathname);
    }

    private OutputStream getOutStream() throws URIException {
        IPath file = new Path(this.scheme_.getPathFromPlatformURI(this.uri_)).makeAbsolute();
        OutputStream stream = null;
        stream = FileResourceUtils.newFileOutputStream(this.environment_.getResourceContext(), file, this.environment_.getProgressMonitor(), this.environment_.getStatusHandler());
        return stream;
    }

    public File asFile() {
        return this.file_;
    }

    public boolean isAvailableAsFile() {
        return this.file_ != null;
    }

    private File getFile() {
        String platformRes = "platform:/resource";
        File result = null;
        if (this.uri_.startsWith(platformRes)) {
            result = new File(ResourcesPlugin.getWorkspace().getRoot().getLocation().removeTrailingSeparator().append(this.uri_.substring(platformRes.length(), this.uri_.length())).toString());
        }
        return result;
    }
}

