/*******************************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * IBM Corporation - initial API and implementation
 *******************************************************************************/
/*
 * Created on Dec 2, 2003
 * 
 * To change the template for this generated file go to Window>Preferences>Java>Code Generation>Code and Comments
 */
package org.eclipse.wst.common.navigator.internal.groups;


import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.wst.common.navigator.internal.plugin.WorkbenchNavigatorPlugin;
import org.eclipse.wst.common.navigator.internal.views.extensions.RegistryReader;

/**
 * @author jlanuti
 * 
 * To change the template for this generated type comment go to Window>Preferences>Java>Code
 * Generation>Code and Comments
 */
public class NavigatorGroupExtensionReader extends RegistryReader {
	private static NavigatorGroupExtensionReader INSTANCE = new NavigatorGroupExtensionReader();
	public static final String EXTENSION_NAME = "NavigatorGroup"; //$NON-NLS-1$
	public static final String EXTENSION_ID = "navigatorGroup"; //$NON-NLS-1$
	public static final String GROUP_DISPLAY_ATTR = "displayName"; //$NON-NLS-1$
	public static final String GROUP_NATURE_ID_ATTR = "natureID"; //$NON-NLS-1$
	public static final String GROUP_ICON_ATTR = "icon"; //$NON-NLS-1$
	public static final String GROUP_EXCLUDE = "exclude"; //$NON-NLS-1$
	public static final String SORT_ORDER = "sortOrder"; //$NON-NLS-1$
	public static final String NON_GROUPED_ID = "nongrouped"; //$NON-NLS-1$
	private List navigatorGroupsList = new ArrayList();
	private List nonExcludedGroupsList = new ArrayList();
	private List knownGroupNatureIds = null;
	private static boolean initialized;

	/**
	 * default constructor
	 */
	public NavigatorGroupExtensionReader() {
		super(WorkbenchNavigatorPlugin.PLUGIN_ID, EXTENSION_NAME);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.wst.common.frameworks.internal.RegistryReader#readElement(org.eclipse.core.runtime.IConfigurationElement)
	 */
	public boolean readElement(IConfigurationElement element) {
		if (!element.getName().equals(EXTENSION_ID))
			return false;
		String displayName = element.getAttribute(GROUP_DISPLAY_ATTR);
		String natureID = element.getAttribute(GROUP_NATURE_ID_ATTR);
		String icon = element.getAttribute(GROUP_ICON_ATTR);
		String exclude = element.getAttribute(GROUP_EXCLUDE);
		String sortOrderString = element.getAttribute(SORT_ORDER);
		final String localID = element.getDeclaringExtension().getSimpleIdentifier();
		final String pluginID = element.getDeclaringExtension().getDeclaringPluginDescriptor().getUniqueIdentifier();
		int sortOrder = (sortOrderString != null) ? Integer.parseInt(sortOrderString.trim()) : Integer.MAX_VALUE;
		NavigatorGroup navGroup = new NavigatorGroup(pluginID, displayName, natureID, icon, exclude, sortOrder, new IPluginContribution() {
			public String getLocalId() {
				return localID;
			}

			public String getPluginId() {
				return pluginID;
			}
		});
		navigatorGroupsList.add(navGroup);
		if (exclude == null || !exclude.equals("true")) //$NON-NLS-1$
			nonExcludedGroupsList.add(navGroup);
		return true;
	}

	public static NavigatorGroupExtensionReader getInstance() {
		if (isInitialized())
			return INSTANCE;
		synchronized (INSTANCE) {
			if (!isInitialized()) {
				INSTANCE.readRegistry();
				initialized = true;
			}
		}
		return INSTANCE;
	}

	public NavigatorGroup getDefaultNavigatorGroup() {
		NavigatorGroup group = null;
		List navGroups = getNavigatorGroupsList();
		for (int i = 0; i < navGroups.size(); i++) {
			group = (NavigatorGroup) navGroups.get(i);
			if (group.getNatureID() != null && group.getNatureID().equals(NON_GROUPED_ID))
				return group;
		}
		return null;
	}

	/**
	 * @return navigatorGroupsList
	 */
	public List getNavigatorGroupsList() {
		return navigatorGroupsList;
	}

	public List getKnownGroupNatureIDs() {
		if (knownGroupNatureIds == null) {
			knownGroupNatureIds = new ArrayList();
			for (int i = 0; i < navigatorGroupsList.size(); i++) {
				NavigatorGroup group = (NavigatorGroup) navigatorGroupsList.get(i);
				if (group.getNatureID() != null && !knownGroupNatureIds.contains(group.getNatureID()))
					knownGroupNatureIds.add(group.getNatureID());
			}
			if (knownGroupNatureIds.size() == 0)
				knownGroupNatureIds = Collections.EMPTY_LIST;
		}
		return knownGroupNatureIds;
	}

	public List getNonExcludedGroupsList() {
		return nonExcludedGroupsList;
	}

	public NavigatorGroup getNavigatorGroup(String natureID) {
		for (int i = 0; i < navigatorGroupsList.size(); i++) {
			NavigatorGroup navGroup = (NavigatorGroup) navigatorGroupsList.get(i);
			if (navGroup != null && navGroup.getNatureID() != null && navGroup.getNatureID().equals(natureID))
				return navGroup;
		}
		return null;
	}

	/**
	 * @return Returns the initialized.
	 */
	protected static boolean isInitialized() {
		return initialized;
	}
}