/*******************************************************************************
 * Copyright (c) 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.ws.internal.common;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.command.internal.env.ui.eclipse.EclipseEnvironment;
import org.eclipse.wst.command.internal.env.ui.eclipse.EclipseProgressMonitor;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.ProgressMonitor;
import org.eclipse.wst.command.internal.provisional.env.core.context.ResourceContext;
import org.eclipse.wst.command.internal.provisional.env.core.context.TransientResourceContext;

public final class EnvironmentUtils
{
  /**
   * @param env
   * @return IProgressMonitor
   */
  public static IProgressMonitor getIProgressMonitor(Environment env)
  {
  	 ProgressMonitor monitor = env.getProgressMonitor();
     	 IProgressMonitor eclipseMonitor = null;
     	 if (monitor instanceof EclipseProgressMonitor)
     	 {
     	 	eclipseMonitor = ((EclipseProgressMonitor)monitor).getMonitor();
     	 }
     	 return eclipseMonitor;
  }
     
  /**
   * 
   * @param env This should be an EclipseEnvironment.
   * @return Returns a ResourceContext.
   */ 
  public static ResourceContext getResourceContext( Environment env )
  {
    ResourceContext context = null;
    
    if( env instanceof EclipseEnvironment )
    {
      context = ((EclipseEnvironment)env).getResourceContext();
    }
    else
    {
      context = new TransientResourceContext();
    }
    
    return context;
  }
  
  
}
