/*******************************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * IBM Corporation - initial API and implementation
 *******************************************************************************/
/*
 * Created on Jan 15, 2004
 *
 * To change the template for this generated file go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
package org.eclipse.wst.common.navigator.internal.views;

import java.util.Comparator;

import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.common.navigator.internal.provisional.views.INavigatorContentExtension;
import org.eclipse.wst.common.navigator.internal.provisional.views.NavigatorContentService;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorContentDescriptor;

/**
 * @author Administrator
 * 
 * To change the template for this generated type comment go to Window - Preferences - Java - Code
 * Generation - Code and Comments
 */
public abstract class DefaultNavigatorContentExtension implements INavigatorContentExtension {

	private NavigatorContentService contentService;
	private NavigatorContentDescriptor contentDescriptor;

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.wst.common.navigator.internal.views.navigator.INavigatorContentExtension#init(java.lang.String,
	 *      org.eclipse.wst.common.navigator.internal.views.navigator.INavigatorExtensionSite)
	 */
	public final void init(NavigatorContentDescriptor aContentDescriptor, NavigatorContentService aContentService) {

		contentDescriptor = aContentDescriptor;
		contentService = aContentService;
		doInit();
	}

	public void doInit() {
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.wst.common.navigator.internal.views.navigator.INavigatorContentExtension#dispose()
	 */
	public void dispose() {
		getContentProvider().dispose();
		getLabelProvider().dispose();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.wst.common.navigator.internal.views.navigator.INavigatorContentExtension#getComparator()
	 */
	public Comparator getComparator() {
		return null;
	}


	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.core.runtime.IAdaptable#getAdapter(java.lang.Class)
	 */
	public Object getAdapter(Class adapter) {
		return Platform.getAdapterManager().getAdapter(this, adapter);
	}

	protected final NavigatorContentService getContentService() {
		return contentService;
	}

	protected final NavigatorContentDescriptor getContentDescriptor() {
		return contentDescriptor;
	}
}