/*******************************************************************************
 * Copyright (c) 2000, 2005 IBM Corporation and others. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 which is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: IBM Corporation - initial implementation
 ******************************************************************************/
package org.eclipse.wst.rdb.server.extensions.internal.templates;

import java.io.File;
import java.io.IOException;
import java.net.URL;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.rdb.server.extensions.internal.ServerExtensionsPlugin;
import org.eclipse.wst.rdb.server.extensions.internal.util.DatabaseTypes;
import org.eclipse.wst.rdb.server.extensions.internal.util.Utility;

public class TemplateRegistry {

   private static final String TEMPLATE_DIR_NAME = "templates"; //$NON-NLS-1$	
   private static final String DB2_PATH = "DB2"; //$NON-NLS-1$	
   private static final String SQL99_PATH = "SQL99"; //$NON-NLS-1$	
   private static final String ORACLE_PATH = "ORACLE"; //$NON-NLS-1$	
   private static final String SQLSERVER_PATH = "SQLSERVER"; //$NON-NLS-1$	
   private static final String SYBASE_PATH = "SYBASE"; //$NON-NLS-1$
   private static final String INFORMIX_PATH = "INFORMIX"; //$NON-NLS-1$
   private static final String DERBY_PATH = "DERBY"; //$NON-NLS-1$

   private String templateDir = null;
   private static TemplateRegistry registry = null;
   private int databaseType;
   private String sep = System.getProperty("file.separator");//$NON-NLS-1$    

   public static TemplateRegistry getTemplateRegistry() {
      if (registry == null)
         registry = new TemplateRegistry();
      return registry;
   }

   protected TemplateRegistry() {
   }

   public String getDefaultDDL(String templateFileName, int databaseType) {
      // TODO:if no extension exists to get default template, use the standard
      // default one
      //  put code here to check for different template provided by extension pt
      //  if no_user_provided_default_template then
      //         do code below
      //  else
      //         get user_default_template

      this.databaseType = databaseType;
      String templateURI;
      URL templateUrl;
      String bundleURL = getTemplatesDir() + templateFileName;
      try {
         templateUrl = ServerExtensionsPlugin.getDefault().getBundle().getEntry(bundleURL);
         templateURI = new Path(Platform.asLocalURL(templateUrl).getPath()).toString();
      }
      catch (IOException e) {
         ServerExtensionsPlugin.getDefault().writeLog(IStatus.ERROR, 0,
                  "Error getting template URL: " + bundleURL, e); //$NON-NLS-1$
         return null;
      }
      catch (NullPointerException e) {
         ServerExtensionsPlugin.getDefault().writeLog(IStatus.ERROR, 0,
                  "Error getting template URL: " + bundleURL, e); //$NON-NLS-1$
         return null;
      }
      return getDDL(templateURI);
   }

   public String getTemplatesDir() {
      //calculate this every time as user could swap connections
   	  //in which case the template needs to be different
         templateDir = sep + TEMPLATE_DIR_NAME + sep + getVendorPath(databaseType) + sep;
      
      return templateDir;
   }

   public String getVendorPath(int databaseType) {
      String path = null;
      switch (databaseType) {
         case DatabaseTypes.ORACLE :
            path = ORACLE_PATH;
            break;
         case DatabaseTypes.SQL_SERVER :
            path = SQLSERVER_PATH;
            break;
         case DatabaseTypes.DB2 :
            path = DB2_PATH;
            break;
         case DatabaseTypes.SYBASE :
            path = SYBASE_PATH;
            break;
         case DatabaseTypes.INFORMIX :
            path = INFORMIX_PATH;
            break;
         case DatabaseTypes.DERBY :
            path = DERBY_PATH;
            break;
         default :
            path = SQL99_PATH;
      }
      if (path == null || path.length() == 0)
         path = SQL99_PATH;

      return path;
   }

   public String getDDL(String dir) {
      String ddl = ""; //$NON-NLS-1$
      try {
         File templateFile = new File(dir);
         if (templateFile != null && templateFile.exists()) {
            ddl = Utility.getSourceFromFile(templateFile);
         }
      }
      catch (Exception e) {
         //If we cannot read the template file, return an empty string  
         ddl = ""; //$NON-NLS-1$
      }
      return ddl;
   }

}