/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.wst.rdb.data.internal.ui.load;

import org.eclipse.jface.dialogs.*;
import org.eclipse.swt.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.wst.rdb.data.internal.ui.*;


public class LoadDataWizardPage extends FileFormatWizardPage
{
    
    protected Button replaceCheckbox;
    
    protected static final String SETTING_REPLACE = "Replace data"; //$NON-NLS-1$
    
    public LoadDataWizardPage(String pageName)
    {
        super(pageName, false);
    }
    
    protected void createControl1(Composite parent)
    {
        super.createControl1(parent);
        
        Composite composite = (Composite)getControl();
        replaceCheckbox = new Button(composite, SWT.CHECK);
        replaceCheckbox.setText(Messages.getString("LoadDataWizardPage.ReplaceData")); //$NON-NLS-1$
        replaceCheckbox.setSelection(true);
    }
    
    public boolean getReplace()
    {
        return replaceCheckbox.getSelection();
    }
    
    protected void loadSettings()
    {
        super.loadSettings();
        
        IDialogSettings settings = DataUIPlugin.getDefault().getDialogSettings().getSection(SETTINGS_SECTION_NAME);
        
        if (settings!=null) {
            if (settings.get(SETTING_REPLACE)!=null)
                replaceCheckbox.setSelection( settings.getBoolean(SETTING_REPLACE) );
        }
    }
    
    public void saveSettings()
    {
        super.saveSettings();
        
        IDialogSettings settings = DataUIPlugin.getDefault().getDialogSettings().getSection(SETTINGS_SECTION_NAME);
        
        settings.put(SETTING_REPLACE, replaceCheckbox.getSelection());
    }
    
}
