/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.wst.rdb.data.internal.core.common;

import java.math.*;
import java.sql.*;


public class DataDeserializer {

    public static Object deserialize(String val, int type)
    {
        if (val==null) {
            return null;
        }
       
        if (type==Types.TINYINT)
            return new Byte(val);
        else if (type==Types.SMALLINT)
            return new Short(val);
        else if (type==Types.INTEGER)
            return new Integer(val);
        else if (type==Types.BIGINT)
            return new Long(val);
        else if (type==Types.REAL)
            return new Float(val);
        else if (type==Types.FLOAT)
            return new Double(val);
        else if (type==Types.DOUBLE)
            return new Double(val);
        else if (type==Types.DECIMAL)
            return new BigDecimal(val);
        else if (type==Types.NUMERIC)
            return new BigDecimal(val);
        else if (type==Types.BIT)
            return new Boolean(val);
        else if (type==Types.CHAR)
            return val;
        else if (type==Types.VARCHAR)
            return val;
        else if (type==Types.LONGVARCHAR)
            return val;
        else if (type==Types.BINARY)
            return deserializeBytes(val);
        else if (type==Types.VARBINARY)
            return deserializeBytes(val);
        else if (type==Types.LONGVARBINARY)
            return deserializeBytes(val);
        else if (type==Types.DATE)
            return java.sql.Date.valueOf(val);
        else if (type==Types.TIME)
            return Time.valueOf(val);
        else if (type==Types.TIMESTAMP)
            return Timestamp.valueOf(val);
        else if (type==Types.CLOB)
            return val;
        else if (type==Types.BLOB)
            return deserializeBytes(val);
        else if (type==Types.ARRAY || type==Types.REF || type==Types.STRUCT
                || type==Types.JAVA_OBJECT || type==Types.OTHER)
            return null;
        else
            return null;
    }
    
    protected static byte[] deserializeBytes(String s)
    {
        if (s.length()%2==1)
            throw new IllegalArgumentException("Invalid binary data"); //$NON-NLS-1$
        
        byte[] bytes = new byte[s.length()/2];
        for (int i=0; i<bytes.length; ++i)
            bytes[i] = (byte)Integer.parseInt(s.substring(2*i, 2*i+2), 16);
            
        return bytes;
    }
    
}
