/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.core.internal.ui.explorer.helpers;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.wst.rdb.core.internal.ui.services.IColumnHelperService;
import org.eclipse.wst.rdb.core.internal.ui.services.IDataToolsUIServiceManager;
import org.eclipse.wst.rdb.core.internal.ui.services.IForeignKeyHelperService;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.models.sql.constraints.ForeignKey;

/**
 * @author ljulien
 */
public class ForeignKeyHelper implements IForeignKeyHelperService
{
	private IColumnHelperService columnHelper = IDataToolsUIServiceManager.INSTANCE.getColumnHelperService();
	/**
	 * @see org.eclipse.wst.rdb.core.internal.ui.ui.services.IForeignKeyHelper#isIdentifyingConstraint(org.eclipse.sql.constraints.ForeignKey)
	 */
	public boolean isIdentifyingConstraint(ForeignKey constraint)
	{
        EAnnotation eAnnotation = constraint.getEAnnotation(RDBCorePlugin.FK_MODELING_RELATIONSHIP);
        if (eAnnotation != null)
        {
            return new Boolean ((String)eAnnotation.getDetails().get(RDBCorePlugin.FK_IS_IDENTIFYING_RELATIONSHIP)).booleanValue();
        }
        return true;
	}
	/**
	 * @see org.eclipse.wst.rdb.core.internal.ui.ui.services.IForeignKeyHelper#isNonIdentifyingConstraint(org.eclipse.sql.constraints.ForeignKey)
	 */
	public boolean isNonIdentifyingConstraint(ForeignKey constraint)
	{
		return !isIdentifyingConstraint(constraint);
	}
}
