/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jem.util.logger.LogEntry;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.wst.common.frameworks.internal.ui.WTPUIPlugin;
import org.eclipse.wst.validation.internal.ConfigurationManager;
import org.eclipse.wst.validation.internal.ProjectConfiguration;
import org.eclipse.wst.validation.internal.ValidationRegistryReader;
import org.eclipse.wst.validation.internal.ValidationSelectionHandlerRegistryReader;
import org.eclipse.wst.validation.internal.operations.EnabledIncrementalValidatorsOperation;
import org.eclipse.wst.validation.internal.operations.EnabledValidatorsOperation;
import org.eclipse.wst.validation.internal.operations.ValidatorManager;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;
import org.eclipse.wst.validation.internal.ui.ProgressAndTextDialog;
import org.eclipse.wst.validation.internal.ui.ResourceHandler;
import org.eclipse.wst.validation.internal.ui.ValidateAction;
import org.eclipse.wst.validation.internal.ui.plugin.ValidationUIPlugin;

public class ValidationMenuAction
implements IViewActionDelegate {
    private ISelection _currentSelection = null;
    protected static final String SEP = "/";
    private Display _currentDisplay = Display.getCurrent();
    private IResourceVisitor _folderVisitor = null;
    private Map _selectedResources = new HashMap();

    private Display getDisplay() {
        return this._currentDisplay == null ? Display.getCurrent() : this._currentDisplay;
    }

    Shell getShell() {
        Shell[] shells;
        Shell shell;
        Display display = this.getDisplay();
        Shell shell2 = shell = display == null ? null : display.getActiveShell();
        if (shell == null && display != null && (shells = display.getShells()).length > 0) {
            shell = shells[0];
        }
        return shell;
    }

    private ISelection getCurrentSelection() {
        return this._currentSelection;
    }

    private Map loadSelected(ValidateAction action, boolean refresh) {
        ISelection selection;
        if (refresh) {
            this._selectedResources.clear();
        }
        if ((selection = this.getCurrentSelection()) == null || selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return null;
        }
        Object[] elements = ((IStructuredSelection)selection).toArray();
        int i = 0;
        while (i < elements.length) {
            Object element = elements[i];
            if (element != null) {
                this.addSelected(action, element);
            }
            ++i;
        }
        return this._selectedResources;
    }

    private void addSelected(ValidateAction action, Object selected) {
        if (selected instanceof IProject) {
            this.addSelected((IProject)selected);
        } else if (selected instanceof IFile) {
            this.addSelected((IResource)((IFile)selected));
        } else if (selected instanceof IFolder) {
            this.addVisitor((IFolder)selected);
        } else if (this.isValidType(this.getExtendedType(selected))) {
            this.addSelected(action, this.getExtendedType(selected));
        } else {
            IResource[] resources;
            boolean valid = false;
            if (action != null && (resources = action.getResource(selected)) != null) {
                valid = true;
                int i = 0;
                while (i < resources.length) {
                    this.addSelected(action, resources[i]);
                    ++i;
                }
            }
            if (!valid) {
                this._selectedResources.clear();
            }
        }
    }

    private Object getExtendedType(Object selected) {
        Object result = ValidationSelectionHandlerRegistryReader.getInstance().getExtendedType(selected);
        return result == null ? selected : result;
    }

    private boolean isValidType(Object object) {
        return object instanceof IProject || object instanceof IFile || object instanceof IFolder;
    }

    private void addSelected(IProject selected) {
        this._selectedResources.put(selected, null);
    }

    void addSelected(IResource selected) {
        IProject project = selected.getProject();
        boolean added = this._selectedResources.containsKey(project);
        List<IResource> changedRes = null;
        if (added) {
            changedRes = (List)this._selectedResources.get(project);
            if (changedRes == null) {
                return;
            }
        } else {
            changedRes = new ArrayList();
        }
        if (!changedRes.contains(selected)) {
            changedRes.add(selected);
            this._selectedResources.put(project, changedRes);
        }
    }

    private void addVisitor(IFolder selected) {
        try {
            selected.accept(this.getFolderVisitor());
        }
        catch (CoreException exc) {
            Logger logger = WTPUIPlugin.getLogger();
            if (logger.isLoggingLevel(Level.SEVERE)) {
                LogEntry entry = ValidationUIPlugin.getLogEntry();
                entry.setSourceIdentifier("ValidationMenuAction.addSelected(IFolder)");
                entry.setMessageTypeIdentifier("VBF_EXC_INTERNAL");
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
            }
            return;
        }
    }

    private IResourceVisitor getFolderVisitor() {
        if (this._folderVisitor == null) {
            this._folderVisitor = new IResourceVisitor(){

                public boolean visit(IResource res) {
                    if (res instanceof IFile) {
                        ValidationMenuAction.this.addSelected(res);
                    } else if (res instanceof IFolder) {
                        ValidationMenuAction.this.addSelected(res);
                    }
                    return true;
                }
            };
        }
        return this._folderVisitor;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IAction action) {
        Map projects;
        ValidateAction vaction = null;
        if (action instanceof ValidateAction) {
            vaction = (ValidateAction)action;
        }
        if ((projects = this.loadSelected(vaction, false)) == null) return;
        if (projects.size() == 0) {
            return;
        }
        final ProgressAndTextDialog dialog = new ProgressAndTextDialog(this.getShell());
        try {
            try {
                IRunnableWithProgress runnable = ValidationUIPlugin.getRunnableWithProgress(new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) {
                        ValidationMenuAction.this.validate(monitor, projects, dialog);
                    }
                });
                dialog.run(true, true, runnable);
            }
            catch (InvocationTargetException exc) {
                Logger logger = WTPUIPlugin.getLogger();
                if (logger.isLoggingLevel(Level.SEVERE)) {
                    LogEntry entry = ValidationUIPlugin.getLogEntry();
                    entry.setSourceID("ValidationMenuAction.run(IAction)");
                    entry.setMessageTypeIdentifier("VBF_EXC_INTERNAL");
                    entry.setTargetException((Throwable)exc);
                    logger.write(Level.SEVERE, (Object)entry);
                    if (exc.getTargetException() != null) {
                        entry.setTargetException(exc.getTargetException());
                        logger.write(Level.SEVERE, (Object)entry);
                    }
                }
                String internalErrorMessage = ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL");
                dialog.addText(internalErrorMessage);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Throwable exc) {
                Logger logger = WTPUIPlugin.getLogger();
                if (logger.isLoggingLevel(Level.SEVERE)) {
                    LogEntry entry = ValidationUIPlugin.getLogEntry();
                    entry.setSourceID("ValidationMenuAction.run(IAction)");
                    entry.setMessageTypeIdentifier("VBF_EXC_INTERNAL");
                    entry.setTargetException(exc);
                    logger.write(Level.SEVERE, (Object)entry);
                }
                String internalErrorMessage = ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL");
                dialog.addText(internalErrorMessage);
            }
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            this._selectedResources.clear();
            throw throwable;
        }
        {
            Object var8_14 = null;
            this._selectedResources.clear();
            return;
        }
    }

    void validate(IProgressMonitor monitor, Map projects, ProgressAndTextDialog dialog) {
        boolean cancelled = false;
        Iterator iterator = projects.keySet().iterator();
        while (iterator.hasNext()) {
            String message;
            IProject project = (IProject)iterator.next();
            if (project == null) continue;
            try {
                if (cancelled) {
                    message = ResourceHandler.getExternalizedMessage("VBF_UI_RESCANCELLED", new String[]{project.getName()});
                    dialog.addText(message);
                    continue;
                }
                if (!project.isOpen()) {
                    message = ResourceHandler.getExternalizedMessage("VBF_UI_CLOSED_PROJECT", new String[]{project.getName()});
                    dialog.addText(message);
                    continue;
                }
                this.performValidation(monitor, projects, dialog, project);
            }
            catch (OperationCanceledException operationCanceledException) {
                cancelled = true;
                message = ResourceHandler.getExternalizedMessage("VBF_UI_RESCANCELLED", new String[]{project.getName()});
                dialog.addText(message);
            }
            catch (Throwable exc) {
                this.logException(dialog, project, exc);
            }
        }
    }

    private void logException(ProgressAndTextDialog dialog, IProject project, Throwable exc) {
        Logger logger = WTPUIPlugin.getLogger();
        if (logger.isLoggingLevel(Level.SEVERE)) {
            LogEntry entry = ValidationUIPlugin.getLogEntry();
            entry.setSourceID("ValidationMenuAction.validate");
            entry.setMessageTypeIdentifier("VBF_EXC_INTERNAL");
            entry.setTargetException(exc);
            logger.write(Level.SEVERE, (Object)entry);
        }
        String internalErrorMessage = ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PROJECT", new String[]{project.getName()});
        dialog.addText(internalErrorMessage);
    }

    private void performValidation(IProgressMonitor monitor, Map projects, ProgressAndTextDialog dialog, IProject project) throws CoreException {
        block5: {
            List changedResources = (List)projects.get(project);
            IResource[] resources = null;
            if (changedResources != null) {
                resources = new IResource[changedResources.size()];
                changedResources.toArray(resources);
            }
            try {
                ProjectConfiguration prjp = ConfigurationManager.getManager().getProjectConfiguration(project);
                if (prjp.numberOfEnabledValidators() > 0) {
                    this.checkProjectConfiguration(monitor, dialog, project, resources, prjp);
                } else {
                    String message = ResourceHandler.getExternalizedMessage("VBF_UI_NO_VALIDATORS_ENABLED", new String[]{project.getName()});
                    dialog.addText(message);
                }
            }
            catch (InvocationTargetException exc) {
                Logger logger = ValidationPlugin.getPlugin().getLogger();
                if (!logger.isLoggingLevel(Level.SEVERE)) break block5;
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceIdentifier("ValidationMenuAction::run");
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
                if (exc.getTargetException() == null) break block5;
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
            }
        }
    }

    private void checkProjectConfiguration(IProgressMonitor monitor, ProgressAndTextDialog dialog, IProject project, IResource[] resources, ProjectConfiguration prjp) throws InvocationTargetException, CoreException {
        boolean successful = true;
        Object validOp = null;
        validOp = resources == null ? new EnabledValidatorsOperation(project, prjp.runAsync()) : new EnabledIncrementalValidatorsOperation(resources, project, prjp.runAsync());
        if (validOp.isNecessary(monitor)) {
            ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)validOp, monitor);
        } else if (resources == null) {
            String message = ResourceHandler.getExternalizedMessage("VBF_UI_PRJNEEDINPUT", new String[]{project.getName()});
            dialog.addText(message);
        } else {
            int i = 0;
            while (i < resources.length) {
                String message = ResourceHandler.getExternalizedMessage("VBF_UI_RESNEEDINPUT", new String[]{resources[i].getFullPath().toString()});
                dialog.addText(message);
                ++i;
            }
        }
        if (successful) {
            this.performSucessful(dialog, project, resources);
        } else {
            String internalErrorMessage = ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PROJECT", new String[]{project.getName()});
            dialog.addText(internalErrorMessage);
        }
    }

    private void performSucessful(ProgressAndTextDialog dialog, IProject project, IResource[] resources) {
        boolean limitExceeded = ValidatorManager.getManager().wasValidationTerminated(project);
        if (limitExceeded) {
            String message = ResourceHandler.getExternalizedMessage("VBF_UI_MAX_REPORTED", new String[]{project.getName()});
            dialog.addText(message);
        } else if (resources == null) {
            String message = ResourceHandler.getExternalizedMessage("VBF_UI_PRJVALIDATED", new String[]{project.getName()});
            dialog.addText(message);
        } else {
            int i = 0;
            while (i < resources.length) {
                String message = ResourceHandler.getExternalizedMessage("VBF_UI_RESVALIDATED", new String[]{resources[i].getFullPath().toString()});
                dialog.addText(message);
                ++i;
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        boolean fwkActivated;
        this._currentSelection = selection;
        int count = 0;
        boolean bl = fwkActivated = ValidationPlugin.isActivated() && ValidationRegistryReader.isActivated();
        if (fwkActivated) {
            Map projects;
            ValidateAction vaction = null;
            if (action instanceof ValidateAction) {
                vaction = (ValidateAction)action;
            }
            if ((projects = this.loadSelected(vaction, true)) != null && projects.size() > 0) {
                Iterator iterator = projects.keySet().iterator();
                while (iterator.hasNext()) {
                    block6: {
                        IProject project = (IProject)iterator.next();
                        if (project == null || !project.isOpen()) continue;
                        try {
                            ProjectConfiguration prjp = ConfigurationManager.getManager().getProjectConfigurationWithoutMigrate(project);
                            count += prjp.numberOfEnabledValidators();
                        }
                        catch (InvocationTargetException exc) {
                            Logger logger = ValidationPlugin.getPlugin().getLogger();
                            if (!logger.isLoggingLevel(Level.SEVERE)) break block6;
                            LogEntry entry = ValidationPlugin.getLogEntry();
                            entry.setSourceIdentifier("ValidationMenuAction::selectionChanged");
                            entry.setTargetException((Throwable)exc);
                            logger.write(Level.SEVERE, (Object)entry);
                            if (exc.getTargetException() == null) break block6;
                            entry.setTargetException((Throwable)exc);
                            logger.write(Level.SEVERE, (Object)entry);
                        }
                    }
                    if (count > 0) break;
                }
            }
        }
        action.setEnabled(count > 0 || !fwkActivated);
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    public void init(IAction action) {
    }

    public void dispose() {
    }

    public void init(IViewPart view) {
    }
}

