/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.update.standalone.InstallCommand;
import org.eclipse.wst.server.core.internal.IInstallableServer;
import org.eclipse.wst.server.core.internal.Messages;
import org.eclipse.wst.server.core.internal.Trace;

public class InstallableServer
implements IInstallableServer {
    private IConfigurationElement element;

    public InstallableServer(IConfigurationElement element) {
        this.element = element;
    }

    public String getId() {
        try {
            return this.element.getAttribute("id");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getName() {
        try {
            return this.element.getAttribute("name");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getDescription() {
        try {
            return this.element.getAttribute("description");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getVendor() {
        try {
            String vendor = this.element.getAttribute("vendor");
            if (vendor != null) {
                return vendor;
            }
        }
        catch (Exception exception) {}
        return Messages.defaultVendor;
    }

    public String getVersion() {
        try {
            String version = this.element.getAttribute("version");
            if (version != null) {
                return version;
            }
        }
        catch (Exception exception) {}
        return Messages.defaultVersion;
    }

    public String getFeatureVersion() {
        try {
            return this.element.getAttribute("featureVersion");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getFeatureId() {
        try {
            return this.element.getAttribute("featureId");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getFromSite() {
        try {
            return this.element.getAttribute("featureSite");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void install(IProgressMonitor monitor) throws CoreException {
        String featureId = this.getFeatureId();
        String featureVersion = this.getFeatureVersion();
        String fromSite = this.getFromSite();
        if (featureId == null || featureVersion == null || fromSite == null) {
            return;
        }
        try {
            InstallCommand command = new InstallCommand(featureId, featureVersion, fromSite, null, "false");
            command.run(monitor);
            command.applyChangesNow();
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error installing feature", e);
        }
    }

    public String toString() {
        return "InstallableServer[" + this.getId() + ", " + this.getName() + "]";
    }
}

