/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.application.internal.operations;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.application.internal.operations.ClassPathSelection;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.componentcore.UnresolveableURIException;
import org.eclipse.wst.common.componentcore.internal.impl.ModuleURIUtil;

public class ClasspathElement {
    public static final int UTIL_JAR = 0;
    public static final int EJB_JAR = 1;
    public static final int EJB_CLIENT_JAR = 2;
    protected int jarType = 0;
    protected Archive archive;
    protected Archive targetArchive;
    protected String text;
    protected boolean selected;
    protected boolean valid;
    protected String relativeText;
    protected IProject project;
    protected List importedJarPaths;
    protected IProject earProject;
    protected ClassPathSelection parentSelection;
    protected URI archiveURI;
    protected String earContentFolder;

    public ClasspathElement(Archive anArchive) {
        this.archive = anArchive;
    }

    public ClasspathElement(IProject project) {
        this.project = project;
    }

    public ClasspathElement(URI aArchiveURI) {
        this.archiveURI = aArchiveURI;
    }

    protected void computeRelativeText() {
        if (this.archive != null) {
            this.relativeText = J2EEProjectUtilities.computeRelativeText(this.archive.getURI(), this.getText());
            if (this.relativeText == null) {
                this.relativeText = this.getText();
            }
        }
    }

    public IProject getEarProject() {
        return this.earProject;
    }

    protected IFile getImportedJarAsIFile() {
        IFile file;
        if (this.getProject() != null && this.getText() != null && this.getText().endsWith(".imported_classes.jar") && (file = this.getProject().getFile(this.getText())) != null && file.exists()) {
            return file;
        }
        return null;
    }

    public List getImportedJarPaths() {
        return this.importedJarPaths;
    }

    public int getJarType() {
        return this.jarType;
    }

    public IProject getProject() {
        return this.project;
    }

    public String getProjectName() {
        return this.project == null ? null : this.project.getName();
    }

    public String getRelativeText() {
        if (this.relativeText == null) {
            this.computeRelativeText();
        }
        return this.relativeText;
    }

    public String getText() {
        return this.text;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean isValid() {
        return this.valid;
    }

    public IResource getResource() {
        if (this.project != null) {
            return this.project;
        }
        return this.earProject.getFile(this.getText());
    }

    public IClasspathEntry[] newClasspathEntriesForArchive() {
        if (!this.archiveURI.equals((Object)"")) {
            String resourcePath = "";
            try {
                resourcePath = ModuleURIUtil.getArchiveName((URI)this.archiveURI);
            }
            catch (UnresolveableURIException e) {
                Logger.getLogger().logError((Throwable)e);
            }
            File file = new File(resourcePath);
            if (file.exists()) {
                return new IClasspathEntry[]{JavaCore.newLibraryEntry((IPath)new Path(resourcePath), null, null, (boolean)true)};
            }
            return new IClasspathEntry[]{JavaCore.newVariableEntry((IPath)new Path(resourcePath), null, null)};
        }
        return new IClasspathEntry[0];
    }

    public IClasspathEntry[] newClasspathEntries(Set visited) {
        if (visited.contains(this)) {
            return new IClasspathEntry[0];
        }
        visited.add(this);
        if (this.representsImportedJar()) {
            return new IClasspathEntry[]{JavaCore.newLibraryEntry((IPath)this.getImportedJarAsIFile().getFullPath(), null, null)};
        }
        if (this.archiveURI != null && !this.archiveURI.equals((Object)"")) {
            return this.newClasspathEntriesForArchive();
        }
        if (!this.valid && this.isSelected()) {
            return new IClasspathEntry[0];
        }
        if (this.project == null) {
            return this.newClasspathEntriesFromEARProject(visited);
        }
        IClasspathEntry projectEntry = JavaCore.newProjectEntry((IPath)this.getProject().getFullPath(), (boolean)true);
        if (this.importedJarPaths == null || this.importedJarPaths.isEmpty()) {
            return new IClasspathEntry[]{projectEntry};
        }
        ArrayList<IClasspathEntry> result = new ArrayList<IClasspathEntry>(2);
        result.add(projectEntry);
        int i = 0;
        while (i < this.importedJarPaths.size()) {
            IPath path = (IPath)this.importedJarPaths.get(i);
            result.add(JavaCore.newLibraryEntry((IPath)path, null, null));
            ++i;
        }
        return result.toArray(new IClasspathEntry[result.size()]);
    }

    public IClasspathEntry[] newClasspathEntries() {
        return this.newClasspathEntries(new HashSet());
    }

    protected IClasspathEntry newClasspathEntryFromEARProj() {
        IPath path = this.earProject.getFullPath().append(String.valueOf(this.getEarContentFolder()) + '/' + this.earProject.getFile(this.getText()).getProjectRelativePath());
        return JavaCore.newLibraryEntry((IPath)path, (IPath)path, null, (boolean)true);
    }

    protected IClasspathEntry[] newClasspathEntriesFromEARProject(Set visited) {
        ArrayList<IClasspathEntry> cpEntries = new ArrayList<IClasspathEntry>();
        cpEntries.add(this.newClasspathEntryFromEARProj());
        this.traverseClasspaths(cpEntries, visited);
        return cpEntries.toArray(new IClasspathEntry[cpEntries.size()]);
    }

    protected void traverseClasspaths(List projectCpEntries, Set visited) {
        org.eclipse.jst.j2ee.commonarchivecore.internal.File aFile = null;
        try {
            aFile = this.getEARFile().getFile(this.getText());
        }
        catch (FileNotFoundException fileNotFoundException) {}
        if (aFile == null || !aFile.isArchive()) {
            return;
        }
        Archive depArchive = (Archive)aFile;
        String[] manifestCpEntries = depArchive.getManifest().getClassPathTokenized();
        int i = 0;
        while (i < manifestCpEntries.length) {
            ClasspathElement other;
            String uri = ArchiveUtil.deriveEARRelativeURI((String)manifestCpEntries[i], (Archive)depArchive);
            if (uri != null && (other = this.parentSelection.getClasspathElement(uri)) != null && !other.isSelected()) {
                IClasspathEntry[] cpEntries = other.newClasspathEntries(visited);
                int j = 0;
                while (j < cpEntries.length) {
                    if (!projectCpEntries.contains(cpEntries[j])) {
                        projectCpEntries.add(cpEntries[j]);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public boolean representsImportedJar() {
        return this.getImportedJarAsIFile() != null;
    }

    public void setEarProject(IProject newEarProject) {
        this.earProject = newEarProject;
    }

    public void setImportedJarPaths(List newImportedJarPaths) {
        this.importedJarPaths = newImportedJarPaths;
    }

    public void setJarType(int newJarType) {
        this.jarType = newJarType;
    }

    public void setProject(IProject newProject) {
        this.project = newProject;
    }

    public void setRelativeText(String newRelativeText) {
        this.relativeText = newRelativeText;
    }

    public void setSelected(Archive referencingJar, Archive referencedJar, List classPath) {
        int i = 0;
        while (i < classPath.size()) {
            String cpEntry = (String)classPath.get(i);
            String uri = ArchiveUtil.deriveEARRelativeURI((String)cpEntry, (Archive)referencingJar);
            if (uri != null && uri.equals(referencedJar.getURI())) {
                this.setSelected(true);
                return;
            }
            ++i;
        }
        this.setSelected(false);
    }

    public void setSelected(boolean newSelected) {
        boolean oldSelected = this.selected;
        this.selected = newSelected;
        if (oldSelected != newSelected && this.parentSelection != null) {
            this.parentSelection.setModified(true);
        }
    }

    public void setText(String newText) {
        this.text = newText;
    }

    public void setValid(boolean newValid) {
        this.valid = newValid;
    }

    public void setValuesSelected(String cpEntry) {
        this.setSelected(true);
        this.setRelativeText(cpEntry);
    }

    public String toString() {
        return "ClasspatheElement(" + this.getText() + ")";
    }

    protected EARFile getEARFile() {
        return (EARFile)this.archive.getContainer();
    }

    void setParentSelection(ClassPathSelection selection) {
        this.parentSelection = selection;
    }

    public Archive getArchive() {
        return this.archive;
    }

    public boolean isEJBJar() {
        return this.jarType == 1;
    }

    public boolean isEJBClientJar() {
        return this.jarType == 2;
    }

    public Archive getTargetArchive() {
        return this.targetArchive;
    }

    public void setTargetArchive(Archive archive) {
        this.targetArchive = archive;
    }

    public URI getArchiveURI() {
        return this.archiveURI;
    }

    public String getEarContentFolder() {
        return this.earContentFolder;
    }

    public void setEarContentFolder(String earContentFolder) {
        this.earContentFolder = earContentFolder;
    }
}

