/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.archive.operations;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.SaveFailureException;
import org.eclipse.jst.j2ee.internal.archive.operations.EJBArchiveOpsResourceHandler;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public abstract class J2EEArtifactExportOperation
extends AbstractDataModelOperation {
    protected IProgressMonitor progressMonitor;
    private IVirtualComponent component;
    private IPath destinationPath;
    private ModuleFile moduleFile;
    private boolean exportSource = false;

    public J2EEArtifactExportOperation() {
    }

    public J2EEArtifactExportOperation(IDataModel model) {
        super(model);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.setComponent((IVirtualComponent)this.model.getProperty("IJ2EEComponentExportDataModelProperties.COMPONENT"));
        this.setDestinationPath((IPath)new Path(this.model.getStringProperty("IJ2EEComponentExportDataModelProperties.ARCHIVE_DESTINATION")));
        this.setExportSource(this.model.getBooleanProperty("IJ2EEComponentExportDataModelProperties.EXPORT_SOURCE_FILES"));
        try {
            this.setProgressMonitor(monitor);
            this.component.getProject().refreshLocal(2, null);
            if (this.model.getBooleanProperty("IJ2EEComponentExportDataModelProperties.RUN_BUILD")) {
                this.runNecessaryBuilders(this.component, monitor);
            }
            this.export();
        }
        catch (Exception e) {
            throw new ExecutionException(String.valueOf(EJBArchiveOpsResourceHandler.Error_exporting__UI_) + this.archiveString(), (Throwable)e);
        }
        return OK_STATUS;
    }

    protected abstract void export() throws SaveFailureException, CoreException, InvocationTargetException, InterruptedException;

    protected abstract String archiveString();

    protected void setProgressMonitor(IProgressMonitor newProgressMonitor) {
        this.progressMonitor = newProgressMonitor;
    }

    protected IProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    private void setComponent(IVirtualComponent newComponent) {
        this.component = newComponent;
    }

    protected IVirtualComponent getComponent() {
        if (this.component == null) {
            this.component = (IVirtualComponent)this.model.getProperty("IJ2EEComponentExportDataModelProperties.COMPONENT");
        }
        return this.component;
    }

    protected IPath getDestinationPath() {
        return this.destinationPath;
    }

    protected void setDestinationPath(IPath newDestinationPath) {
        this.destinationPath = newDestinationPath;
    }

    protected boolean isExportSource() {
        return this.exportSource;
    }

    protected void setExportSource(boolean newExportSource) {
        this.exportSource = newExportSource;
    }

    protected ModuleFile getModuleFile() {
        return this.moduleFile;
    }

    protected void setModuleFile(ModuleFile newModuleFile) {
        this.moduleFile = newModuleFile;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return null;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return null;
    }

    protected void runNecessaryBuilders(IVirtualComponent component, IProgressMonitor monitor) throws CoreException {
        ICommand libCopyBuilder;
        IProject project = component.getProject();
        IProjectDescription description = project.getDescription();
        ICommand javaBuilder = this.getJavaCommand(description);
        if (javaBuilder != null) {
            project.build(10, "org.eclipse.jdt.core.javabuilder", javaBuilder.getArguments(), monitor);
        }
        if ((libCopyBuilder = this.getLibCopyBuilder(description)) != null) {
            project.build(10, "org.eclipse.jst.j2ee.LibCopyBuilder", libCopyBuilder.getArguments(), monitor);
        }
    }

    protected ICommand getJavaCommand(IProjectDescription description) throws CoreException {
        if (description == null) {
            return null;
        }
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals("org.eclipse.jdt.core.javabuilder")) {
                return commands[i];
            }
            ++i;
        }
        return null;
    }

    protected ICommand getLibCopyBuilder(IProjectDescription description) throws CoreException {
        if (description == null) {
            return null;
        }
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals("org.eclipse.jst.j2ee.LibCopyBuilder")) {
                return commands[i];
            }
            ++i;
        }
        return null;
    }

    public ISchedulingRule getSchedulingRule() {
        Set projs = this.gatherDependentProjects(this.getComponent(), new HashSet());
        ISchedulingRule combinedRule = null;
        IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
        Iterator iter = projs.iterator();
        while (iter.hasNext()) {
            IProject proj = (IProject)iter.next();
            ISchedulingRule rule = ruleFactory.createRule((IResource)proj);
            combinedRule = MultiRule.combine((ISchedulingRule)rule, (ISchedulingRule)combinedRule);
        }
        combinedRule = MultiRule.combine((ISchedulingRule)ruleFactory.buildRule(), combinedRule);
        return combinedRule;
    }

    private Set gatherDependentProjects(IVirtualComponent comp, Set projs) {
        if (!projs.contains(comp.getProject())) {
            projs.add(comp.getProject());
            IVirtualReference[] refs = comp.getReferences();
            int i = 0;
            while (i < refs.length) {
                IVirtualReference refComp = refs[i];
                projs.addAll(this.gatherDependentProjects(refComp.getReferencedComponent(), projs));
                ++i;
            }
        }
        return projs;
    }
}

