/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.project.facet;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.internal.earcreation.EarFacetInstallDataModelProvider;
import org.eclipse.jst.j2ee.internal.project.ManifestFileCreationAction;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public abstract class J2EEFacetInstallDelegate {
    protected void installEARFacet(String j2eeVersionText, String earProjectName, IRuntime runtime, IProgressMonitor monitor) {
        IProject project = ProjectUtilities.getProject((String)earProjectName);
        if (project.exists()) {
            return;
        }
        try {
            IFacetedProject facetProj = ProjectFacetsManager.create((String)earProjectName, null, (IProgressMonitor)monitor);
            facetProj.setRuntime(runtime, monitor);
            IDataModel earFacetInstallDataModel = DataModelFactory.createDataModel((IDataModelProvider)new EarFacetInstallDataModelProvider());
            earFacetInstallDataModel.setProperty("IFacetDataModelPropeties.FACET_PROJECT_NAME", (Object)earProjectName);
            earFacetInstallDataModel.setProperty("IFacetDataModelPropeties.FACET_VERSION_STR", (Object)j2eeVersionText);
            HashSet<IFacetedProject.Action> actions = new HashSet<IFacetedProject.Action>();
            actions.add(new IFacetedProject.Action((IFacetedProject.Action.Type)earFacetInstallDataModel.getProperty("IFacetDataModelPropeties.FACET_TYPE"), (IProjectFacetVersion)earFacetInstallDataModel.getProperty("IFacetDataModelPropeties.FACET_VERSION"), (Object)earFacetInstallDataModel));
            facetProj.modify(actions, null);
        }
        catch (CoreException e) {
            Logger.getLogger().logError((Throwable)e);
        }
    }

    protected void createManifest(IProject project, IContainer aFolder, IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        IFile file = aFolder.getFile((IPath)new Path("META-INF/MANIFEST.MF"));
        if (file.exists()) {
            return;
        }
        try {
            ManifestFileCreationAction.createManifestFile(file, project);
        }
        catch (CoreException e) {
            Logger.getLogger().log((Throwable)e);
        }
        catch (IOException e) {
            Logger.getLogger().log((Throwable)e);
        }
    }
}

