/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.refactor.operations;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;

public class ProjectRefactorMetadata {
    public static int NON_CACHING = 0;
    public static int REF_CACHING = 1;
    public static int REFERER_CACHING = 2;
    private int _virtualCompCaching = NON_CACHING;
    private final IProject _project;
    private IServer[] servers;
    private IVirtualComponent virtualComp = null;
    private final List dependentMetadata = new ArrayList();
    private boolean computed = false;
    private boolean javaNature;
    private boolean moduleCoreNature;
    private IModule module;
    private boolean isEAR = false;
    private boolean isEJB = false;
    private boolean isWeb = false;
    private boolean isAppClient = false;
    private boolean isConnector = false;
    private boolean isUtility = false;

    public ProjectRefactorMetadata(IProject project) {
        this._project = project;
    }

    public ProjectRefactorMetadata(IProject project, int virtualCompCaching) {
        this(project);
        this._virtualCompCaching = virtualCompCaching;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void computeMetadata() {
        try {
            try {
                this.javaNature = this._project.hasNature("org.eclipse.jdt.core.javanature");
                boolean bl = this.moduleCoreNature = ModuleCoreNature.getModuleCoreNature((IProject)this._project) != null;
                if (this.moduleCoreNature) {
                    this.virtualComp = this._virtualCompCaching == REF_CACHING ? new RefCachingVirtualComponent(ComponentCore.createComponent((IProject)this._project)) : (this._virtualCompCaching == REFERER_CACHING ? new RefererCachingVirtualComponent(ComponentCore.createComponent((IProject)this._project)) : ComponentCore.createComponent((IProject)this._project));
                    IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)this._project);
                    this.module = ServerUtil.getModule((IProject)this._project);
                    this.isEAR = facetedProject.hasProjectFacet(ProjectFacetsManager.getProjectFacet((String)"jst.ear"));
                    this.isEJB = facetedProject.hasProjectFacet(ProjectFacetsManager.getProjectFacet((String)"jst.ejb"));
                    this.isWeb = facetedProject.hasProjectFacet(ProjectFacetsManager.getProjectFacet((String)"jst.web"));
                    this.isAppClient = facetedProject.hasProjectFacet(ProjectFacetsManager.getProjectFacet((String)"jst.appclient"));
                    this.isConnector = facetedProject.hasProjectFacet(ProjectFacetsManager.getProjectFacet((String)"jst.connector"));
                    this.isUtility = facetedProject.hasProjectFacet(ProjectFacetsManager.getProjectFacet((String)"jst.utility"));
                }
            }
            catch (CoreException ce) {
                Logger.getLogger().logError((Throwable)ce);
            }
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            this.computed = true;
            throw throwable;
        }
        {
            Object var2_5 = null;
            this.computed = true;
            return;
        }
    }

    public void computeServers() {
        if (!this.computed) {
            this.computeMetadata();
        }
        this.servers = ServerUtil.getServersByModule((IModule)this.module, null);
    }

    public IServer[] getServers() {
        return this.servers;
    }

    public void computeDependentMetadata(int virtualComponentCaching, IProject[] dependentProjects) {
        int i = 0;
        while (i < dependentProjects.length) {
            ProjectRefactorMetadata metadata = new ProjectRefactorMetadata(dependentProjects[i], virtualComponentCaching);
            metadata.computeMetadata();
            this.dependentMetadata.add(metadata);
            ++i;
        }
    }

    public IProject getProject() {
        return this._project;
    }

    public IModule getModule() {
        if (!this.computed) {
            this.computeMetadata();
        }
        return this.module;
    }

    public String getProjectName() {
        return this._project.getName();
    }

    public ProjectRefactorMetadata[] getDependentMetadata() {
        return this.dependentMetadata.toArray(new ProjectRefactorMetadata[this.dependentMetadata.size()]);
    }

    public IVirtualComponent getVirtualComponent() {
        if (!this.computed) {
            this.computeMetadata();
        }
        return this.virtualComp;
    }

    public boolean hasJavaNature() {
        if (!this.computed) {
            this.computeMetadata();
        }
        return this.javaNature;
    }

    public boolean hasModuleCoreNature() {
        if (!this.computed) {
            this.computeMetadata();
        }
        return this.moduleCoreNature;
    }

    public boolean isEAR() {
        if (!this.computed) {
            this.computeMetadata();
        }
        return this.isEAR;
    }

    public boolean isEJB() {
        if (!this.computed) {
            this.computeMetadata();
        }
        return this.isEJB;
    }

    public boolean isWeb() {
        if (!this.computed) {
            this.computeMetadata();
        }
        return this.isWeb;
    }

    public boolean isAppClient() {
        if (!this.computed) {
            this.computeMetadata();
        }
        return this.isAppClient;
    }

    public boolean isConnector() {
        if (!this.computed) {
            this.computeMetadata();
        }
        return this.isConnector;
    }

    public boolean isUtility() {
        if (!this.computed) {
            this.computeMetadata();
        }
        return this.isUtility;
    }

    public class CachingVirtualComponent
    implements IVirtualComponent {
        protected final IVirtualComponent _comp;
        protected boolean _caching = true;

        public CachingVirtualComponent(IVirtualComponent comp) {
            this._comp = comp;
        }

        public void addReferences(IVirtualReference[] references) {
            this._comp.addReferences(references);
        }

        public void create(int updateFlags, IProgressMonitor aMonitor) throws CoreException {
            this._comp.create(updateFlags, aMonitor);
        }

        public boolean exists() {
            return this._comp.exists();
        }

        public IVirtualComponent getComponent() {
            return this._comp.getComponent();
        }

        public Properties getMetaProperties() {
            return this._comp.getMetaProperties();
        }

        public IPath[] getMetaResources() {
            return this._comp.getMetaResources();
        }

        public String getName() {
            return this._comp.getName();
        }

        public IProject getProject() {
            return this._comp.getProject();
        }

        public IVirtualReference getReference(String aComponentName) {
            return this._comp.getReference(aComponentName);
        }

        public IVirtualReference[] getReferences() {
            return this._comp.getReferences();
        }

        public void setCaching(boolean caching) {
            this._caching = caching;
        }

        public IVirtualComponent[] getReferencingComponents() {
            return this._comp.getReferencingComponents();
        }

        public IVirtualFolder getRootFolder() {
            return this._comp.getRootFolder();
        }

        public boolean isBinary() {
            return this._comp.isBinary();
        }

        public void setMetaProperties(Properties properties) {
            this._comp.setMetaProperties(properties);
        }

        public void setMetaProperty(String name, String value) {
            this._comp.setMetaProperty(name, value);
        }

        public void setMetaResources(IPath[] theMetaResourcePaths) {
            this._comp.setMetaResources(theMetaResourcePaths);
        }

        public void setReferences(IVirtualReference[] theReferences) {
            this._comp.setReferences(theReferences);
        }

        public Object getAdapter(Class adapter) {
            return this._comp.getAdapter(adapter);
        }

        public boolean equals(Object o) {
            return this._comp.equals(o);
        }

        public int hashCode() {
            return this._comp.hashCode();
        }

        public String toString() {
            return this._comp.toString();
        }
    }

    public class RefCachingVirtualComponent
    extends CachingVirtualComponent {
        private IVirtualReference[] cachedRefs;

        public RefCachingVirtualComponent(IVirtualComponent comp) {
            super(comp);
            this.cachedRefs = comp.getReferences();
        }

        public IVirtualReference getReference(String aComponentName) {
            IVirtualReference[] refs = this.getReferences();
            int i = 0;
            while (i < refs.length) {
                IVirtualReference reference = refs[i];
                if (reference.getReferencedComponent().getName().equals(aComponentName)) {
                    return reference;
                }
                ++i;
            }
            return null;
        }

        public IVirtualReference[] getReferences() {
            if (this._caching) {
                return this.cachedRefs;
            }
            return super.getReferences();
        }
    }

    public class RefererCachingVirtualComponent
    extends CachingVirtualComponent {
        private IVirtualComponent[] cachedReferers;

        public RefererCachingVirtualComponent(IVirtualComponent comp) {
            super(comp);
            this.cachedReferers = comp.getReferencingComponents();
        }

        public IVirtualComponent[] getReferencingComponents() {
            if (this._caching) {
                return this.cachedReferers;
            }
            return this._comp.getReferencingComponents();
        }
    }
}

