/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.refactor.operations;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Manifest;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.j2ee.application.internal.operations.UpdateManifestDataModelProvider;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifestImpl;
import org.eclipse.jst.j2ee.internal.common.operations.JARDependencyDataModelProvider;
import org.eclipse.jst.j2ee.refactor.RefactorResourceHandler;
import org.eclipse.jst.j2ee.refactor.operations.ProjectRefactorMetadata;
import org.eclipse.jst.j2ee.refactor.operations.UpdateDependentProjectOp;
import org.eclipse.wst.common.componentcore.internal.operation.RemoveReferenceComponentsDataModelProvider;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

public class UpdateDependentModuleonDeleteOp
extends UpdateDependentProjectOp {
    public UpdateDependentModuleonDeleteOp(IDataModel model) {
        super(model);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        ProjectRefactorMetadata dependentMetadata = (ProjectRefactorMetadata)this.model.getProperty("ProjectRefactoringProperties.DEPENDENT_PROJECT_METADATA");
        ProjectRefactorMetadata refactoredMetadata = (ProjectRefactorMetadata)this.model.getProperty("ProjectRefactoringProperties.PROJECT_METADATA");
        UpdateDependentModuleonDeleteOp.removeModuleDependency(dependentMetadata, refactoredMetadata);
        return Status.OK_STATUS;
    }

    protected static void removeModuleDependency(ProjectRefactorMetadata dependentMetadata, ProjectRefactorMetadata refactoredMetadata) throws ExecutionException {
        IVirtualComponent dependentComp = dependentMetadata.getVirtualComponent();
        IVirtualComponent refactoredComp = refactoredMetadata.getVirtualComponent();
        NullProgressMonitor monitor = new NullProgressMonitor();
        if (refactoredComp != null) {
            IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new RemoveReferenceComponentsDataModelProvider());
            model.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", (Object)dependentComp);
            List modHandlesList = (List)model.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT");
            modHandlesList.add(refactoredComp);
            model.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", (Object)modHandlesList);
            model.getDefaultOperation().execute((IProgressMonitor)monitor, null);
        }
        UpdateDependentModuleonDeleteOp.updateManifestDependency(refactoredMetadata, dependentMetadata, true);
        IDataModel dataModel = DataModelFactory.createDataModel((IDataModelProvider)new JARDependencyDataModelProvider());
        dataModel.setProperty("UpdateManifestDataModel.PROJECT_NAME", (Object)dependentMetadata.getProjectName());
        dataModel.setProperty("AbstractJARDependencyDataModel.REFERENCED_PROJECT_NAME", (Object)refactoredMetadata.getProjectName());
        dataModel.setIntProperty("AbstractJARDependencyDataModel.JAR_MANIPULATION_TYPE", 1);
        dataModel.getDefaultOperation().execute((IProgressMonitor)monitor, null);
    }

    protected static void updateManifestDependency(ProjectRefactorMetadata refactoredMetadata, ProjectRefactorMetadata dependentMetadata, boolean remove) throws ExecutionException {
        IVirtualComponent dependentComp = dependentMetadata.getVirtualComponent();
        String dependentProjName = dependentMetadata.getProjectName();
        String refactoredProjName = refactoredMetadata.getProjectName();
        IVirtualFile vf = dependentComp.getRootFolder().getFile((IPath)new Path("META-INF/MANIFEST.MF"));
        IFile manifestmf = vf.getUnderlyingFile();
        NullProgressMonitor monitor = new NullProgressMonitor();
        IDataModel updateManifestDataModel = DataModelFactory.createDataModel((IDataModelProvider)new UpdateManifestDataModelProvider());
        updateManifestDataModel.setProperty("UpdateManifestDataModel.PROJECT_NAME", (Object)dependentProjName);
        updateManifestDataModel.setBooleanProperty("UpdateManifestDataModel.MERGE", false);
        updateManifestDataModel.setProperty("UpdateManifestDataModel.MANIFEST_FILE", (Object)manifestmf);
        ArchiveManifest manifest = UpdateDependentModuleonDeleteOp.getArchiveManifest(manifestmf);
        String[] cp = manifest.getClassPathTokenized();
        ArrayList<String> cpList = new ArrayList<String>();
        String newCp = String.valueOf(refactoredProjName) + ".jar";
        int i = 0;
        while (i < cp.length) {
            if (!cp[i].equals(newCp)) {
                cpList.add(cp[i]);
            }
            ++i;
        }
        if (!remove) {
            cpList.add(newCp);
        }
        updateManifestDataModel.setProperty("UpdateManifestDataModel.CLASSPATH_LIST", cpList);
        updateManifestDataModel.getDefaultOperation().execute((IProgressMonitor)monitor, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ArchiveManifest getArchiveManifest(IFile manifestFile) throws ExecutionException {
        ArchiveManifestImpl archiveManifestImpl;
        InputStream in = null;
        try {
            try {
                ArchiveManifestImpl mf;
                in = manifestFile.getContents();
                archiveManifestImpl = mf = new ArchiveManifestImpl(new Manifest(in));
                Object var3_6 = null;
                if (in == null) return archiveManifestImpl;
            }
            catch (CoreException ce) {
                throw new ExecutionException(RefactorResourceHandler.getString("error_reading_manifest"), (Throwable)ce);
            }
            catch (IOException io) {
                throw new ExecutionException(RefactorResourceHandler.getString("error_reading_manifest"), (Throwable)io);
            }
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw throwable;
            }
        }
        try {}
        catch (IOException iOException) {}
        in.close();
        return archiveManifestImpl;
    }
}

