/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.navigator.internal.actions;

import java.util.Iterator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dialogs.PropertyDialog;
import org.eclipse.ui.internal.dialogs.PropertyPageContributorManager;
import org.eclipse.ui.internal.dialogs.PropertyPageManager;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.wst.common.navigator.internal.provisional.views.AdaptabilityUtility;

public class PropertyDialogAction
extends SelectionProviderAction {
    private Shell shell;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public PropertyDialogAction(Shell shell, ISelectionProvider provider) {
        super(provider, WorkbenchMessages.PropertyDialog_text);
        Assert.isNotNull((Object)shell);
        this.shell = shell;
        this.setToolTipText(WorkbenchMessages.PropertyDialog_toolTip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.property_dialog_action_context");
    }

    private String getName(IAdaptable element) {
        IWorkbenchAdapter adapter;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = (IWorkbenchAdapter)element.getAdapter((Class)clazz)) != null) {
            return adapter.getLabel((Object)element);
        }
        return "";
    }

    private boolean hasPropertyPagesFor(Object object) {
        PropertyPageContributorManager manager = PropertyPageContributorManager.getManager();
        return manager.hasContributorsFor(object);
    }

    public boolean isApplicableForSelection() {
        if (!this.isEnabled()) {
            return false;
        }
        return this.isApplicableForSelection(this.getStructuredSelection());
    }

    public boolean isApplicableForSelection(IStructuredSelection selection) {
        return selection.size() == 1 && this.hasPropertyPagesFor(selection.getFirstElement());
    }

    private IAdaptable getAdaptableElement() {
        Object firstElement = this.getStructuredSelection().getFirstElement();
        if (firstElement instanceof IAdaptable) {
            return (IAdaptable)firstElement;
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.core.resources.IProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((firstElement = AdaptabilityUtility.getAdapter((Object)firstElement, (Class)clazz)) instanceof IAdaptable) {
            return (IAdaptable)firstElement;
        }
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((firstElement = AdaptabilityUtility.getAdapter((Object)firstElement, (Class)clazz2)) instanceof IAdaptable) {
            return (IAdaptable)firstElement;
        }
        return null;
    }

    public void run() {
        PropertyPageManager pageManager = new PropertyPageManager();
        String title = "";
        IAdaptable element = this.getAdaptableElement();
        if (element == null) {
            return;
        }
        PropertyPageContributorManager.getManager().contribute(pageManager, element);
        Iterator pages = pageManager.getElements(0).iterator();
        String name = this.getName(element);
        if (!pages.hasNext()) {
            MessageDialog.openInformation((Shell)this.shell, (String)WorkbenchMessages.PropertyDialog_messageTitle, (String)WorkbenchMessages.bind((String)"PropertyDialog.noPropertyMessage", (Object[])new Object[]{name}));
            return;
        }
        title = WorkbenchMessages.bind((String)WorkbenchMessages.PropertyDialog_propertyMessage, (Object[])new Object[]{name});
        PropertyDialog propertyDialog = new PropertyDialog(this.shell, (PreferenceManager)pageManager, (ISelection)this.getStructuredSelection());
        propertyDialog.create();
        propertyDialog.getShell().setText(title);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)propertyDialog.getShell(), "org.eclipse.ui.property_dialog_context");
        propertyDialog.open();
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(selection.size() == 1 && selection.getFirstElement() != null);
    }
}

